package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for the identity zone consent configuration
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_Consent", generator = "Immutables")
public final class Consent extends org.cloudfoundry.uaa.identityzones._Consent {
  private final String link;
  private final String text;

  private Consent(Consent.Builder builder) {
    this.link = builder.link;
    this.text = builder.text;
  }

  /**
   * The consent link
   */
  @JsonProperty("link")
  @Override
  public String getLink() {
    return link;
  }

  /**
   * The consent text
   */
  @JsonProperty("text")
  @Override
  public String getText() {
    return text;
  }

  /**
   * This instance is equal to all instances of {@code Consent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Consent
        && equalTo((Consent) another);
  }

  private boolean equalTo(Consent another) {
    return link.equals(another.link)
        && text.equals(another.text);
  }

  /**
   * Computes a hash code from attributes: {@code link}, {@code text}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + link.hashCode();
    h += (h << 5) + text.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Consent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Consent{"
        + "link=" + link
        + ", text=" + text
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Consent {
    String link;
    String text;
    @JsonProperty("link")
    public void setLink(String link) {
      this.link = link;
    }
    @JsonProperty("text")
    public void setText(String text) {
      this.text = text;
    }
    @Override
    public String getLink() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Consent fromJson(Json json) {
    Consent.Builder builder = Consent.builder();
    if (json.link != null) {
      builder.link(json.link);
    }
    if (json.text != null) {
      builder.text(json.text);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Consent Consent}.
   * @return A new Consent builder
   */
  public static Consent.Builder builder() {
    return new Consent.Builder();
  }

  /**
   * Builds instances of type {@link Consent Consent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_LINK = 0x1L;
    private static final long INIT_BIT_TEXT = 0x2L;
    private long initBits = 0x3L;

    private String link;
    private String text;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Consent} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Consent instance) {
      return from((_Consent) instance);
    }

    /**
     * Copy abstract value type {@code _Consent} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Consent instance) {
      Objects.requireNonNull(instance, "instance");
      link(instance.getLink());
      text(instance.getText());
      return this;
    }

    /**
     * Initializes the value for the {@link Consent#getLink() link} attribute.
     * @param link The value for link 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("link")
    public final Builder link(String link) {
      this.link = Objects.requireNonNull(link, "link");
      initBits &= ~INIT_BIT_LINK;
      return this;
    }

    /**
     * Initializes the value for the {@link Consent#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("text")
    public final Builder text(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Builds a new {@link Consent Consent}.
     * @return An immutable instance of Consent
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Consent build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new Consent(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_LINK) != 0) attributes.add("link");
      if ((initBits & INIT_BIT_TEXT) != 0) attributes.add("text");
      return "Cannot build Consent, some of required attributes are not set " + attributes;
    }
  }
}
