package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the identity zone self service link
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_SelfServiceLink", generator = "Immutables")
public final class SelfServiceLink extends org.cloudfoundry.uaa.identityzones._SelfServiceLink {
  private final @Nullable String resetPasswordLink;
  private final @Nullable Boolean selfServiceLinksEnabled;
  private final @Nullable String signupLink;

  private SelfServiceLink(SelfServiceLink.Builder builder) {
    this.resetPasswordLink = builder.resetPasswordLink;
    this.selfServiceLinksEnabled = builder.selfServiceLinksEnabled;
    this.signupLink = builder.signupLink;
  }

  /**
   * Where users are directed upon clicking the password reset link.
   */
  @JsonProperty("passwd")
  @Override
  public @Nullable String getResetPasswordLink() {
    return resetPasswordLink;
  }

  /**
   * Whether or not users are allowed to sign up or reset their passwords via the UI.
   */
  @JsonProperty("selfServiceLinksEnabled")
  @Override
  public @Nullable Boolean getSelfServiceLinksEnabled() {
    return selfServiceLinksEnabled;
  }

  /**
   * Where users are directed upon clicking the account creation link.
   */
  @JsonProperty("signup")
  @Override
  public @Nullable String getSignupLink() {
    return signupLink;
  }

  /**
   * This instance is equal to all instances of {@code SelfServiceLink} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof SelfServiceLink
        && equalTo((SelfServiceLink) another);
  }

  private boolean equalTo(SelfServiceLink another) {
    return Objects.equals(resetPasswordLink, another.resetPasswordLink)
        && Objects.equals(selfServiceLinksEnabled, another.selfServiceLinksEnabled)
        && Objects.equals(signupLink, another.signupLink);
  }

  /**
   * Computes a hash code from attributes: {@code resetPasswordLink}, {@code selfServiceLinksEnabled}, {@code signupLink}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(resetPasswordLink);
    h += (h << 5) + Objects.hashCode(selfServiceLinksEnabled);
    h += (h << 5) + Objects.hashCode(signupLink);
    return h;
  }

  /**
   * Prints the immutable value {@code SelfServiceLink} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SelfServiceLink{"
        + "resetPasswordLink=" + resetPasswordLink
        + ", selfServiceLinksEnabled=" + selfServiceLinksEnabled
        + ", signupLink=" + signupLink
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._SelfServiceLink {
    String resetPasswordLink;
    Boolean selfServiceLinksEnabled;
    String signupLink;
    @JsonProperty("passwd")
    public void setResetPasswordLink(@Nullable String resetPasswordLink) {
      this.resetPasswordLink = resetPasswordLink;
    }
    @JsonProperty("selfServiceLinksEnabled")
    public void setSelfServiceLinksEnabled(@Nullable Boolean selfServiceLinksEnabled) {
      this.selfServiceLinksEnabled = selfServiceLinksEnabled;
    }
    @JsonProperty("signup")
    public void setSignupLink(@Nullable String signupLink) {
      this.signupLink = signupLink;
    }
    @Override
    public String getResetPasswordLink() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getSelfServiceLinksEnabled() { throw new UnsupportedOperationException(); }
    @Override
    public String getSignupLink() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static SelfServiceLink fromJson(Json json) {
    SelfServiceLink.Builder builder = SelfServiceLink.builder();
    if (json.resetPasswordLink != null) {
      builder.resetPasswordLink(json.resetPasswordLink);
    }
    if (json.selfServiceLinksEnabled != null) {
      builder.selfServiceLinksEnabled(json.selfServiceLinksEnabled);
    }
    if (json.signupLink != null) {
      builder.signupLink(json.signupLink);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link SelfServiceLink SelfServiceLink}.
   * @return A new SelfServiceLink builder
   */
  public static SelfServiceLink.Builder builder() {
    return new SelfServiceLink.Builder();
  }

  /**
   * Builds instances of type {@link SelfServiceLink SelfServiceLink}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String resetPasswordLink;
    private Boolean selfServiceLinksEnabled;
    private String signupLink;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SelfServiceLink} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SelfServiceLink instance) {
      return from((_SelfServiceLink) instance);
    }

    /**
     * Copy abstract value type {@code _SelfServiceLink} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_SelfServiceLink instance) {
      Objects.requireNonNull(instance, "instance");
      String resetPasswordLinkValue = instance.getResetPasswordLink();
      if (resetPasswordLinkValue != null) {
        resetPasswordLink(resetPasswordLinkValue);
      }
      Boolean selfServiceLinksEnabledValue = instance.getSelfServiceLinksEnabled();
      if (selfServiceLinksEnabledValue != null) {
        selfServiceLinksEnabled(selfServiceLinksEnabledValue);
      }
      String signupLinkValue = instance.getSignupLink();
      if (signupLinkValue != null) {
        signupLink(signupLinkValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SelfServiceLink#getResetPasswordLink() resetPasswordLink} attribute.
     * @param resetPasswordLink The value for resetPasswordLink (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("passwd")
    public final Builder resetPasswordLink(@Nullable String resetPasswordLink) {
      this.resetPasswordLink = resetPasswordLink;
      return this;
    }

    /**
     * Initializes the value for the {@link SelfServiceLink#getSelfServiceLinksEnabled() selfServiceLinksEnabled} attribute.
     * @param selfServiceLinksEnabled The value for selfServiceLinksEnabled (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("selfServiceLinksEnabled")
    public final Builder selfServiceLinksEnabled(@Nullable Boolean selfServiceLinksEnabled) {
      this.selfServiceLinksEnabled = selfServiceLinksEnabled;
      return this;
    }

    /**
     * Initializes the value for the {@link SelfServiceLink#getSignupLink() signupLink} attribute.
     * @param signupLink The value for signupLink (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("signup")
    public final Builder signupLink(@Nullable String signupLink) {
      this.signupLink = signupLink;
      return this;
    }

    /**
     * Builds a new {@link SelfServiceLink SelfServiceLink}.
     * @return An immutable instance of SelfServiceLink
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public SelfServiceLink build() {
      return new SelfServiceLink(this);
    }
  }
}
