package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The request payload for the update identity zone operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UpdateIdentityZoneRequest", generator = "Immutables")
public final class UpdateIdentityZoneRequest
    extends org.cloudfoundry.uaa.identityzones._UpdateIdentityZoneRequest {
  private final @Nullable IdentityZoneConfiguration configuration;
  private final @Nullable Long createdAt;
  private final @Nullable String description;
  private final String identityZoneId;
  private final @Nullable Long lastModified;
  private final String name;
  private final String subdomain;
  private final @Nullable Integer version;

  private UpdateIdentityZoneRequest(UpdateIdentityZoneRequest.Builder builder) {
    this.configuration = builder.configuration;
    this.createdAt = builder.createdAt;
    this.description = builder.description;
    this.identityZoneId = builder.identityZoneId;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.subdomain = builder.subdomain;
    this.version = builder.version;
  }

  /**
   * The configuration
   */
  @JsonProperty("config")
  @Override
  public @Nullable IdentityZoneConfiguration getConfiguration() {
    return configuration;
  }

  /**
   * The creation date of the identity zone
   */
  @JsonProperty("created")
  @Override
  public @Nullable Long getCreatedAt() {
    return createdAt;
  }

  /**
   * The description of the identity zone
   */
  @JsonProperty("description")
  @Override
  public @Nullable String getDescription() {
    return description;
  }

  /**
   * The id of the identity zone
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * The last modification date of the identity zone
   */
  @JsonProperty("last_modified")
  @Override
  public @Nullable Long getLastModified() {
    return lastModified;
  }

  /**
   * The name of the identity zone
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The unique subdomain. It will be converted into lowercase upon creation.
   */
  @JsonProperty("subdomain")
  @Override
  public String getSubdomain() {
    return subdomain;
  }

  /**
   * The version of the identity zone
   */
  @JsonProperty("version")
  @Override
  public @Nullable Integer getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code UpdateIdentityZoneRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateIdentityZoneRequest
        && equalTo((UpdateIdentityZoneRequest) another);
  }

  private boolean equalTo(UpdateIdentityZoneRequest another) {
    return Objects.equals(configuration, another.configuration)
        && Objects.equals(createdAt, another.createdAt)
        && Objects.equals(description, another.description)
        && identityZoneId.equals(another.identityZoneId)
        && Objects.equals(lastModified, another.lastModified)
        && name.equals(another.name)
        && subdomain.equals(another.subdomain)
        && Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code configuration}, {@code createdAt}, {@code description}, {@code identityZoneId}, {@code lastModified}, {@code name}, {@code subdomain}, {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(configuration);
    h += (h << 5) + Objects.hashCode(createdAt);
    h += (h << 5) + Objects.hashCode(description);
    h += (h << 5) + identityZoneId.hashCode();
    h += (h << 5) + Objects.hashCode(lastModified);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + subdomain.hashCode();
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateIdentityZoneRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateIdentityZoneRequest{"
        + "configuration=" + configuration
        + ", createdAt=" + createdAt
        + ", description=" + description
        + ", identityZoneId=" + identityZoneId
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", subdomain=" + subdomain
        + ", version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._UpdateIdentityZoneRequest {
    IdentityZoneConfiguration configuration;
    Long createdAt;
    String description;
    String identityZoneId;
    Long lastModified;
    String name;
    String subdomain;
    Integer version;
    @JsonProperty("config")
    public void setConfiguration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
    }
    @JsonProperty("created")
    public void setCreatedAt(@Nullable Long createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("description")
    public void setDescription(@Nullable String description) {
      this.description = description;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("last_modified")
    public void setLastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("subdomain")
    public void setSubdomain(String subdomain) {
      this.subdomain = subdomain;
    }
    @JsonProperty("version")
    public void setVersion(@Nullable Integer version) {
      this.version = version;
    }
    @Override
    public IdentityZoneConfiguration getConfiguration() { throw new UnsupportedOperationException(); }
    @Override
    public Long getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getDescription() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getSubdomain() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateIdentityZoneRequest fromJson(Json json) {
    UpdateIdentityZoneRequest.Builder builder = UpdateIdentityZoneRequest.builder();
    if (json.configuration != null) {
      builder.configuration(json.configuration);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.subdomain != null) {
      builder.subdomain(json.subdomain);
    }
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateIdentityZoneRequest UpdateIdentityZoneRequest}.
   * @return A new UpdateIdentityZoneRequest builder
   */
  public static UpdateIdentityZoneRequest.Builder builder() {
    return new UpdateIdentityZoneRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateIdentityZoneRequest UpdateIdentityZoneRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_IDENTITY_ZONE_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_SUBDOMAIN = 0x4L;
    private long initBits = 0x7L;

    private IdentityZoneConfiguration configuration;
    private Long createdAt;
    private String description;
    private String identityZoneId;
    private Long lastModified;
    private String name;
    private String subdomain;
    private Integer version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateIdentityZoneRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateIdentityZoneRequest instance) {
      return from((_UpdateIdentityZoneRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateIdentityZoneRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateIdentityZoneRequest instance) {
      Objects.requireNonNull(instance, "instance");
      IdentityZoneConfiguration configurationValue = instance.getConfiguration();
      if (configurationValue != null) {
        configuration(configurationValue);
      }
      Long createdAtValue = instance.getCreatedAt();
      if (createdAtValue != null) {
        createdAt(createdAtValue);
      }
      String descriptionValue = instance.getDescription();
      if (descriptionValue != null) {
        description(descriptionValue);
      }
      identityZoneId(instance.getIdentityZoneId());
      Long lastModifiedValue = instance.getLastModified();
      if (lastModifiedValue != null) {
        lastModified(lastModifiedValue);
      }
      name(instance.getName());
      subdomain(instance.getSubdomain());
      Integer versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getConfiguration() configuration} attribute.
     * @param configuration The value for configuration (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder configuration(@Nullable IdentityZoneConfiguration configuration) {
      this.configuration = configuration;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder createdAt(@Nullable Long createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getDescription() description} attribute.
     * @param description The value for description (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(@Nullable String description) {
      this.description = description;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(String identityZoneId) {
      this.identityZoneId = Objects.requireNonNull(identityZoneId, "identityZoneId");
      initBits &= ~INIT_BIT_IDENTITY_ZONE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getSubdomain() subdomain} attribute.
     * @param subdomain The value for subdomain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder subdomain(String subdomain) {
      this.subdomain = Objects.requireNonNull(subdomain, "subdomain");
      initBits &= ~INIT_BIT_SUBDOMAIN;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateIdentityZoneRequest#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder version(@Nullable Integer version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link UpdateIdentityZoneRequest UpdateIdentityZoneRequest}.
     * @return An immutable instance of UpdateIdentityZoneRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateIdentityZoneRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateIdentityZoneRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_IDENTITY_ZONE_ID) != 0) attributes.add("identityZoneId");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_SUBDOMAIN) != 0) attributes.add("subdomain");
      return "Cannot build UpdateIdentityZoneRequest, some of required attributes are not set " + attributes;
    }
  }
}
