package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The payload for the identity zone user configuration
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_UserConfig", generator = "Immutables")
public final class UserConfig extends org.cloudfoundry.uaa.identityzones._UserConfig {
  private final List<String> defaultGroups;

  private UserConfig(UserConfig.Builder builder) {
    this.defaultGroups = createUnmodifiableList(true, builder.defaultGroups);
  }

  /**
   * The default groups
   */
  @JsonProperty("defaultGroups")
  @Override
  public List<String> getDefaultGroups() {
    return defaultGroups;
  }

  /**
   * This instance is equal to all instances of {@code UserConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserConfig
        && equalTo((UserConfig) another);
  }

  private boolean equalTo(UserConfig another) {
    return defaultGroups.equals(another.defaultGroups);
  }

  /**
   * Computes a hash code from attributes: {@code defaultGroups}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + defaultGroups.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserConfig{"
        + "defaultGroups=" + defaultGroups
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._UserConfig {
    List<String> defaultGroups = Collections.emptyList();
    @JsonProperty("defaultGroups")
    public void setDefaultGroups(List<String> defaultGroups) {
      this.defaultGroups = defaultGroups;
    }
    @Override
    public List<String> getDefaultGroups() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UserConfig fromJson(Json json) {
    UserConfig.Builder builder = UserConfig.builder();
    if (json.defaultGroups != null) {
      builder.addAllDefaultGroups(json.defaultGroups);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UserConfig UserConfig}.
   * @return A new UserConfig builder
   */
  public static UserConfig.Builder builder() {
    return new UserConfig.Builder();
  }

  /**
   * Builds instances of type {@link UserConfig UserConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private List<String> defaultGroups = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserConfig instance) {
      return from((_UserConfig) instance);
    }

    /**
     * Copy abstract value type {@code _UserConfig} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UserConfig instance) {
      Objects.requireNonNull(instance, "instance");
      addAllDefaultGroups(instance.getDefaultGroups());
      return this;
    }

    /**
     * Adds one element to {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param element A defaultGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultGroup(String element) {
      this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param elements An array of defaultGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder defaultGroups(String... elements) {
      for (String element : elements) {
        this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param elements An iterable of defaultGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("defaultGroups")
    public final Builder defaultGroups(Iterable<String> elements) {
      this.defaultGroups.clear();
      return addAllDefaultGroups(elements);
    }

    /**
     * Adds elements to {@link UserConfig#getDefaultGroups() defaultGroups} list.
     * @param elements An iterable of defaultGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDefaultGroups(Iterable<String> elements) {
      for (String element : elements) {
        this.defaultGroups.add(Objects.requireNonNull(element, "defaultGroups element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UserConfig UserConfig}.
     * @return An immutable instance of UserConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserConfig build() {
      return new UserConfig(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
