package org.cloudfoundry.uaa.serverinformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;

/**
 * The payload for the server information application information
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_ApplicationInfo", generator = "Immutables")
public final class ApplicationInfo extends org.cloudfoundry.uaa.serverinformation._ApplicationInfo {
  private final @Nullable String version;

  private ApplicationInfo(ApplicationInfo.Builder builder) {
    this.version = builder.version;
  }

  /**
   * The application version
   */
  @JsonProperty("version")
  @Override
  public @Nullable String getVersion() {
    return version;
  }

  /**
   * This instance is equal to all instances of {@code ApplicationInfo} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ApplicationInfo
        && equalTo((ApplicationInfo) another);
  }

  private boolean equalTo(ApplicationInfo another) {
    return Objects.equals(version, another.version);
  }

  /**
   * Computes a hash code from attributes: {@code version}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(version);
    return h;
  }

  /**
   * Prints the immutable value {@code ApplicationInfo} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ApplicationInfo{"
        + "version=" + version
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.serverinformation._ApplicationInfo {
    String version;
    @JsonProperty("version")
    public void setVersion(@Nullable String version) {
      this.version = version;
    }
    @Override
    public String getVersion() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ApplicationInfo fromJson(Json json) {
    ApplicationInfo.Builder builder = ApplicationInfo.builder();
    if (json.version != null) {
      builder.version(json.version);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ApplicationInfo ApplicationInfo}.
   * @return A new ApplicationInfo builder
   */
  public static ApplicationInfo.Builder builder() {
    return new ApplicationInfo.Builder();
  }

  /**
   * Builds instances of type {@link ApplicationInfo ApplicationInfo}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private String version;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ApplicationInfo} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ApplicationInfo instance) {
      return from((_ApplicationInfo) instance);
    }

    /**
     * Copy abstract value type {@code _ApplicationInfo} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ApplicationInfo instance) {
      Objects.requireNonNull(instance, "instance");
      String versionValue = instance.getVersion();
      if (versionValue != null) {
        version(versionValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ApplicationInfo#getVersion() version} attribute.
     * @param version The value for version (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("version")
    public final Builder version(@Nullable String version) {
      this.version = version;
      return this;
    }

    /**
     * Builds a new {@link ApplicationInfo ApplicationInfo}.
     * @return An immutable instance of ApplicationInfo
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ApplicationInfo build() {
      return new ApplicationInfo(this);
    }
  }
}
