package org.cloudfoundry.uaa.serverinformation;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * The request payload for the Get Auto Login Authentication Code operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_GetAutoLoginAuthenticationCodeRequest", generator = "Immutables")
public final class GetAutoLoginAuthenticationCodeRequest
    extends org.cloudfoundry.uaa.serverinformation._GetAutoLoginAuthenticationCodeRequest {
  private final String clientId;
  private final String clientSecret;
  private final String password;
  private final String username;

  private GetAutoLoginAuthenticationCodeRequest(GetAutoLoginAuthenticationCodeRequest.Builder builder) {
    this.clientId = builder.clientId;
    this.clientSecret = builder.clientSecret;
    this.password = builder.password;
    this.username = builder.username;
  }

  /**
   * The client id
   */
  @JsonProperty("clientId")
  @JsonIgnore
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * The client secret
   */
  @JsonProperty("clientSecret")
  @JsonIgnore
  @Override
  public String getClientSecret() {
    return clientSecret;
  }

  /**
   * The password for the autologin request
   */
  @JsonProperty("password")
  @Override
  public String getPassword() {
    return password;
  }

  /**
   * The username for the autologin request
   */
  @JsonProperty("username")
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * This instance is equal to all instances of {@code GetAutoLoginAuthenticationCodeRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetAutoLoginAuthenticationCodeRequest
        && equalTo((GetAutoLoginAuthenticationCodeRequest) another);
  }

  private boolean equalTo(GetAutoLoginAuthenticationCodeRequest another) {
    return clientId.equals(another.clientId)
        && clientSecret.equals(another.clientSecret)
        && password.equals(another.password)
        && username.equals(another.username);
  }

  /**
   * Computes a hash code from attributes: {@code clientId}, {@code clientSecret}, {@code password}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + clientSecret.hashCode();
    h += (h << 5) + password.hashCode();
    h += (h << 5) + username.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GetAutoLoginAuthenticationCodeRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetAutoLoginAuthenticationCodeRequest{"
        + "clientId=" + clientId
        + ", clientSecret=" + clientSecret
        + ", password=" + password
        + ", username=" + username
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.uaa.serverinformation._GetAutoLoginAuthenticationCodeRequest {
    String clientId;
    String clientSecret;
    String password;
    String username;
    @JsonProperty("clientId")
    @JsonIgnore
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("clientSecret")
    @JsonIgnore
    public void setClientSecret(String clientSecret) {
      this.clientSecret = clientSecret;
    }
    @JsonProperty("password")
    public void setPassword(String password) {
      this.password = password;
    }
    @JsonProperty("username")
    public void setUsername(String username) {
      this.username = username;
    }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientSecret() { throw new UnsupportedOperationException(); }
    @Override
    public String getPassword() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetAutoLoginAuthenticationCodeRequest fromJson(Json json) {
    GetAutoLoginAuthenticationCodeRequest.Builder builder = GetAutoLoginAuthenticationCodeRequest.builder();
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.clientSecret != null) {
      builder.clientSecret(json.clientSecret);
    }
    if (json.password != null) {
      builder.password(json.password);
    }
    if (json.username != null) {
      builder.username(json.username);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetAutoLoginAuthenticationCodeRequest GetAutoLoginAuthenticationCodeRequest}.
   * @return A new GetAutoLoginAuthenticationCodeRequest builder
   */
  public static GetAutoLoginAuthenticationCodeRequest.Builder builder() {
    return new GetAutoLoginAuthenticationCodeRequest.Builder();
  }

  /**
   * Builds instances of type {@link GetAutoLoginAuthenticationCodeRequest GetAutoLoginAuthenticationCodeRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private static final long INIT_BIT_CLIENT_SECRET = 0x2L;
    private static final long INIT_BIT_PASSWORD = 0x4L;
    private static final long INIT_BIT_USERNAME = 0x8L;
    private long initBits = 0xfL;

    private String clientId;
    private String clientSecret;
    private String password;
    private String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetAutoLoginAuthenticationCodeRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetAutoLoginAuthenticationCodeRequest instance) {
      return from((_GetAutoLoginAuthenticationCodeRequest) instance);
    }

    /**
     * Copy abstract value type {@code _GetAutoLoginAuthenticationCodeRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetAutoLoginAuthenticationCodeRequest instance) {
      Objects.requireNonNull(instance, "instance");
      clientId(instance.getClientId());
      clientSecret(instance.getClientSecret());
      password(instance.getPassword());
      username(instance.getUsername());
      return this;
    }

    /**
     * Initializes the value for the {@link GetAutoLoginAuthenticationCodeRequest#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAutoLoginAuthenticationCodeRequest#getClientSecret() clientSecret} attribute.
     * @param clientSecret The value for clientSecret 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder clientSecret(String clientSecret) {
      this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
      initBits &= ~INIT_BIT_CLIENT_SECRET;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAutoLoginAuthenticationCodeRequest#getPassword() password} attribute.
     * @param password The value for password 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(String password) {
      this.password = Objects.requireNonNull(password, "password");
      initBits &= ~INIT_BIT_PASSWORD;
      return this;
    }

    /**
     * Initializes the value for the {@link GetAutoLoginAuthenticationCodeRequest#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder username(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Builds a new {@link GetAutoLoginAuthenticationCodeRequest GetAutoLoginAuthenticationCodeRequest}.
     * @return An immutable instance of GetAutoLoginAuthenticationCodeRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetAutoLoginAuthenticationCodeRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetAutoLoginAuthenticationCodeRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      if ((initBits & INIT_BIT_CLIENT_SECRET) != 0) attributes.add("clientSecret");
      if ((initBits & INIT_BIT_PASSWORD) != 0) attributes.add("password");
      if ((initBits & INIT_BIT_USERNAME) != 0) attributes.add("username");
      return "Cannot build GetAutoLoginAuthenticationCodeRequest, some of required attributes are not set " + attributes;
    }
  }
}
