package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;

/**
 * The request payload for the create user operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_CreateUserRequest", generator = "Immutables")
public final class CreateUserRequest extends org.cloudfoundry.uaa.users._CreateUserRequest {
  private final @Nullable Boolean active;
  private final List<Email> email;
  private final @Nullable String externalId;
  private final @Nullable Name name;
  private final @Nullable String origin;
  private final @Nullable String password;
  private final @Nullable List<PhoneNumber> phoneNumbers;
  private final String userName;
  private final @Nullable Boolean verified;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private CreateUserRequest(CreateUserRequest.Builder builder) {
    this.active = builder.active;
    this.email = createUnmodifiableList(true, builder.email);
    this.externalId = builder.externalId;
    this.name = builder.name;
    this.origin = builder.origin;
    this.password = builder.password;
    this.phoneNumbers = builder.phoneNumbers == null ? null : createUnmodifiableList(true, builder.phoneNumbers);
    this.userName = builder.userName;
    this.verified = builder.verified;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * Whether the user is active
   */
  @JsonProperty("active")
  @Override
  public @Nullable Boolean getActive() {
    return active;
  }

  /**
   * The emails for the user
   */
  @JsonProperty("emails")
  @Override
  public List<Email> getEmail() {
    return email;
  }

  /**
   * The external id
   */
  @JsonProperty("externalId")
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * The user's name
   */
  @JsonProperty("name")
  @Override
  public @Nullable Name getName() {
    return name;
  }

  /**
   * The identity provider that authenticated this user
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * The password
   */
  @JsonProperty("password")
  @Override
  public @Nullable String getPassword() {
    return password;
  }

  /**
   * The phone numbers for the user
   */
  @JsonProperty("phoneNumbers")
  @Override
  public @Nullable List<PhoneNumber> getPhoneNumbers() {
    return phoneNumbers;
  }

  /**
   * The user name
   */
  @JsonProperty("userName")
  @Override
  public String getUserName() {
    return userName;
  }

  /**
   * Whether the user's email is verified
   */
  @JsonProperty("verified")
  @Override
  public @Nullable Boolean getVerified() {
    return verified;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code CreateUserRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateUserRequest
        && equalTo((CreateUserRequest) another);
  }

  private boolean equalTo(CreateUserRequest another) {
    return Objects.equals(active, another.active)
        && email.equals(another.email)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(name, another.name)
        && Objects.equals(origin, another.origin)
        && Objects.equals(password, another.password)
        && Objects.equals(phoneNumbers, another.phoneNumbers)
        && userName.equals(another.userName)
        && Objects.equals(verified, another.verified)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code active}, {@code email}, {@code externalId}, {@code name}, {@code origin}, {@code password}, {@code phoneNumbers}, {@code userName}, {@code verified}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(active);
    h += (h << 5) + email.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + Objects.hashCode(password);
    h += (h << 5) + Objects.hashCode(phoneNumbers);
    h += (h << 5) + userName.hashCode();
    h += (h << 5) + Objects.hashCode(verified);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code CreateUserRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateUserRequest{"
        + "active=" + active
        + ", email=" + email
        + ", externalId=" + externalId
        + ", name=" + name
        + ", origin=" + origin
        + ", password=" + password
        + ", phoneNumbers=" + phoneNumbers
        + ", userName=" + userName
        + ", verified=" + verified
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.users._CreateUserRequest {
    Boolean active;
    List<Email> email = Collections.emptyList();
    String externalId;
    Name name;
    String origin;
    String password;
    List<PhoneNumber> phoneNumbers = null;
    String userName;
    Boolean verified;
    String identityZoneId;
    String identityZoneSubdomain;
    @JsonProperty("active")
    public void setActive(@Nullable Boolean active) {
      this.active = active;
    }
    @JsonProperty("emails")
    public void setEmail(List<Email> email) {
      this.email = email;
    }
    @JsonProperty("externalId")
    public void setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("name")
    public void setName(@Nullable Name name) {
      this.name = name;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("password")
    public void setPassword(@Nullable String password) {
      this.password = password;
    }
    @JsonProperty("phoneNumbers")
    public void setPhoneNumbers(@Nullable List<PhoneNumber> phoneNumbers) {
      this.phoneNumbers = phoneNumbers;
    }
    @JsonProperty("userName")
    public void setUserName(String userName) {
      this.userName = userName;
    }
    @JsonProperty("verified")
    public void setVerified(@Nullable Boolean verified) {
      this.verified = verified;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @Override
    public Boolean getActive() { throw new UnsupportedOperationException(); }
    @Override
    public List<Email> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public Name getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getPassword() { throw new UnsupportedOperationException(); }
    @Override
    public List<PhoneNumber> getPhoneNumbers() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getVerified() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateUserRequest fromJson(Json json) {
    CreateUserRequest.Builder builder = CreateUserRequest.builder();
    if (json.active != null) {
      builder.active(json.active);
    }
    if (json.email != null) {
      builder.addAllEmail(json.email);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.password != null) {
      builder.password(json.password);
    }
    if (json.phoneNumbers != null) {
      builder.addAllPhoneNumbers(json.phoneNumbers);
    }
    if (json.userName != null) {
      builder.userName(json.userName);
    }
    if (json.verified != null) {
      builder.verified(json.verified);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    return builder.build();
  }


  private static CreateUserRequest validate(CreateUserRequest instance) {
    instance.check();
    return instance;
  }

  /**
   * Creates a builder for {@link CreateUserRequest CreateUserRequest}.
   * @return A new CreateUserRequest builder
   */
  public static CreateUserRequest.Builder builder() {
    return new CreateUserRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateUserRequest CreateUserRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_USER_NAME = 0x1L;
    private long initBits = 0x1L;

    private Boolean active;
    private List<Email> email = new ArrayList<Email>();
    private String externalId;
    private Name name;
    private String origin;
    private String password;
    private List<PhoneNumber> phoneNumbers = null;
    private String userName;
    private Boolean verified;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateUserRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _CreateUserRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_CreateUserRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._CreateUserRequest) {
        org.cloudfoundry.uaa.users._CreateUserRequest instance = (org.cloudfoundry.uaa.users._CreateUserRequest) object;
        String passwordValue = instance.getPassword();
        if (passwordValue != null) {
          password(passwordValue);
        }
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
        Name nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        Boolean verifiedValue = instance.getVerified();
        if (verifiedValue != null) {
          verified(verifiedValue);
        }
        Boolean activeValue = instance.getActive();
        if (activeValue != null) {
          active(activeValue);
        }
        String externalIdValue = instance.getExternalId();
        if (externalIdValue != null) {
          externalId(externalIdValue);
        }
        userName(instance.getUserName());
        addAllEmail(instance.getEmail());
        List<PhoneNumber> phoneNumbersValue = instance.getPhoneNumbers();
        if (phoneNumbersValue != null) {
          addAllPhoneNumbers(phoneNumbersValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getActive() active} attribute.
     * @param active The value for active (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder active(@Nullable Boolean active) {
      this.active = active;
      return this;
    }

    /**
     * Adds one element to {@link CreateUserRequest#getEmail() email} list.
     * @param element A email element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email element) {
      this.email.add(Objects.requireNonNull(element, "email element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateUserRequest#getEmail() email} list.
     * @param elements An array of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Email... elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateUserRequest#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder email(Iterable<? extends Email> elements) {
      this.email.clear();
      return addAllEmail(elements);
    }

    /**
     * Adds elements to {@link CreateUserRequest#getEmail() email} list.
     * @param elements An iterable of email elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllEmail(Iterable<? extends Email> elements) {
      for (Email element : elements) {
        this.email.add(Objects.requireNonNull(element, "email element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(@Nullable Name name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getPassword() password} attribute.
     * @param password The value for password (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder password(@Nullable String password) {
      this.password = password;
      return this;
    }

    /**
     * Adds one element to {@link CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param element A phoneNumbers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumber(PhoneNumber element) {
      if (this.phoneNumbers == null) {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
      }
      this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      return this;
    }

    /**
     * Adds elements to {@link CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An array of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumbers(PhoneNumber... elements) {
      if (this.phoneNumbers == null) {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
      }
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder phoneNumbers(@Nullable Iterable<? extends PhoneNumber> elements) {
      if (elements == null) {
        this.phoneNumbers = null;
        return this;
      }
      this.phoneNumbers = new ArrayList<PhoneNumber>();
      return addAllPhoneNumbers(elements);
    }

    /**
     * Adds elements to {@link CreateUserRequest#getPhoneNumbers() phoneNumbers} list.
     * @param elements An iterable of phoneNumbers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPhoneNumbers(Iterable<? extends PhoneNumber> elements) {
      Objects.requireNonNull(elements, "phoneNumbers element");
      if (this.phoneNumbers == null) {
        this.phoneNumbers = new ArrayList<PhoneNumber>();
      }
      for (PhoneNumber element : elements) {
        this.phoneNumbers.add(Objects.requireNonNull(element, "phoneNumbers element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getUserName() userName} attribute.
     * @param userName The value for userName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userName(String userName) {
      this.userName = Objects.requireNonNull(userName, "userName");
      initBits &= ~INIT_BIT_USER_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getVerified() verified} attribute.
     * @param verified The value for verified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder verified(@Nullable Boolean verified) {
      this.verified = verified;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateUserRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link CreateUserRequest CreateUserRequest}.
     * @return An immutable instance of CreateUserRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateUserRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return CreateUserRequest.validate(new CreateUserRequest(this));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER_NAME) != 0) attributes.add("userName");
      return "Cannot build CreateUserRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
