package org.cloudfoundry.uaa.users;

import java.util.Objects;
import javax.annotation.Generated;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.PaginatedAndSortedRequest;
import org.cloudfoundry.uaa.SortOrder;

/**
 * The request payload for the lookup user ids and usernames operation
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
@org.immutables.value.Generated(from = "_LookupUserIdsRequest", generator = "Immutables")
public final class LookupUserIdsRequest extends org.cloudfoundry.uaa.users._LookupUserIdsRequest {
  private final @Nullable Boolean includeInactive;
  private final @Nullable Integer count;
  private final @Nullable String filter;
  private final @Nullable SortOrder sortOrder;
  private final @Nullable Integer startIndex;

  private LookupUserIdsRequest(LookupUserIdsRequest.Builder builder) {
    this.includeInactive = builder.includeInactive;
    this.count = builder.count;
    this.filter = builder.filter;
    this.sortOrder = builder.sortOrder;
    this.startIndex = builder.startIndex;
  }

  /**
   * Whether to include users from inactive identity providers
   */
  @Override
  public @Nullable Boolean getIncludeInactive() {
    return includeInactive;
  }

  /**
   * The number of results per page
   */
  @Override
  public @Nullable Integer getCount() {
    return count;
  }

  /**
   * The filter
   */
  @Override
  public @Nullable String getFilter() {
    return filter;
  }

  /**
   * The sort order
   */
  @Override
  public @Nullable SortOrder getSortOrder() {
    return sortOrder;
  }

  /**
   * The start index
   */
  @Override
  public @Nullable Integer getStartIndex() {
    return startIndex;
  }

  /**
   * This instance is equal to all instances of {@code LookupUserIdsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof LookupUserIdsRequest
        && equalTo((LookupUserIdsRequest) another);
  }

  private boolean equalTo(LookupUserIdsRequest another) {
    return Objects.equals(includeInactive, another.includeInactive)
        && Objects.equals(count, another.count)
        && Objects.equals(filter, another.filter)
        && Objects.equals(sortOrder, another.sortOrder)
        && Objects.equals(startIndex, another.startIndex);
  }

  /**
   * Computes a hash code from attributes: {@code includeInactive}, {@code count}, {@code filter}, {@code sortOrder}, {@code startIndex}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(includeInactive);
    h += (h << 5) + Objects.hashCode(count);
    h += (h << 5) + Objects.hashCode(filter);
    h += (h << 5) + Objects.hashCode(sortOrder);
    h += (h << 5) + Objects.hashCode(startIndex);
    return h;
  }

  /**
   * Prints the immutable value {@code LookupUserIdsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "LookupUserIdsRequest{"
        + "includeInactive=" + includeInactive
        + ", count=" + count
        + ", filter=" + filter
        + ", sortOrder=" + sortOrder
        + ", startIndex=" + startIndex
        + "}";
  }

  /**
   * Creates a builder for {@link LookupUserIdsRequest LookupUserIdsRequest}.
   * @return A new LookupUserIdsRequest builder
   */
  public static LookupUserIdsRequest.Builder builder() {
    return new LookupUserIdsRequest.Builder();
  }

  /**
   * Builds instances of type {@link LookupUserIdsRequest LookupUserIdsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private Boolean includeInactive;
    private Integer count;
    private String filter;
    private SortOrder sortOrder;
    private Integer startIndex;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.PaginatedAndSortedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedAndSortedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code LookupUserIdsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(LookupUserIdsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _LookupUserIdsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_LookupUserIdsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedAndSortedRequest) {
        PaginatedAndSortedRequest instance = (PaginatedAndSortedRequest) object;
        String filterValue = instance.getFilter();
        if (filterValue != null) {
          filter(filterValue);
        }
        Integer countValue = instance.getCount();
        if (countValue != null) {
          count(countValue);
        }
        Integer startIndexValue = instance.getStartIndex();
        if (startIndexValue != null) {
          startIndex(startIndexValue);
        }
        SortOrder sortOrderValue = instance.getSortOrder();
        if (sortOrderValue != null) {
          sortOrder(sortOrderValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.users._LookupUserIdsRequest) {
        org.cloudfoundry.uaa.users._LookupUserIdsRequest instance = (org.cloudfoundry.uaa.users._LookupUserIdsRequest) object;
        Boolean includeInactiveValue = instance.getIncludeInactive();
        if (includeInactiveValue != null) {
          includeInactive(includeInactiveValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link LookupUserIdsRequest#getIncludeInactive() includeInactive} attribute.
     * @param includeInactive The value for includeInactive (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder includeInactive(@Nullable Boolean includeInactive) {
      this.includeInactive = includeInactive;
      return this;
    }

    /**
     * Initializes the value for the {@link LookupUserIdsRequest#getCount() count} attribute.
     * @param count The value for count (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder count(@Nullable Integer count) {
      this.count = count;
      return this;
    }

    /**
     * Initializes the value for the {@link LookupUserIdsRequest#getFilter() filter} attribute.
     * @param filter The value for filter (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder filter(@Nullable String filter) {
      this.filter = filter;
      return this;
    }

    /**
     * Initializes the value for the {@link LookupUserIdsRequest#getSortOrder() sortOrder} attribute.
     * @param sortOrder The value for sortOrder (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sortOrder(@Nullable SortOrder sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }

    /**
     * Initializes the value for the {@link LookupUserIdsRequest#getStartIndex() startIndex} attribute.
     * @param startIndex The value for startIndex (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder startIndex(@Nullable Integer startIndex) {
      this.startIndex = startIndex;
      return this;
    }

    /**
     * Builds a new {@link LookupUserIdsRequest LookupUserIdsRequest}.
     * @return An immutable instance of LookupUserIdsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public LookupUserIdsRequest build() {
      return new LookupUserIdsRequest(this);
    }
  }
}
