/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.serviceinstances._BindServiceInstanceRouteRequest;
import org.immutables.value.Generated;

@Generated(from="_BindServiceInstanceRouteRequest", generator="Immutables")
public final class BindServiceInstanceRouteRequest
extends _BindServiceInstanceRouteRequest {
    @Nullable
    private final Map<String, Object> parameters;
    private final String routeId;
    private final String serviceInstanceId;

    private BindServiceInstanceRouteRequest(Builder builder) {
        this.parameters = builder.parameters == null ? null : BindServiceInstanceRouteRequest.createUnmodifiableMap(false, false, builder.parameters);
        this.routeId = builder.routeId;
        this.serviceInstanceId = builder.serviceInstanceId;
    }

    @Override
    @JsonProperty(value="parameters")
    @Nullable
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    @JsonProperty(value="routeId")
    @JsonIgnore
    public String getRouteId() {
        return this.routeId;
    }

    @Override
    @JsonProperty(value="serviceInstanceId")
    @JsonIgnore
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BindServiceInstanceRouteRequest && this.equalTo((BindServiceInstanceRouteRequest)another);
    }

    private boolean equalTo(BindServiceInstanceRouteRequest another) {
        return Objects.equals(this.parameters, another.parameters) && this.routeId.equals(another.routeId) && this.serviceInstanceId.equals(another.serviceInstanceId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.parameters);
        h += (h << 5) + this.routeId.hashCode();
        h += (h << 5) + this.serviceInstanceId.hashCode();
        return h;
    }

    public String toString() {
        return "BindServiceInstanceRouteRequest{parameters=" + this.parameters + ", routeId=" + this.routeId + ", serviceInstanceId=" + this.serviceInstanceId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BindServiceInstanceRouteRequest fromJson(Json json) {
        Builder builder = BindServiceInstanceRouteRequest.builder();
        if (json.parameters != null) {
            builder.putAllParameters(json.parameters);
        }
        if (json.routeId != null) {
            builder.routeId(json.routeId);
        }
        if (json.serviceInstanceId != null) {
            builder.serviceInstanceId(json.serviceInstanceId);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private static final long INIT_BIT_ROUTE_ID = 1L;
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 2L;
        private long initBits = 3L;
        private Map<String, Object> parameters = null;
        private String routeId;
        private String serviceInstanceId;

        private Builder() {
        }

        public final Builder from(BindServiceInstanceRouteRequest instance) {
            return this.from((_BindServiceInstanceRouteRequest)instance);
        }

        final Builder from(_BindServiceInstanceRouteRequest instance) {
            Objects.requireNonNull(instance, "instance");
            Map<String, Object> parametersValue = instance.getParameters();
            if (parametersValue != null) {
                this.putAllParameters(parametersValue);
            }
            this.routeId(instance.getRouteId());
            this.serviceInstanceId(instance.getServiceInstanceId());
            return this;
        }

        public final Builder parameter(String key, Object value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            this.parameters.put(key, value);
            return this;
        }

        public final Builder parameter(Map.Entry<String, ? extends Object> entry) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put(k, v);
            return this;
        }

        public final Builder parameters(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.parameters = null;
                return this;
            }
            this.parameters = new LinkedHashMap<String, Object>();
            return this.putAllParameters(entries);
        }

        public final Builder putAllParameters(Map<String, ? extends Object> entries) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.parameters.put(k, v);
            }
            return this;
        }

        public final Builder routeId(String routeId) {
            this.routeId = Objects.requireNonNull(routeId, "routeId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BindServiceInstanceRouteRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new BindServiceInstanceRouteRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("routeId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build BindServiceInstanceRouteRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _BindServiceInstanceRouteRequest {
        Map<String, Object> parameters = null;
        String routeId;
        String serviceInstanceId;

        Json() {
        }

        @JsonProperty(value="parameters")
        public void setParameters(@Nullable Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        @JsonProperty(value="routeId")
        @JsonIgnore
        public void setRouteId(String routeId) {
            this.routeId = routeId;
        }

        @JsonProperty(value="serviceInstanceId")
        @JsonIgnore
        public void setServiceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = serviceInstanceId;
        }

        @Override
        public Map<String, Object> getParameters() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRouteId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getServiceInstanceId() {
            throw new UnsupportedOperationException();
        }
    }
}

