/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.droplets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.droplets._Buildpack;
import org.immutables.value.Generated;

@Generated(from="_Buildpack", generator="Immutables")
public final class Buildpack
extends _Buildpack {
    @Nullable
    private final String buildpackName;
    @Nullable
    private final String detectOutput;
    private final String name;
    @Nullable
    private final String version;

    private Buildpack(Builder builder) {
        this.buildpackName = builder.buildpackName;
        this.detectOutput = builder.detectOutput;
        this.name = builder.name;
        this.version = builder.version;
    }

    @Override
    @JsonProperty(value="buildpack_name")
    @Nullable
    public String getBuildpackName() {
        return this.buildpackName;
    }

    @Override
    @JsonProperty(value="detect_output")
    @Nullable
    public String getDetectOutput() {
        return this.detectOutput;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Buildpack && this.equalTo((Buildpack)another);
    }

    private boolean equalTo(Buildpack another) {
        return Objects.equals(this.buildpackName, another.buildpackName) && Objects.equals(this.detectOutput, another.detectOutput) && this.name.equals(another.name) && Objects.equals(this.version, another.version);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.buildpackName);
        h += (h << 5) + Objects.hashCode(this.detectOutput);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.version);
        return h;
    }

    public String toString() {
        return "Buildpack{buildpackName=" + this.buildpackName + ", detectOutput=" + this.detectOutput + ", name=" + this.name + ", version=" + this.version + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Buildpack fromJson(Json json) {
        Builder builder = Buildpack.builder();
        if (json.buildpackName != null) {
            builder.buildpackName(json.buildpackName);
        }
        if (json.detectOutput != null) {
            builder.detectOutput(json.detectOutput);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private long initBits = 1L;
        private String buildpackName;
        private String detectOutput;
        private String name;
        private String version;

        private Builder() {
        }

        public final Builder from(Buildpack instance) {
            return this.from((_Buildpack)instance);
        }

        final Builder from(_Buildpack instance) {
            String detectOutputValue;
            Objects.requireNonNull(instance, "instance");
            String buildpackNameValue = instance.getBuildpackName();
            if (buildpackNameValue != null) {
                this.buildpackName(buildpackNameValue);
            }
            if ((detectOutputValue = instance.getDetectOutput()) != null) {
                this.detectOutput(detectOutputValue);
            }
            this.name(instance.getName());
            String versionValue = instance.getVersion();
            if (versionValue != null) {
                this.version(versionValue);
            }
            return this;
        }

        @JsonProperty(value="buildpack_name")
        public final Builder buildpackName(@Nullable String buildpackName) {
            this.buildpackName = buildpackName;
            return this;
        }

        @JsonProperty(value="detect_output")
        public final Builder detectOutput(@Nullable String detectOutput) {
            this.detectOutput = detectOutput;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="version")
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        public Buildpack build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Buildpack(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Buildpack, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _Buildpack {
        String buildpackName;
        String detectOutput;
        String name;
        String version;

        Json() {
        }

        @JsonProperty(value="buildpack_name")
        public void setBuildpackName(@Nullable String buildpackName) {
            this.buildpackName = buildpackName;
        }

        @JsonProperty(value="detect_output")
        public void setDetectOutput(@Nullable String detectOutput) {
            this.detectOutput = detectOutput;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @Override
        public String getBuildpackName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDetectOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }
    }
}

