/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.tasks.TaskState;
import org.cloudfoundry.client.v3.tasks._ListTasksRequest;
import org.immutables.value.Generated;

@Generated(from="_ListTasksRequest", generator="Immutables")
public final class ListTasksRequest
extends _ListTasksRequest {
    private final List<String> applicationIds;
    private final List<String> names;
    private final List<String> organizationIds;
    private final List<String> spaceIds;
    private final List<TaskState> states;
    private final List<String> taskIds;
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListTasksRequest(Builder builder) {
        this.applicationIds = ListTasksRequest.createUnmodifiableList(true, builder.applicationIds);
        this.names = ListTasksRequest.createUnmodifiableList(true, builder.names);
        this.organizationIds = ListTasksRequest.createUnmodifiableList(true, builder.organizationIds);
        this.spaceIds = ListTasksRequest.createUnmodifiableList(true, builder.spaceIds);
        this.states = ListTasksRequest.createUnmodifiableList(true, builder.states);
        this.taskIds = ListTasksRequest.createUnmodifiableList(true, builder.taskIds);
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }

    @Override
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    @Override
    public List<TaskState> getStates() {
        return this.states;
    }

    @Override
    public List<String> getTaskIds() {
        return this.taskIds;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListTasksRequest && this.equalTo((ListTasksRequest)another);
    }

    private boolean equalTo(ListTasksRequest another) {
        return this.applicationIds.equals(another.applicationIds) && this.names.equals(another.names) && this.organizationIds.equals(another.organizationIds) && this.spaceIds.equals(another.spaceIds) && this.states.equals(another.states) && this.taskIds.equals(another.taskIds) && Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.names.hashCode();
        h += (h << 5) + this.organizationIds.hashCode();
        h += (h << 5) + this.spaceIds.hashCode();
        h += (h << 5) + this.states.hashCode();
        h += (h << 5) + this.taskIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListTasksRequest{applicationIds=" + this.applicationIds + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ", spaceIds=" + this.spaceIds + ", states=" + this.states + ", taskIds=" + this.taskIds + ", orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> names = new ArrayList<String>();
        private List<String> organizationIds = new ArrayList<String>();
        private List<String> spaceIds = new ArrayList<String>();
        private List<TaskState> states = new ArrayList<TaskState>();
        private List<String> taskIds = new ArrayList<String>();
        private String orderBy;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListTasksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListTasksRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListTasksRequest) {
                instance = (_ListTasksRequest)object;
                this.addAllNames(((_ListTasksRequest)instance).getNames());
                this.addAllSpaceIds(((_ListTasksRequest)instance).getSpaceIds());
                this.addAllTaskIds(((_ListTasksRequest)instance).getTaskIds());
                this.addAllOrganizationIds(((_ListTasksRequest)instance).getOrganizationIds());
                this.addAllApplicationIds(((_ListTasksRequest)instance).getApplicationIds());
                this.addAllStates(((_ListTasksRequest)instance).getStates());
            }
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder name(String element) {
            this.names.add(Objects.requireNonNull(element, "names element"));
            return this;
        }

        public final Builder names(String ... elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder names(Iterable<String> elements) {
            this.names.clear();
            return this.addAllNames(elements);
        }

        public final Builder addAllNames(Iterable<String> elements) {
            for (String element : elements) {
                this.names.add(Objects.requireNonNull(element, "names element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            return this;
        }

        public final Builder organizationIds(String ... elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder organizationIds(Iterable<String> elements) {
            this.organizationIds.clear();
            return this.addAllOrganizationIds(elements);
        }

        public final Builder addAllOrganizationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
            }
            return this;
        }

        public final Builder spaceId(String element) {
            this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            return this;
        }

        public final Builder spaceIds(String ... elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder spaceIds(Iterable<String> elements) {
            this.spaceIds.clear();
            return this.addAllSpaceIds(elements);
        }

        public final Builder addAllSpaceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
            }
            return this;
        }

        public final Builder state(TaskState element) {
            this.states.add(Objects.requireNonNull(element, "states element"));
            return this;
        }

        public final Builder states(TaskState ... elements) {
            for (TaskState element : elements) {
                this.states.add(Objects.requireNonNull(element, "states element"));
            }
            return this;
        }

        public final Builder states(Iterable<? extends TaskState> elements) {
            this.states.clear();
            return this.addAllStates(elements);
        }

        public final Builder addAllStates(Iterable<? extends TaskState> elements) {
            for (TaskState taskState : elements) {
                this.states.add(Objects.requireNonNull(taskState, "states element"));
            }
            return this;
        }

        public final Builder taskId(String element) {
            this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
            return this;
        }

        public final Builder taskIds(String ... elements) {
            for (String element : elements) {
                this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
            }
            return this;
        }

        public final Builder taskIds(Iterable<String> elements) {
            this.taskIds.clear();
            return this.addAllTaskIds(elements);
        }

        public final Builder addAllTaskIds(Iterable<String> elements) {
            for (String element : elements) {
                this.taskIds.add(Objects.requireNonNull(element, "taskIds element"));
            }
            return this;
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListTasksRequest build() {
            return new ListTasksRequest(this);
        }
    }
}

