/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.Metadata;
import org.cloudfoundry.uaa.groups.AbstractExternalGroupMapping;
import org.cloudfoundry.uaa.groups.AbstractExternalGroupResource;
import org.cloudfoundry.uaa.groups._ExternalGroupMapping;
import org.immutables.value.Generated;

@Generated(from="_ExternalGroupMapping", generator="Immutables")
public final class ExternalGroupMapping
extends _ExternalGroupMapping {
    private final Metadata metadata;
    private final List<String> schemas;
    private final String displayName;
    private final String externalGroup;
    private final String groupId;
    private final String origin;

    private ExternalGroupMapping(Builder builder) {
        this.metadata = builder.metadata;
        this.schemas = ExternalGroupMapping.createUnmodifiableList(true, builder.schemas);
        this.displayName = builder.displayName;
        this.externalGroup = builder.externalGroup;
        this.groupId = builder.groupId;
        this.origin = builder.origin;
    }

    @Override
    @JsonProperty(value="meta")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="schemas")
    public List<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty(value="displayName")
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty(value="externalGroup")
    public String getExternalGroup() {
        return this.externalGroup;
    }

    @Override
    @JsonProperty(value="groupId")
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="origin")
    public String getOrigin() {
        return this.origin;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExternalGroupMapping && this.equalTo((ExternalGroupMapping)another);
    }

    private boolean equalTo(ExternalGroupMapping another) {
        return this.metadata.equals(another.metadata) && this.schemas.equals(another.schemas) && this.displayName.equals(another.displayName) && this.externalGroup.equals(another.externalGroup) && this.groupId.equals(another.groupId) && this.origin.equals(another.origin);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.metadata.hashCode();
        h += (h << 5) + this.schemas.hashCode();
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.externalGroup.hashCode();
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.origin.hashCode();
        return h;
    }

    public String toString() {
        return "ExternalGroupMapping{metadata=" + this.metadata + ", schemas=" + this.schemas + ", displayName=" + this.displayName + ", externalGroup=" + this.externalGroup + ", groupId=" + this.groupId + ", origin=" + this.origin + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ExternalGroupMapping fromJson(Json json) {
        Builder builder = ExternalGroupMapping.builder();
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.schemas != null) {
            builder.addAllSchemas(json.schemas);
        }
        if (json.displayName != null) {
            builder.displayName(json.displayName);
        }
        if (json.externalGroup != null) {
            builder.externalGroup(json.externalGroup);
        }
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_METADATA = 1L;
        private static final long INIT_BIT_DISPLAY_NAME = 2L;
        private static final long INIT_BIT_EXTERNAL_GROUP = 4L;
        private static final long INIT_BIT_GROUP_ID = 8L;
        private static final long INIT_BIT_ORIGIN = 16L;
        private long initBits = 31L;
        private Metadata metadata;
        private List<String> schemas = new ArrayList<String>();
        private String displayName;
        private String externalGroup;
        private String groupId;
        private String origin;

        private Builder() {
        }

        public final Builder from(AbstractExternalGroupResource instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractExternalGroupMapping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExternalGroupMapping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ExternalGroupMapping instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractExternalGroupResource instance;
            if (object instanceof AbstractExternalGroupResource) {
                instance = (AbstractExternalGroupResource)object;
                this.displayName(instance.getDisplayName());
                this.externalGroup(instance.getExternalGroup());
                this.groupId(instance.getGroupId());
                this.origin(instance.getOrigin());
            }
            if (object instanceof AbstractExternalGroupMapping) {
                instance = (AbstractExternalGroupMapping)object;
                this.metadata(((AbstractExternalGroupMapping)instance).getMetadata());
                this.addAllSchemas(((AbstractExternalGroupMapping)instance).getSchemas());
            }
        }

        @JsonProperty(value="meta")
        public final Builder metadata(Metadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder schema(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            return this;
        }

        public final Builder schemas(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="schemas")
        public final Builder schemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            return this;
        }

        @JsonProperty(value="displayName")
        public final Builder displayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="externalGroup")
        public final Builder externalGroup(String externalGroup) {
            this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="groupId")
        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="origin")
        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ExternalGroupMapping build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ExternalGroupMapping(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("metadata");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("displayName");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("externalGroup");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("origin");
            }
            return "Cannot build ExternalGroupMapping, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _ExternalGroupMapping {
        Metadata metadata;
        List<String> schemas = Collections.emptyList();
        String displayName;
        String externalGroup;
        String groupId;
        String origin;

        Json() {
        }

        @JsonProperty(value="meta")
        public void setMetadata(Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="schemas")
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
        }

        @JsonProperty(value="displayName")
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty(value="externalGroup")
        public void setExternalGroup(String externalGroup) {
            this.externalGroup = externalGroup;
        }

        @JsonProperty(value="groupId")
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getExternalGroup() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }
    }
}

