/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.tokens;

import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.tokens.TokenFormat;
import org.cloudfoundry.uaa.tokens._RefreshTokenRequest;
import org.immutables.value.Generated;

@Generated(from="_RefreshTokenRequest", generator="Immutables")
public final class RefreshTokenRequest
extends _RefreshTokenRequest {
    private final String clientId;
    private final String clientSecret;
    private final String refreshToken;
    @Nullable
    private final TokenFormat tokenFormat;

    private RefreshTokenRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.refreshToken = builder.refreshToken;
        this.tokenFormat = builder.tokenFormat;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public String getRefreshToken() {
        return this.refreshToken;
    }

    @Override
    @Nullable
    public TokenFormat getTokenFormat() {
        return this.tokenFormat;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof RefreshTokenRequest && this.equalTo((RefreshTokenRequest)another);
    }

    private boolean equalTo(RefreshTokenRequest another) {
        return this.clientId.equals(another.clientId) && this.clientSecret.equals(another.clientSecret) && this.refreshToken.equals(another.refreshToken) && Objects.equals((Object)this.tokenFormat, (Object)another.tokenFormat);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + this.clientSecret.hashCode();
        h += (h << 5) + this.refreshToken.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.tokenFormat);
        return h;
    }

    public String toString() {
        return "RefreshTokenRequest{clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", refreshToken=" + this.refreshToken + ", tokenFormat=" + (Object)((Object)this.tokenFormat) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private static final long INIT_BIT_CLIENT_SECRET = 2L;
        private static final long INIT_BIT_REFRESH_TOKEN = 4L;
        private long initBits = 7L;
        private String clientId;
        private String clientSecret;
        private String refreshToken;
        private TokenFormat tokenFormat;

        private Builder() {
        }

        public final Builder from(RefreshTokenRequest instance) {
            return this.from((_RefreshTokenRequest)instance);
        }

        final Builder from(_RefreshTokenRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.clientId(instance.getClientId());
            this.clientSecret(instance.getClientSecret());
            this.refreshToken(instance.getRefreshToken());
            TokenFormat tokenFormatValue = instance.getTokenFormat();
            if (tokenFormatValue != null) {
                this.tokenFormat(tokenFormatValue);
            }
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder clientSecret(String clientSecret) {
            this.clientSecret = Objects.requireNonNull(clientSecret, "clientSecret");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder refreshToken(String refreshToken) {
            this.refreshToken = Objects.requireNonNull(refreshToken, "refreshToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tokenFormat(@Nullable TokenFormat tokenFormat) {
            this.tokenFormat = tokenFormat;
            return this;
        }

        public RefreshTokenRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new RefreshTokenRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("clientSecret");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("refreshToken");
            }
            return "Cannot build RefreshTokenRequest, some of required attributes are not set " + attributes;
        }
    }
}

