/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.users._InviteUsersRequest;
import org.immutables.value.Generated;

@Generated(from="_InviteUsersRequest", generator="Immutables")
public final class InviteUsersRequest
extends _InviteUsersRequest {
    @Nullable
    private final String clientId;
    private final List<String> emails;
    private final String redirectUri;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private InviteUsersRequest(Builder builder) {
        this.clientId = builder.clientId;
        this.emails = InviteUsersRequest.createUnmodifiableList(true, builder.emails);
        this.redirectUri = builder.redirectUri;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonIgnore
    @Nullable
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="emails")
    public List<String> getEmails() {
        return this.emails;
    }

    @Override
    @JsonIgnore
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InviteUsersRequest && this.equalTo((InviteUsersRequest)another);
    }

    private boolean equalTo(InviteUsersRequest another) {
        return Objects.equals(this.clientId, another.clientId) && this.emails.equals(another.emails) && this.redirectUri.equals(another.redirectUri) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + this.emails.hashCode();
        h += (h << 5) + this.redirectUri.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "InviteUsersRequest{clientId=" + this.clientId + ", emails=" + this.emails + ", redirectUri=" + this.redirectUri + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static InviteUsersRequest fromJson(Json json) {
        Builder builder = InviteUsersRequest.builder();
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.emails != null) {
            builder.addAllEmails(json.emails);
        }
        if (json.redirectUri != null) {
            builder.redirectUri(json.redirectUri);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    private static InviteUsersRequest validate(InviteUsersRequest instance) {
        instance.check();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_REDIRECT_URI = 1L;
        private long initBits = 1L;
        private String clientId;
        private List<String> emails = new ArrayList<String>();
        private String redirectUri;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(InviteUsersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_InviteUsersRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _InviteUsersRequest) {
                instance = (_InviteUsersRequest)object;
                this.addAllEmails(((_InviteUsersRequest)instance).getEmails());
                this.redirectUri(((_InviteUsersRequest)instance).getRedirectUri());
                String clientIdValue = ((_InviteUsersRequest)instance).getClientId();
                if (clientIdValue != null) {
                    this.clientId(clientIdValue);
                }
            }
        }

        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Builder email(String element) {
            this.emails.add(Objects.requireNonNull(element, "emails element"));
            return this;
        }

        public final Builder emails(String ... elements) {
            for (String element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder emails(Iterable<String> elements) {
            this.emails.clear();
            return this.addAllEmails(elements);
        }

        public final Builder addAllEmails(Iterable<String> elements) {
            for (String element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder redirectUri(String redirectUri) {
            this.redirectUri = Objects.requireNonNull(redirectUri, "redirectUri");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public InviteUsersRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return InviteUsersRequest.validate(new InviteUsersRequest(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("redirectUri");
            }
            return "Cannot build InviteUsersRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends _InviteUsersRequest {
        String clientId;
        List<String> emails = Collections.emptyList();
        String redirectUri;
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonIgnore
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="emails")
        public void setEmails(List<String> emails) {
            this.emails = emails;
        }

        @JsonIgnore
        public void setRedirectUri(String redirectUri) {
            this.redirectUri = redirectUri;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public String getClientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getEmails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getRedirectUri() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

