/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.routes._ListRoutesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListRoutesRequest", generator="Immutables")
public final class ListRoutesRequest
extends _ListRoutesRequest {
    @Nullable
    private final List<String> domainIds;
    @Nullable
    private final List<String> hosts;
    @Nullable
    private final String organizationId;
    @Nullable
    private final List<String> paths;
    @Nullable
    private final Integer port;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListRoutesRequest(Builder builder) {
        this.domainIds = builder.domainIds == null ? null : ListRoutesRequest.createUnmodifiableList(true, builder.domainIds);
        this.hosts = builder.hosts == null ? null : ListRoutesRequest.createUnmodifiableList(true, builder.hosts);
        this.organizationId = builder.organizationId;
        this.paths = builder.paths == null ? null : ListRoutesRequest.createUnmodifiableList(true, builder.paths);
        this.port = builder.port;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    @Override
    @Nullable
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    @Nullable
    public String getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    @Nullable
    public Integer getPort() {
        return this.port;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListRoutesRequest && this.equalTo((ListRoutesRequest)another);
    }

    private boolean equalTo(ListRoutesRequest another) {
        return Objects.equals(this.domainIds, another.domainIds) && Objects.equals(this.hosts, another.hosts) && Objects.equals(this.organizationId, another.organizationId) && Objects.equals(this.paths, another.paths) && Objects.equals(this.port, another.port) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.domainIds);
        h += (h << 5) + Objects.hashCode(this.hosts);
        h += (h << 5) + Objects.hashCode(this.organizationId);
        h += (h << 5) + Objects.hashCode(this.paths);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListRoutesRequest{domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", organizationId=" + this.organizationId + ", paths=" + this.paths + ", port=" + this.port + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListRoutesRequest", generator="Immutables")
    public static final class Builder {
        private List<String> domainIds = null;
        private List<String> hosts = null;
        private String organizationId;
        private List<String> paths = null;
        private Integer port;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(ListRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof _ListRoutesRequest) {
                List<String> pathsValue;
                List<String> hostsValue;
                Integer portValue;
                List<String> domainIdsValue;
                instance = (_ListRoutesRequest)object;
                String organizationIdValue = ((_ListRoutesRequest)instance).getOrganizationId();
                if (organizationIdValue != null) {
                    this.organizationId(organizationIdValue);
                }
                if ((domainIdsValue = ((_ListRoutesRequest)instance).getDomainIds()) != null) {
                    this.addAllDomainIds(domainIdsValue);
                }
                if ((portValue = ((_ListRoutesRequest)instance).getPort()) != null) {
                    this.port(portValue);
                }
                if ((hostsValue = ((_ListRoutesRequest)instance).getHosts()) != null) {
                    this.addAllHosts(hostsValue);
                }
                if ((pathsValue = ((_ListRoutesRequest)instance).getPaths()) != null) {
                    this.addAllPaths(pathsValue);
                }
            }
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
        }

        public final Builder domainId(String element) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            return this;
        }

        public final Builder domainIds(String ... elements) {
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder domainIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domainIds = null;
                return this;
            }
            this.domainIds = new ArrayList<String>();
            return this.addAllDomainIds(elements);
        }

        public final Builder addAllDomainIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domainIds element");
            if (this.domainIds == null) {
                this.domainIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainIds.add(Objects.requireNonNull(element, "domainIds element"));
            }
            return this;
        }

        public final Builder host(String element) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            return this;
        }

        public final Builder hosts(String ... elements) {
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder hosts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.hosts = null;
                return this;
            }
            this.hosts = new ArrayList<String>();
            return this.addAllHosts(elements);
        }

        public final Builder addAllHosts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "hosts element");
            if (this.hosts == null) {
                this.hosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.hosts.add(Objects.requireNonNull(element, "hosts element"));
            }
            return this;
        }

        public final Builder organizationId(@Nullable String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        public final Builder path(String element) {
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            this.paths.add(Objects.requireNonNull(element, "paths element"));
            return this;
        }

        public final Builder paths(String ... elements) {
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            for (String element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        public final Builder paths(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.paths = null;
                return this;
            }
            this.paths = new ArrayList<String>();
            return this.addAllPaths(elements);
        }

        public final Builder addAllPaths(Iterable<String> elements) {
            Objects.requireNonNull(elements, "paths element");
            if (this.paths == null) {
                this.paths = new ArrayList<String>();
            }
            for (String element : elements) {
                this.paths.add(Objects.requireNonNull(element, "paths element"));
            }
            return this;
        }

        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListRoutesRequest build() {
            return new ListRoutesRequest(this);
        }
    }
}

