/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.packages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum PackageType {
    BITS("bits"),
    DOCKER("docker");

    private final String value;

    private PackageType(String value) {
        this.value = value;
    }

    @JsonCreator
    public static PackageType from(String s) {
        switch (s.toLowerCase()) {
            case "bits": {
                return BITS;
            }
            case "docker": {
                return DOCKER;
            }
        }
        throw new IllegalArgumentException(String.format("Unknown package type: %s", s));
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getValue();
    }
}

