/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.servicebindings;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.servicebindings._ListServiceBindingsRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServiceBindingsRequest", generator="Immutables")
public final class ListServiceBindingsRequest
extends _ListServiceBindingsRequest {
    private final List<String> applicationIds;
    private final List<String> serviceInstanceIds;
    @Nullable
    private final String orderBy;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer perPage;

    private ListServiceBindingsRequest(Builder builder) {
        this.applicationIds = ListServiceBindingsRequest.createUnmodifiableList(true, builder.applicationIds);
        this.serviceInstanceIds = ListServiceBindingsRequest.createUnmodifiableList(true, builder.serviceInstanceIds);
        this.orderBy = builder.orderBy;
        this.page = builder.page;
        this.perPage = builder.perPage;
    }

    @Override
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    @Override
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }

    @Override
    @Nullable
    public String getOrderBy() {
        return this.orderBy;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getPerPage() {
        return this.perPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceBindingsRequest && this.equalTo((ListServiceBindingsRequest)another);
    }

    private boolean equalTo(ListServiceBindingsRequest another) {
        return this.applicationIds.equals(another.applicationIds) && this.serviceInstanceIds.equals(another.serviceInstanceIds) && Objects.equals(this.orderBy, another.orderBy) && Objects.equals(this.page, another.page) && Objects.equals(this.perPage, another.perPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.applicationIds.hashCode();
        h += (h << 5) + this.serviceInstanceIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.orderBy);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.perPage);
        return h;
    }

    public String toString() {
        return "ListServiceBindingsRequest{applicationIds=" + this.applicationIds + ", serviceInstanceIds=" + this.serviceInstanceIds + ", orderBy=" + this.orderBy + ", page=" + this.page + ", perPage=" + this.perPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceBindingsRequest", generator="Immutables")
    public static final class Builder {
        private List<String> applicationIds = new ArrayList<String>();
        private List<String> serviceInstanceIds = new ArrayList<String>();
        private String orderBy;
        private Integer page;
        private Integer perPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListServiceBindingsRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer perPageValue;
                instance = (PaginatedRequest)object;
                String orderByValue = instance.getOrderBy();
                if (orderByValue != null) {
                    this.orderBy(orderByValue);
                }
                if ((perPageValue = instance.getPerPage()) != null) {
                    this.perPage(perPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceBindingsRequest) {
                instance = (_ListServiceBindingsRequest)object;
                this.addAllServiceInstanceIds(((_ListServiceBindingsRequest)instance).getServiceInstanceIds());
                this.addAllApplicationIds(((_ListServiceBindingsRequest)instance).getApplicationIds());
            }
        }

        public final Builder applicationId(String element) {
            this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            return this;
        }

        public final Builder applicationIds(String ... elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder applicationIds(Iterable<String> elements) {
            this.applicationIds.clear();
            return this.addAllApplicationIds(elements);
        }

        public final Builder addAllApplicationIds(Iterable<String> elements) {
            for (String element : elements) {
                this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String element) {
            this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            return this;
        }

        public final Builder serviceInstanceIds(String ... elements) {
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder serviceInstanceIds(Iterable<String> elements) {
            this.serviceInstanceIds.clear();
            return this.addAllServiceInstanceIds(elements);
        }

        public final Builder addAllServiceInstanceIds(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceInstanceIds.add(Objects.requireNonNull(element, "serviceInstanceIds element"));
            }
            return this;
        }

        public final Builder orderBy(@Nullable String orderBy) {
            this.orderBy = orderBy;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder perPage(@Nullable Integer perPage) {
            this.perPage = perPage;
            return this;
        }

        public ListServiceBindingsRequest build() {
            return new ListServiceBindingsRequest(this);
        }
    }
}

