/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.cloudfoundry.uaa.groups.MemberType;
import org.cloudfoundry.uaa.groups._AddMemberRequest;
import org.immutables.value.Generated;

@Generated(from="_AddMemberRequest", generator="Immutables")
public final class AddMemberRequest
extends _AddMemberRequest {
    private final String groupId;
    private final String memberId;
    private final String origin;
    private final MemberType type;
    @Nullable
    private final String identityZoneId;
    @Nullable
    private final String identityZoneSubdomain;

    private AddMemberRequest(Builder builder) {
        this.groupId = builder.groupId;
        this.memberId = builder.memberId;
        this.origin = builder.origin;
        this.type = builder.type;
        this.identityZoneId = builder.identityZoneId;
        this.identityZoneSubdomain = builder.identityZoneSubdomain;
    }

    @Override
    @JsonProperty(value="groupId")
    @JsonIgnore
    public String getGroupId() {
        return this.groupId;
    }

    @Override
    @JsonProperty(value="value")
    public String getMemberId() {
        return this.memberId;
    }

    @Override
    @JsonProperty(value="origin")
    public String getOrigin() {
        return this.origin;
    }

    @Override
    @JsonProperty(value="type")
    public MemberType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="identityZoneId")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneId() {
        return this.identityZoneId;
    }

    @Override
    @JsonProperty(value="identityZoneSubdomain")
    @JsonIgnore
    @Nullable
    public String getIdentityZoneSubdomain() {
        return this.identityZoneSubdomain;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof AddMemberRequest && this.equalTo((AddMemberRequest)another);
    }

    private boolean equalTo(AddMemberRequest another) {
        return this.groupId.equals(another.groupId) && this.memberId.equals(another.memberId) && this.origin.equals(another.origin) && this.type.equals((Object)another.type) && Objects.equals(this.identityZoneId, another.identityZoneId) && Objects.equals(this.identityZoneSubdomain, another.identityZoneSubdomain);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.groupId.hashCode();
        h += (h << 5) + this.memberId.hashCode();
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.identityZoneId);
        h += (h << 5) + Objects.hashCode(this.identityZoneSubdomain);
        return h;
    }

    public String toString() {
        return "AddMemberRequest{groupId=" + this.groupId + ", memberId=" + this.memberId + ", origin=" + this.origin + ", type=" + (Object)((Object)this.type) + ", identityZoneId=" + this.identityZoneId + ", identityZoneSubdomain=" + this.identityZoneSubdomain + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static AddMemberRequest fromJson(Json json) {
        Builder builder = AddMemberRequest.builder();
        if (json.groupId != null) {
            builder.groupId(json.groupId);
        }
        if (json.memberId != null) {
            builder.memberId(json.memberId);
        }
        if (json.origin != null) {
            builder.origin(json.origin);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.identityZoneId != null) {
            builder.identityZoneId(json.identityZoneId);
        }
        if (json.identityZoneSubdomain != null) {
            builder.identityZoneSubdomain(json.identityZoneSubdomain);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="_AddMemberRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_GROUP_ID = 1L;
        private static final long INIT_BIT_MEMBER_ID = 2L;
        private static final long INIT_BIT_ORIGIN = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private long initBits = 15L;
        private String groupId;
        private String memberId;
        private String origin;
        private MemberType type;
        private String identityZoneId;
        private String identityZoneSubdomain;

        private Builder() {
        }

        public final Builder from(IdentityZoned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AddMemberRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_AddMemberRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            IdentityZoned instance;
            if (object instanceof IdentityZoned) {
                String identityZoneIdValue;
                instance = (IdentityZoned)object;
                String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
                if (identityZoneSubdomainValue != null) {
                    this.identityZoneSubdomain(identityZoneSubdomainValue);
                }
                if ((identityZoneIdValue = instance.getIdentityZoneId()) != null) {
                    this.identityZoneId(identityZoneIdValue);
                }
            }
            if (object instanceof _AddMemberRequest) {
                instance = (_AddMemberRequest)object;
                this.type(((_AddMemberRequest)instance).getType());
                this.groupId(((_AddMemberRequest)instance).getGroupId());
                this.origin(((_AddMemberRequest)instance).getOrigin());
                this.memberId(((_AddMemberRequest)instance).getMemberId());
            }
        }

        public final Builder groupId(String groupId) {
            this.groupId = Objects.requireNonNull(groupId, "groupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder memberId(String memberId) {
            this.memberId = Objects.requireNonNull(memberId, "memberId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder origin(String origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder type(MemberType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder identityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
            return this;
        }

        public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
            return this;
        }

        public AddMemberRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new AddMemberRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("groupId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("memberId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build AddMemberRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_AddMemberRequest", generator="Immutables")
    static final class Json
    extends _AddMemberRequest {
        String groupId;
        String memberId;
        String origin;
        MemberType type;
        String identityZoneId;
        String identityZoneSubdomain;

        Json() {
        }

        @JsonProperty(value="groupId")
        @JsonIgnore
        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @JsonProperty(value="value")
        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        @JsonProperty(value="origin")
        public void setOrigin(String origin) {
            this.origin = origin;
        }

        @JsonProperty(value="type")
        public void setType(MemberType type) {
            this.type = type;
        }

        @JsonProperty(value="identityZoneId")
        @JsonIgnore
        public void setIdentityZoneId(@Nullable String identityZoneId) {
            this.identityZoneId = identityZoneId;
        }

        @JsonProperty(value="identityZoneSubdomain")
        @JsonIgnore
        public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
            this.identityZoneSubdomain = identityZoneSubdomain;
        }

        @Override
        public String getGroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMemberId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOrigin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MemberType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getIdentityZoneSubdomain() {
            throw new UnsupportedOperationException();
        }
    }
}

