/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.uaa.groups.Member;
import org.cloudfoundry.uaa.groups._ListMembersResponse;
import org.immutables.value.Generated;

@Generated(from="_ListMembersResponse", generator="Immutables")
public final class ListMembersResponse
extends _ListMembersResponse {
    private final List<Member> members;

    private ListMembersResponse(Builder builder) {
        this.members = ListMembersResponse.createUnmodifiableList(true, builder.members);
    }

    @Override
    @JsonProperty(value="members")
    public List<Member> getMembers() {
        return this.members;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListMembersResponse && this.equalTo((ListMembersResponse)another);
    }

    private boolean equalTo(ListMembersResponse another) {
        return this.members.equals(another.members);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.members.hashCode();
        return h;
    }

    public String toString() {
        return "ListMembersResponse{members=" + this.members + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ListMembersResponse fromJson(Json json) {
        Builder builder = ListMembersResponse.builder();
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListMembersResponse", generator="Immutables")
    public static final class Builder {
        private List<Member> members = new ArrayList<Member>();

        private Builder() {
        }

        public final Builder from(ListMembersResponse instance) {
            return this.from((_ListMembersResponse)instance);
        }

        final Builder from(_ListMembersResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllMembers(instance.getMembers());
            return this;
        }

        public final Builder member(Member element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder members(Member ... elements) {
            for (Member element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @JsonProperty(value="members")
        public final Builder members(Iterable<? extends Member> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends Member> elements) {
            for (Member member : elements) {
                this.members.add(Objects.requireNonNull(member, "members element"));
            }
            return this;
        }

        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_ListMembersResponse", generator="Immutables")
    static final class Json
    extends _ListMembersResponse {
        List<Member> members = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="members")
        public void setMembers(List<Member> members) {
            this.members = members;
        }

        @Override
        public List<Member> getMembers() {
            throw new UnsupportedOperationException();
        }
    }
}

