package org.cloudfoundry.client.v2.applicationusageevents;

import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Application Usage Events operation
 */
@Generated(from = "_ListApplicationUsageEventsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListApplicationUsageEventsRequest
    extends org.cloudfoundry.client.v2.applicationusageevents._ListApplicationUsageEventsRequest {
  private final @Nullable String afterApplicationUsageEventId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListApplicationUsageEventsRequest(ListApplicationUsageEventsRequest.Builder builder) {
    this.afterApplicationUsageEventId = builder.afterApplicationUsageEventId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The after application usage event id: Restrict results to Application Usage Events after the one with the given id
   */
  @Override
  public @Nullable String getAfterApplicationUsageEventId() {
    return afterApplicationUsageEventId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListApplicationUsageEventsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListApplicationUsageEventsRequest
        && equalTo((ListApplicationUsageEventsRequest) another);
  }

  private boolean equalTo(ListApplicationUsageEventsRequest another) {
    return Objects.equals(afterApplicationUsageEventId, another.afterApplicationUsageEventId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code afterApplicationUsageEventId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(afterApplicationUsageEventId);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListApplicationUsageEventsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListApplicationUsageEventsRequest{"
        + "afterApplicationUsageEventId=" + afterApplicationUsageEventId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListApplicationUsageEventsRequest ListApplicationUsageEventsRequest}.
   * <pre>
   * ListApplicationUsageEventsRequest.builder()
   *    .afterApplicationUsageEventId(String | null) // nullable {@link ListApplicationUsageEventsRequest#getAfterApplicationUsageEventId() afterApplicationUsageEventId}
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListApplicationUsageEventsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListApplicationUsageEventsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListApplicationUsageEventsRequest#getResultsPerPage() resultsPerPage}
   *    .build();
   * </pre>
   * @return A new ListApplicationUsageEventsRequest builder
   */
  public static ListApplicationUsageEventsRequest.Builder builder() {
    return new ListApplicationUsageEventsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListApplicationUsageEventsRequest ListApplicationUsageEventsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListApplicationUsageEventsRequest", generator = "Immutables")
  public static final class Builder {
    private String afterApplicationUsageEventId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListApplicationUsageEventsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListApplicationUsageEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListApplicationUsageEventsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListApplicationUsageEventsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.applicationusageevents._ListApplicationUsageEventsRequest) {
        org.cloudfoundry.client.v2.applicationusageevents._ListApplicationUsageEventsRequest instance = (org.cloudfoundry.client.v2.applicationusageevents._ListApplicationUsageEventsRequest) object;
        String afterApplicationUsageEventIdValue = instance.getAfterApplicationUsageEventId();
        if (afterApplicationUsageEventIdValue != null) {
          afterApplicationUsageEventId(afterApplicationUsageEventIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListApplicationUsageEventsRequest#getAfterApplicationUsageEventId() afterApplicationUsageEventId} attribute.
     * @param afterApplicationUsageEventId The value for afterApplicationUsageEventId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder afterApplicationUsageEventId(@Nullable String afterApplicationUsageEventId) {
      this.afterApplicationUsageEventId = afterApplicationUsageEventId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationUsageEventsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationUsageEventsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListApplicationUsageEventsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListApplicationUsageEventsRequest ListApplicationUsageEventsRequest}.
     * @return An immutable instance of ListApplicationUsageEventsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListApplicationUsageEventsRequest build() {
      return new ListApplicationUsageEventsRequest(this);
    }
  }
}
