package org.cloudfoundry.client.v2.environmentvariablegroups;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the update staging environment variable group
 */
@Generated(from = "_UpdateStagingEnvironmentVariablesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateStagingEnvironmentVariablesRequest
    extends org.cloudfoundry.client.v2.environmentvariablegroups._UpdateStagingEnvironmentVariablesRequest {
  private final @Nullable Map<String, Object> environmentVariables;

  private UpdateStagingEnvironmentVariablesRequest(UpdateStagingEnvironmentVariablesRequest.Builder builder) {
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
  }

  /**
   * @return The value of the {@code environmentVariables} attribute
   */
  @JsonProperty("environmentVariables")
  @JsonValue
  @Override
  public @Nullable Map<String, Object> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * This instance is equal to all instances of {@code UpdateStagingEnvironmentVariablesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateStagingEnvironmentVariablesRequest
        && equalTo((UpdateStagingEnvironmentVariablesRequest) another);
  }

  private boolean equalTo(UpdateStagingEnvironmentVariablesRequest another) {
    return Objects.equals(environmentVariables, another.environmentVariables);
  }

  /**
   * Computes a hash code from attributes: {@code environmentVariables}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(environmentVariables);
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateStagingEnvironmentVariablesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateStagingEnvironmentVariablesRequest{"
        + "environmentVariables=" + environmentVariables
        + "}";
  }

  /**
   * @param jsonValue to construct object from
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateStagingEnvironmentVariablesRequest fromJson(Map<String, Object> jsonValue) {
    UpdateStagingEnvironmentVariablesRequest.Builder builder = UpdateStagingEnvironmentVariablesRequest.builder();
    builder.putAllEnvironmentVariables(jsonValue);
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateStagingEnvironmentVariablesRequest UpdateStagingEnvironmentVariablesRequest}.
   * <pre>
   * UpdateStagingEnvironmentVariablesRequest.builder()
   *    .environmentVariables(Map&lt;String, Object&gt; | null) // nullable {@link UpdateStagingEnvironmentVariablesRequest#getEnvironmentVariables() environmentVariables}
   *    .build();
   * </pre>
   * @return A new UpdateStagingEnvironmentVariablesRequest builder
   */
  public static UpdateStagingEnvironmentVariablesRequest.Builder builder() {
    return new UpdateStagingEnvironmentVariablesRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateStagingEnvironmentVariablesRequest UpdateStagingEnvironmentVariablesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateStagingEnvironmentVariablesRequest", generator = "Immutables")
  public static final class Builder {
    private Map<String, Object> environmentVariables = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateStagingEnvironmentVariablesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateStagingEnvironmentVariablesRequest instance) {
      return from((_UpdateStagingEnvironmentVariablesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateStagingEnvironmentVariablesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateStagingEnvironmentVariablesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Object> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link UpdateStagingEnvironmentVariablesRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, Object value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateStagingEnvironmentVariablesRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends Object> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      String k = entry.getKey();
      Object v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateStagingEnvironmentVariablesRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends Object> entries) {
      if (entries == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, Object>();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateStagingEnvironmentVariablesRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends Object> entries) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, Object>();
      }
      for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
        String k = e.getKey();
        Object v = e.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateStagingEnvironmentVariablesRequest UpdateStagingEnvironmentVariablesRequest}.
     * @return An immutable instance of UpdateStagingEnvironmentVariablesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateStagingEnvironmentVariablesRequest build() {
      return new UpdateStagingEnvironmentVariablesRequest(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
