package org.cloudfoundry.client.v2.privatedomains;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List Private Domain Shared Organizations operation
 */
@Generated(from = "_ListPrivateDomainSharedOrganizationsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListPrivateDomainSharedOrganizationsRequest
    extends org.cloudfoundry.client.v2.privatedomains._ListPrivateDomainSharedOrganizationsRequest {
  private final @Nullable List<String> auditorIds;
  private final @Nullable List<String> billingManagerIds;
  private final @Nullable List<String> managerIds;
  private final @Nullable List<String> names;
  private final String privateDomainId;
  private final @Nullable List<String> spaceIds;
  private final @Nullable List<String> statuses;
  private final @Nullable List<String> userIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListPrivateDomainSharedOrganizationsRequest(ListPrivateDomainSharedOrganizationsRequest.Builder builder) {
    this.auditorIds = builder.auditorIds == null ? null : createUnmodifiableList(true, builder.auditorIds);
    this.billingManagerIds = builder.billingManagerIds == null ? null : createUnmodifiableList(true, builder.billingManagerIds);
    this.managerIds = builder.managerIds == null ? null : createUnmodifiableList(true, builder.managerIds);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.privateDomainId = builder.privateDomainId;
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.statuses = builder.statuses == null ? null : createUnmodifiableList(true, builder.statuses);
    this.userIds = builder.userIds == null ? null : createUnmodifiableList(true, builder.userIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The auditor ids
   */
  @Override
  public @Nullable List<String> getAuditorIds() {
    return auditorIds;
  }

  /**
   * The billing manager ids
   */
  @Override
  public @Nullable List<String> getBillingManagerIds() {
    return billingManagerIds;
  }

  /**
   * The manager ids
   */
  @Override
  public @Nullable List<String> getManagerIds() {
    return managerIds;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The private domain id
   */
  @Override
  public String getPrivateDomainId() {
    return privateDomainId;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The statuses
   */
  @Override
  public @Nullable List<String> getStatuses() {
    return statuses;
  }

  /**
   * The user ids
   */
  @Override
  public @Nullable List<String> getUserIds() {
    return userIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListPrivateDomainSharedOrganizationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListPrivateDomainSharedOrganizationsRequest
        && equalTo((ListPrivateDomainSharedOrganizationsRequest) another);
  }

  private boolean equalTo(ListPrivateDomainSharedOrganizationsRequest another) {
    return Objects.equals(auditorIds, another.auditorIds)
        && Objects.equals(billingManagerIds, another.billingManagerIds)
        && Objects.equals(managerIds, another.managerIds)
        && Objects.equals(names, another.names)
        && privateDomainId.equals(another.privateDomainId)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(statuses, another.statuses)
        && Objects.equals(userIds, another.userIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code auditorIds}, {@code billingManagerIds}, {@code managerIds}, {@code names}, {@code privateDomainId}, {@code spaceIds}, {@code statuses}, {@code userIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(auditorIds);
    h += (h << 5) + Objects.hashCode(billingManagerIds);
    h += (h << 5) + Objects.hashCode(managerIds);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + privateDomainId.hashCode();
    h += (h << 5) + Objects.hashCode(spaceIds);
    h += (h << 5) + Objects.hashCode(statuses);
    h += (h << 5) + Objects.hashCode(userIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListPrivateDomainSharedOrganizationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListPrivateDomainSharedOrganizationsRequest{"
        + "auditorIds=" + auditorIds
        + ", billingManagerIds=" + billingManagerIds
        + ", managerIds=" + managerIds
        + ", names=" + names
        + ", privateDomainId=" + privateDomainId
        + ", spaceIds=" + spaceIds
        + ", statuses=" + statuses
        + ", userIds=" + userIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListPrivateDomainSharedOrganizationsRequest ListPrivateDomainSharedOrganizationsRequest}.
   * <pre>
   * ListPrivateDomainSharedOrganizationsRequest.builder()
   *    .auditorIds(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getAuditorIds() auditorIds}
   *    .billingManagerIds(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getBillingManagerIds() billingManagerIds}
   *    .managerIds(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getManagerIds() managerIds}
   *    .names(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getNames() names}
   *    .privateDomainId(String) // required {@link ListPrivateDomainSharedOrganizationsRequest#getPrivateDomainId() privateDomainId}
   *    .spaceIds(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getSpaceIds() spaceIds}
   *    .statuses(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getStatuses() statuses}
   *    .userIds(List&lt;String&gt; | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getUserIds() userIds}
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListPrivateDomainSharedOrganizationsRequest#getResultsPerPage() resultsPerPage}
   *    .build();
   * </pre>
   * @return A new ListPrivateDomainSharedOrganizationsRequest builder
   */
  public static ListPrivateDomainSharedOrganizationsRequest.Builder builder() {
    return new ListPrivateDomainSharedOrganizationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListPrivateDomainSharedOrganizationsRequest ListPrivateDomainSharedOrganizationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListPrivateDomainSharedOrganizationsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PRIVATE_DOMAIN_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> auditorIds = null;
    private List<String> billingManagerIds = null;
    private List<String> managerIds = null;
    private List<String> names = null;
    private String privateDomainId;
    private List<String> spaceIds = null;
    private List<String> statuses = null;
    private List<String> userIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListPrivateDomainSharedOrganizationsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListPrivateDomainSharedOrganizationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListPrivateDomainSharedOrganizationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListPrivateDomainSharedOrganizationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.privatedomains._ListPrivateDomainSharedOrganizationsRequest) {
        org.cloudfoundry.client.v2.privatedomains._ListPrivateDomainSharedOrganizationsRequest instance = (org.cloudfoundry.client.v2.privatedomains._ListPrivateDomainSharedOrganizationsRequest) object;
        List<String> managerIdsValue = instance.getManagerIds();
        if (managerIdsValue != null) {
          addAllManagerIds(managerIdsValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> userIdsValue = instance.getUserIds();
        if (userIdsValue != null) {
          addAllUserIds(userIdsValue);
        }
        List<String> statusesValue = instance.getStatuses();
        if (statusesValue != null) {
          addAllStatuses(statusesValue);
        }
        List<String> auditorIdsValue = instance.getAuditorIds();
        if (auditorIdsValue != null) {
          addAllAuditorIds(auditorIdsValue);
        }
        List<String> billingManagerIdsValue = instance.getBillingManagerIds();
        if (billingManagerIdsValue != null) {
          addAllBillingManagerIds(billingManagerIdsValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        privateDomainId(instance.getPrivateDomainId());
      }
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getAuditorIds() auditorIds} list.
     * @param element A auditorIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorId(String element) {
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getAuditorIds() auditorIds} list.
     * @param elements An array of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorIds(String... elements) {
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getAuditorIds() auditorIds} list.
     * @param elements An iterable of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditorIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditorIds = null;
        return this;
      }
      this.auditorIds = new ArrayList<String>();
      return addAllAuditorIds(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getAuditorIds() auditorIds} list.
     * @param elements An iterable of auditorIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditorIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditorIds element");
      if (this.auditorIds == null) {
        this.auditorIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditorIds.add(Objects.requireNonNull(element, "auditorIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getBillingManagerIds() billingManagerIds} list.
     * @param element A billingManagerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagerId(String element) {
      if (this.billingManagerIds == null) {
        this.billingManagerIds = new ArrayList<String>();
      }
      this.billingManagerIds.add(Objects.requireNonNull(element, "billingManagerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getBillingManagerIds() billingManagerIds} list.
     * @param elements An array of billingManagerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagerIds(String... elements) {
      if (this.billingManagerIds == null) {
        this.billingManagerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.billingManagerIds.add(Objects.requireNonNull(element, "billingManagerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getBillingManagerIds() billingManagerIds} list.
     * @param elements An iterable of billingManagerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.billingManagerIds = null;
        return this;
      }
      this.billingManagerIds = new ArrayList<String>();
      return addAllBillingManagerIds(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getBillingManagerIds() billingManagerIds} list.
     * @param elements An iterable of billingManagerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBillingManagerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "billingManagerIds element");
      if (this.billingManagerIds == null) {
        this.billingManagerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.billingManagerIds.add(Objects.requireNonNull(element, "billingManagerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getManagerIds() managerIds} list.
     * @param element A managerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerId(String element) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getManagerIds() managerIds} list.
     * @param elements An array of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(String... elements) {
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managerIds = null;
        return this;
      }
      this.managerIds = new ArrayList<String>();
      return addAllManagerIds(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getManagerIds() managerIds} list.
     * @param elements An iterable of managerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagerIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managerIds element");
      if (this.managerIds == null) {
        this.managerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managerIds.add(Objects.requireNonNull(element, "managerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListPrivateDomainSharedOrganizationsRequest#getPrivateDomainId() privateDomainId} attribute.
     * @param privateDomainId The value for privateDomainId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder privateDomainId(String privateDomainId) {
      this.privateDomainId = Objects.requireNonNull(privateDomainId, "privateDomainId");
      initBits &= ~INIT_BIT_PRIVATE_DOMAIN_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getStatuses() statuses} list.
     * @param element A statuses element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder status(String element) {
      if (this.statuses == null) {
        this.statuses = new ArrayList<String>();
      }
      this.statuses.add(Objects.requireNonNull(element, "statuses element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getStatuses() statuses} list.
     * @param elements An array of statuses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statuses(String... elements) {
      if (this.statuses == null) {
        this.statuses = new ArrayList<String>();
      }
      for (String element : elements) {
        this.statuses.add(Objects.requireNonNull(element, "statuses element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getStatuses() statuses} list.
     * @param elements An iterable of statuses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder statuses(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.statuses = null;
        return this;
      }
      this.statuses = new ArrayList<String>();
      return addAllStatuses(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getStatuses() statuses} list.
     * @param elements An iterable of statuses elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStatuses(Iterable<String> elements) {
      Objects.requireNonNull(elements, "statuses element");
      if (this.statuses == null) {
        this.statuses = new ArrayList<String>();
      }
      for (String element : elements) {
        this.statuses.add(Objects.requireNonNull(element, "statuses element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPrivateDomainSharedOrganizationsRequest#getUserIds() userIds} list.
     * @param element A userIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userId(String element) {
      if (this.userIds == null) {
        this.userIds = new ArrayList<String>();
      }
      this.userIds.add(Objects.requireNonNull(element, "userIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getUserIds() userIds} list.
     * @param elements An array of userIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userIds(String... elements) {
      if (this.userIds == null) {
        this.userIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.userIds.add(Objects.requireNonNull(element, "userIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPrivateDomainSharedOrganizationsRequest#getUserIds() userIds} list.
     * @param elements An iterable of userIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder userIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.userIds = null;
        return this;
      }
      this.userIds = new ArrayList<String>();
      return addAllUserIds(elements);
    }

    /**
     * Adds elements to {@link ListPrivateDomainSharedOrganizationsRequest#getUserIds() userIds} list.
     * @param elements An iterable of userIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUserIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "userIds element");
      if (this.userIds == null) {
        this.userIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.userIds.add(Objects.requireNonNull(element, "userIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListPrivateDomainSharedOrganizationsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListPrivateDomainSharedOrganizationsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListPrivateDomainSharedOrganizationsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListPrivateDomainSharedOrganizationsRequest ListPrivateDomainSharedOrganizationsRequest}.
     * @return An immutable instance of ListPrivateDomainSharedOrganizationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListPrivateDomainSharedOrganizationsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListPrivateDomainSharedOrganizationsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PRIVATE_DOMAIN_ID) != 0) attributes.add("privateDomainId");
      return "Cannot build ListPrivateDomainSharedOrganizationsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
