package org.cloudfoundry.client.v2.routes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Applications for the Route operation
 */
@Generated(from = "_ListRouteApplicationsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListRouteApplicationsRequest
    extends org.cloudfoundry.client.v2.routes._ListRouteApplicationsRequest {
  private final @Nullable String applicationId;
  private final @Nullable Boolean diego;
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final String routeId;
  private final @Nullable List<String> spaceIds;
  private final @Nullable List<String> stackIds;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListRouteApplicationsRequest(ListRouteApplicationsRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.diego = builder.diego;
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.routeId = builder.routeId;
    this.spaceIds = builder.spaceIds == null ? null : createUnmodifiableList(true, builder.spaceIds);
    this.stackIds = builder.stackIds == null ? null : createUnmodifiableList(true, builder.stackIds);
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The application id
   */
  @Override
  public @Nullable String getApplicationId() {
    return applicationId;
  }

  /**
   * The diego flag
   */
  @Override
  public @Nullable Boolean getDiego() {
    return diego;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The route id
   */
  @Override
  public String getRouteId() {
    return routeId;
  }

  /**
   * The space ids
   */
  @Override
  public @Nullable List<String> getSpaceIds() {
    return spaceIds;
  }

  /**
   * The stack ids
   */
  @Override
  public @Nullable List<String> getStackIds() {
    return stackIds;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListRouteApplicationsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListRouteApplicationsRequest
        && equalTo((ListRouteApplicationsRequest) another);
  }

  private boolean equalTo(ListRouteApplicationsRequest another) {
    return Objects.equals(applicationId, another.applicationId)
        && Objects.equals(diego, another.diego)
        && Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && routeId.equals(another.routeId)
        && Objects.equals(spaceIds, another.spaceIds)
        && Objects.equals(stackIds, another.stackIds)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code diego}, {@code names}, {@code organizationIds}, {@code routeId}, {@code spaceIds}, {@code stackIds}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationId);
    h += (h << 5) + Objects.hashCode(diego);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + routeId.hashCode();
    h += (h << 5) + Objects.hashCode(spaceIds);
    h += (h << 5) + Objects.hashCode(stackIds);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListRouteApplicationsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListRouteApplicationsRequest{"
        + "applicationId=" + applicationId
        + ", diego=" + diego
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", routeId=" + routeId
        + ", spaceIds=" + spaceIds
        + ", stackIds=" + stackIds
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListRouteApplicationsRequest ListRouteApplicationsRequest}.
   * <pre>
   * ListRouteApplicationsRequest.builder()
   *    .applicationId(String | null) // nullable {@link ListRouteApplicationsRequest#getApplicationId() applicationId}
   *    .diego(Boolean | null) // nullable {@link ListRouteApplicationsRequest#getDiego() diego}
   *    .names(List&lt;String&gt; | null) // nullable {@link ListRouteApplicationsRequest#getNames() names}
   *    .organizationIds(List&lt;String&gt; | null) // nullable {@link ListRouteApplicationsRequest#getOrganizationIds() organizationIds}
   *    .routeId(String) // required {@link ListRouteApplicationsRequest#getRouteId() routeId}
   *    .spaceIds(List&lt;String&gt; | null) // nullable {@link ListRouteApplicationsRequest#getSpaceIds() spaceIds}
   *    .stackIds(List&lt;String&gt; | null) // nullable {@link ListRouteApplicationsRequest#getStackIds() stackIds}
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListRouteApplicationsRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListRouteApplicationsRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListRouteApplicationsRequest#getResultsPerPage() resultsPerPage}
   *    .build();
   * </pre>
   * @return A new ListRouteApplicationsRequest builder
   */
  public static ListRouteApplicationsRequest.Builder builder() {
    return new ListRouteApplicationsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListRouteApplicationsRequest ListRouteApplicationsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListRouteApplicationsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_ROUTE_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private Boolean diego;
    private List<String> names = null;
    private List<String> organizationIds = null;
    private String routeId;
    private List<String> spaceIds = null;
    private List<String> stackIds = null;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListRouteApplicationsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListRouteApplicationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListRouteApplicationsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListRouteApplicationsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.routes._ListRouteApplicationsRequest) {
        org.cloudfoundry.client.v2.routes._ListRouteApplicationsRequest instance = (org.cloudfoundry.client.v2.routes._ListRouteApplicationsRequest) object;
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        routeId(instance.getRouteId());
        List<String> stackIdsValue = instance.getStackIds();
        if (stackIdsValue != null) {
          addAllStackIds(stackIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        Boolean diegoValue = instance.getDiego();
        if (diegoValue != null) {
          diego(diegoValue);
        }
        List<String> spaceIdsValue = instance.getSpaceIds();
        if (spaceIdsValue != null) {
          addAllSpaceIds(spaceIdsValue);
        }
        String applicationIdValue = instance.getApplicationId();
        if (applicationIdValue != null) {
          applicationId(applicationIdValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link ListRouteApplicationsRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(@Nullable String applicationId) {
      this.applicationId = applicationId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteApplicationsRequest#getDiego() diego} attribute.
     * @param diego The value for diego (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diego(@Nullable Boolean diego) {
      this.diego = diego;
      return this;
    }

    /**
     * Adds one element to {@link ListRouteApplicationsRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteApplicationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRouteApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteApplicationsRequest#getRouteId() routeId} attribute.
     * @param routeId The value for routeId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder routeId(String routeId) {
      this.routeId = Objects.requireNonNull(routeId, "routeId");
      initBits &= ~INIT_BIT_ROUTE_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListRouteApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param element A spaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String element) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An array of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(String... elements) {
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.spaceIds = null;
        return this;
      }
      this.spaceIds = new ArrayList<String>();
      return addAllSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getSpaceIds() spaceIds} list.
     * @param elements An iterable of spaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "spaceIds element");
      if (this.spaceIds == null) {
        this.spaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.spaceIds.add(Objects.requireNonNull(element, "spaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListRouteApplicationsRequest#getStackIds() stackIds} list.
     * @param element A stackIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackId(String element) {
      if (this.stackIds == null) {
        this.stackIds = new ArrayList<String>();
      }
      this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getStackIds() stackIds} list.
     * @param elements An array of stackIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackIds(String... elements) {
      if (this.stackIds == null) {
        this.stackIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListRouteApplicationsRequest#getStackIds() stackIds} list.
     * @param elements An iterable of stackIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder stackIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.stackIds = null;
        return this;
      }
      this.stackIds = new ArrayList<String>();
      return addAllStackIds(elements);
    }

    /**
     * Adds elements to {@link ListRouteApplicationsRequest#getStackIds() stackIds} list.
     * @param elements An iterable of stackIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStackIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "stackIds element");
      if (this.stackIds == null) {
        this.stackIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.stackIds.add(Objects.requireNonNull(element, "stackIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteApplicationsRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteApplicationsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListRouteApplicationsRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListRouteApplicationsRequest ListRouteApplicationsRequest}.
     * @return An immutable instance of ListRouteApplicationsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListRouteApplicationsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListRouteApplicationsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ROUTE_ID) != 0) attributes.add("routeId");
      return "Cannot build ListRouteApplicationsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
