package org.cloudfoundry.client.v2.securitygroups;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Spaces for the Security Group operation
 */
@Generated(from = "_ListSecurityGroupSpacesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSecurityGroupSpacesRequest
    extends org.cloudfoundry.client.v2.securitygroups._ListSecurityGroupSpacesRequest {
  private final @Nullable List<String> applicationIds;
  private final @Nullable List<String> developerIds;
  private final @Nullable List<String> names;
  private final @Nullable List<String> organizationIds;
  private final String securityGroupId;
  private final @Nullable String spaceId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListSecurityGroupSpacesRequest(ListSecurityGroupSpacesRequest.Builder builder) {
    this.applicationIds = builder.applicationIds == null ? null : createUnmodifiableList(true, builder.applicationIds);
    this.developerIds = builder.developerIds == null ? null : createUnmodifiableList(true, builder.developerIds);
    this.names = builder.names == null ? null : createUnmodifiableList(true, builder.names);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.securityGroupId = builder.securityGroupId;
    this.spaceId = builder.spaceId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The application ids
   */
  @Override
  public @Nullable List<String> getApplicationIds() {
    return applicationIds;
  }

  /**
   * The developer ids
   */
  @Override
  public @Nullable List<String> getDeveloperIds() {
    return developerIds;
  }

  /**
   * The names
   */
  @Override
  public @Nullable List<String> getNames() {
    return names;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The security group id
   */
  @Override
  public String getSecurityGroupId() {
    return securityGroupId;
  }

  /**
   * The space id
   */
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListSecurityGroupSpacesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSecurityGroupSpacesRequest
        && equalTo((ListSecurityGroupSpacesRequest) another);
  }

  private boolean equalTo(ListSecurityGroupSpacesRequest another) {
    return Objects.equals(applicationIds, another.applicationIds)
        && Objects.equals(developerIds, another.developerIds)
        && Objects.equals(names, another.names)
        && Objects.equals(organizationIds, another.organizationIds)
        && securityGroupId.equals(another.securityGroupId)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code applicationIds}, {@code developerIds}, {@code names}, {@code organizationIds}, {@code securityGroupId}, {@code spaceId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(applicationIds);
    h += (h << 5) + Objects.hashCode(developerIds);
    h += (h << 5) + Objects.hashCode(names);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + securityGroupId.hashCode();
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListSecurityGroupSpacesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSecurityGroupSpacesRequest{"
        + "applicationIds=" + applicationIds
        + ", developerIds=" + developerIds
        + ", names=" + names
        + ", organizationIds=" + organizationIds
        + ", securityGroupId=" + securityGroupId
        + ", spaceId=" + spaceId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListSecurityGroupSpacesRequest ListSecurityGroupSpacesRequest}.
   * <pre>
   * ListSecurityGroupSpacesRequest.builder()
   *    .applicationIds(List&lt;String&gt; | null) // nullable {@link ListSecurityGroupSpacesRequest#getApplicationIds() applicationIds}
   *    .developerIds(List&lt;String&gt; | null) // nullable {@link ListSecurityGroupSpacesRequest#getDeveloperIds() developerIds}
   *    .names(List&lt;String&gt; | null) // nullable {@link ListSecurityGroupSpacesRequest#getNames() names}
   *    .organizationIds(List&lt;String&gt; | null) // nullable {@link ListSecurityGroupSpacesRequest#getOrganizationIds() organizationIds}
   *    .securityGroupId(String) // required {@link ListSecurityGroupSpacesRequest#getSecurityGroupId() securityGroupId}
   *    .spaceId(String | null) // nullable {@link ListSecurityGroupSpacesRequest#getSpaceId() spaceId}
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListSecurityGroupSpacesRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListSecurityGroupSpacesRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListSecurityGroupSpacesRequest#getResultsPerPage() resultsPerPage}
   *    .build();
   * </pre>
   * @return A new ListSecurityGroupSpacesRequest builder
   */
  public static ListSecurityGroupSpacesRequest.Builder builder() {
    return new ListSecurityGroupSpacesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSecurityGroupSpacesRequest ListSecurityGroupSpacesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSecurityGroupSpacesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SECURITY_GROUP_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> applicationIds = null;
    private List<String> developerIds = null;
    private List<String> names = null;
    private List<String> organizationIds = null;
    private String securityGroupId;
    private String spaceId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSecurityGroupSpacesRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSecurityGroupSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSecurityGroupSpacesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSecurityGroupSpacesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof org.cloudfoundry.client.v2.securitygroups._ListSecurityGroupSpacesRequest) {
        org.cloudfoundry.client.v2.securitygroups._ListSecurityGroupSpacesRequest instance = (org.cloudfoundry.client.v2.securitygroups._ListSecurityGroupSpacesRequest) object;
        List<String> developerIdsValue = instance.getDeveloperIds();
        if (developerIdsValue != null) {
          addAllDeveloperIds(developerIdsValue);
        }
        securityGroupId(instance.getSecurityGroupId());
        String spaceIdValue = instance.getSpaceId();
        if (spaceIdValue != null) {
          spaceId(spaceIdValue);
        }
        List<String> namesValue = instance.getNames();
        if (namesValue != null) {
          addAllNames(namesValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        List<String> applicationIdsValue = instance.getApplicationIds();
        if (applicationIdsValue != null) {
          addAllApplicationIds(applicationIdsValue);
        }
      }
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
    }

    /**
     * Adds one element to {@link ListSecurityGroupSpacesRequest#getApplicationIds() applicationIds} list.
     * @param element A applicationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String element) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getApplicationIds() applicationIds} list.
     * @param elements An array of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(String... elements) {
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupSpacesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.applicationIds = null;
        return this;
      }
      this.applicationIds = new ArrayList<String>();
      return addAllApplicationIds(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getApplicationIds() applicationIds} list.
     * @param elements An iterable of applicationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllApplicationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "applicationIds element");
      if (this.applicationIds == null) {
        this.applicationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.applicationIds.add(Objects.requireNonNull(element, "applicationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupSpacesRequest#getDeveloperIds() developerIds} list.
     * @param element A developerIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerId(String element) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getDeveloperIds() developerIds} list.
     * @param elements An array of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(String... elements) {
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupSpacesRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder developerIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.developerIds = null;
        return this;
      }
      this.developerIds = new ArrayList<String>();
      return addAllDeveloperIds(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getDeveloperIds() developerIds} list.
     * @param elements An iterable of developerIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDeveloperIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "developerIds element");
      if (this.developerIds == null) {
        this.developerIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.developerIds.add(Objects.requireNonNull(element, "developerIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupSpacesRequest#getNames() names} list.
     * @param element A names element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String element) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      this.names.add(Objects.requireNonNull(element, "names element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getNames() names} list.
     * @param elements An array of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(String... elements) {
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupSpacesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder names(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.names = null;
        return this;
      }
      this.names = new ArrayList<String>();
      return addAllNames(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getNames() names} list.
     * @param elements An iterable of names elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllNames(Iterable<String> elements) {
      Objects.requireNonNull(elements, "names element");
      if (this.names == null) {
        this.names = new ArrayList<String>();
      }
      for (String element : elements) {
        this.names.add(Objects.requireNonNull(element, "names element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSecurityGroupSpacesRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSecurityGroupSpacesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListSecurityGroupSpacesRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupSpacesRequest#getSecurityGroupId() securityGroupId} attribute.
     * @param securityGroupId The value for securityGroupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder securityGroupId(String securityGroupId) {
      this.securityGroupId = Objects.requireNonNull(securityGroupId, "securityGroupId");
      initBits &= ~INIT_BIT_SECURITY_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupSpacesRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupSpacesRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupSpacesRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSecurityGroupSpacesRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListSecurityGroupSpacesRequest ListSecurityGroupSpacesRequest}.
     * @return An immutable instance of ListSecurityGroupSpacesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSecurityGroupSpacesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSecurityGroupSpacesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SECURITY_GROUP_ID) != 0) attributes.add("securityGroupId");
      return "Cannot build ListSecurityGroupSpacesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
