package org.cloudfoundry.client.v2.spaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.immutables.value.Generated;

/**
 * The request payload for the List all Developers for the Space operation
 */
@Generated(from = "_ListSpaceDevelopersRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListSpaceDevelopersRequest
    extends org.cloudfoundry.client.v2.spaces._ListSpaceDevelopersRequest {
  private final @Nullable List<String> auditedOrganizationIds;
  private final @Nullable List<String> auditedSpaceIds;
  private final @Nullable List<String> billingManagedOrganizationIds;
  private final @Nullable List<String> managedOrganizationIds;
  private final @Nullable List<String> managedSpaceIds;
  private final @Nullable List<String> organizationIds;
  private final String spaceId;
  private final @Nullable OrderDirection orderDirection;
  private final @Nullable Integer page;
  private final @Nullable Integer resultsPerPage;

  private ListSpaceDevelopersRequest(ListSpaceDevelopersRequest.Builder builder) {
    this.auditedOrganizationIds = builder.auditedOrganizationIds == null ? null : createUnmodifiableList(true, builder.auditedOrganizationIds);
    this.auditedSpaceIds = builder.auditedSpaceIds == null ? null : createUnmodifiableList(true, builder.auditedSpaceIds);
    this.billingManagedOrganizationIds = builder.billingManagedOrganizationIds == null ? null : createUnmodifiableList(true, builder.billingManagedOrganizationIds);
    this.managedOrganizationIds = builder.managedOrganizationIds == null ? null : createUnmodifiableList(true, builder.managedOrganizationIds);
    this.managedSpaceIds = builder.managedSpaceIds == null ? null : createUnmodifiableList(true, builder.managedSpaceIds);
    this.organizationIds = builder.organizationIds == null ? null : createUnmodifiableList(true, builder.organizationIds);
    this.spaceId = builder.spaceId;
    this.orderDirection = builder.orderDirection;
    this.page = builder.page;
    this.resultsPerPage = builder.resultsPerPage;
  }

  /**
   * The audited organization ids
   */
  @Override
  public @Nullable List<String> getAuditedOrganizationIds() {
    return auditedOrganizationIds;
  }

  /**
   * The audited space ids
   */
  @Override
  public @Nullable List<String> getAuditedSpaceIds() {
    return auditedSpaceIds;
  }

  /**
   * The billing managed organization ids
   */
  @Override
  public @Nullable List<String> getBillingManagedOrganizationIds() {
    return billingManagedOrganizationIds;
  }

  /**
   * The managed organization ids
   */
  @Override
  public @Nullable List<String> getManagedOrganizationIds() {
    return managedOrganizationIds;
  }

  /**
   * The managed space ids
   */
  @Override
  public @Nullable List<String> getManagedSpaceIds() {
    return managedSpaceIds;
  }

  /**
   * The organization ids
   */
  @Override
  public @Nullable List<String> getOrganizationIds() {
    return organizationIds;
  }

  /**
   * The space id
   */
  @Override
  public String getSpaceId() {
    return spaceId;
  }

  /**
   * The order direction
   */
  @Override
  public @Nullable OrderDirection getOrderDirection() {
    return orderDirection;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getResultsPerPage() {
    return resultsPerPage;
  }

  /**
   * This instance is equal to all instances of {@code ListSpaceDevelopersRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListSpaceDevelopersRequest
        && equalTo((ListSpaceDevelopersRequest) another);
  }

  private boolean equalTo(ListSpaceDevelopersRequest another) {
    return Objects.equals(auditedOrganizationIds, another.auditedOrganizationIds)
        && Objects.equals(auditedSpaceIds, another.auditedSpaceIds)
        && Objects.equals(billingManagedOrganizationIds, another.billingManagedOrganizationIds)
        && Objects.equals(managedOrganizationIds, another.managedOrganizationIds)
        && Objects.equals(managedSpaceIds, another.managedSpaceIds)
        && Objects.equals(organizationIds, another.organizationIds)
        && spaceId.equals(another.spaceId)
        && Objects.equals(orderDirection, another.orderDirection)
        && Objects.equals(page, another.page)
        && Objects.equals(resultsPerPage, another.resultsPerPage);
  }

  /**
   * Computes a hash code from attributes: {@code auditedOrganizationIds}, {@code auditedSpaceIds}, {@code billingManagedOrganizationIds}, {@code managedOrganizationIds}, {@code managedSpaceIds}, {@code organizationIds}, {@code spaceId}, {@code orderDirection}, {@code page}, {@code resultsPerPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(auditedOrganizationIds);
    h += (h << 5) + Objects.hashCode(auditedSpaceIds);
    h += (h << 5) + Objects.hashCode(billingManagedOrganizationIds);
    h += (h << 5) + Objects.hashCode(managedOrganizationIds);
    h += (h << 5) + Objects.hashCode(managedSpaceIds);
    h += (h << 5) + Objects.hashCode(organizationIds);
    h += (h << 5) + spaceId.hashCode();
    h += (h << 5) + Objects.hashCode(orderDirection);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(resultsPerPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListSpaceDevelopersRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListSpaceDevelopersRequest{"
        + "auditedOrganizationIds=" + auditedOrganizationIds
        + ", auditedSpaceIds=" + auditedSpaceIds
        + ", billingManagedOrganizationIds=" + billingManagedOrganizationIds
        + ", managedOrganizationIds=" + managedOrganizationIds
        + ", managedSpaceIds=" + managedSpaceIds
        + ", organizationIds=" + organizationIds
        + ", spaceId=" + spaceId
        + ", orderDirection=" + orderDirection
        + ", page=" + page
        + ", resultsPerPage=" + resultsPerPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListSpaceDevelopersRequest ListSpaceDevelopersRequest}.
   * <pre>
   * ListSpaceDevelopersRequest.builder()
   *    .auditedOrganizationIds(List&lt;String&gt; | null) // nullable {@link ListSpaceDevelopersRequest#getAuditedOrganizationIds() auditedOrganizationIds}
   *    .auditedSpaceIds(List&lt;String&gt; | null) // nullable {@link ListSpaceDevelopersRequest#getAuditedSpaceIds() auditedSpaceIds}
   *    .billingManagedOrganizationIds(List&lt;String&gt; | null) // nullable {@link ListSpaceDevelopersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds}
   *    .managedOrganizationIds(List&lt;String&gt; | null) // nullable {@link ListSpaceDevelopersRequest#getManagedOrganizationIds() managedOrganizationIds}
   *    .managedSpaceIds(List&lt;String&gt; | null) // nullable {@link ListSpaceDevelopersRequest#getManagedSpaceIds() managedSpaceIds}
   *    .organizationIds(List&lt;String&gt; | null) // nullable {@link ListSpaceDevelopersRequest#getOrganizationIds() organizationIds}
   *    .spaceId(String) // required {@link ListSpaceDevelopersRequest#getSpaceId() spaceId}
   *    .orderDirection(org.cloudfoundry.client.v2.OrderDirection | null) // nullable {@link ListSpaceDevelopersRequest#getOrderDirection() orderDirection}
   *    .page(Integer | null) // nullable {@link ListSpaceDevelopersRequest#getPage() page}
   *    .resultsPerPage(Integer | null) // nullable {@link ListSpaceDevelopersRequest#getResultsPerPage() resultsPerPage}
   *    .build();
   * </pre>
   * @return A new ListSpaceDevelopersRequest builder
   */
  public static ListSpaceDevelopersRequest.Builder builder() {
    return new ListSpaceDevelopersRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListSpaceDevelopersRequest ListSpaceDevelopersRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListSpaceDevelopersRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> auditedOrganizationIds = null;
    private List<String> auditedSpaceIds = null;
    private List<String> billingManagedOrganizationIds = null;
    private List<String> managedOrganizationIds = null;
    private List<String> managedSpaceIds = null;
    private List<String> organizationIds = null;
    private String spaceId;
    private OrderDirection orderDirection;
    private Integer page;
    private Integer resultsPerPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v2.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListSpaceDevelopersRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListSpaceDevelopersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListSpaceDevelopersRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListSpaceDevelopersRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        OrderDirection orderDirectionValue = instance.getOrderDirection();
        if (orderDirectionValue != null) {
          orderDirection(orderDirectionValue);
        }
        Integer resultsPerPageValue = instance.getResultsPerPage();
        if (resultsPerPageValue != null) {
          resultsPerPage(resultsPerPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v2.spaces._ListSpaceDevelopersRequest) {
        org.cloudfoundry.client.v2.spaces._ListSpaceDevelopersRequest instance = (org.cloudfoundry.client.v2.spaces._ListSpaceDevelopersRequest) object;
        List<String> auditedOrganizationIdsValue = instance.getAuditedOrganizationIds();
        if (auditedOrganizationIdsValue != null) {
          addAllAuditedOrganizationIds(auditedOrganizationIdsValue);
        }
        spaceId(instance.getSpaceId());
        List<String> managedOrganizationIdsValue = instance.getManagedOrganizationIds();
        if (managedOrganizationIdsValue != null) {
          addAllManagedOrganizationIds(managedOrganizationIdsValue);
        }
        List<String> organizationIdsValue = instance.getOrganizationIds();
        if (organizationIdsValue != null) {
          addAllOrganizationIds(organizationIdsValue);
        }
        List<String> auditedSpaceIdsValue = instance.getAuditedSpaceIds();
        if (auditedSpaceIdsValue != null) {
          addAllAuditedSpaceIds(auditedSpaceIdsValue);
        }
        List<String> billingManagedOrganizationIdsValue = instance.getBillingManagedOrganizationIds();
        if (billingManagedOrganizationIdsValue != null) {
          addAllBillingManagedOrganizationIds(billingManagedOrganizationIdsValue);
        }
        List<String> managedSpaceIdsValue = instance.getManagedSpaceIds();
        if (managedSpaceIdsValue != null) {
          addAllManagedSpaceIds(managedSpaceIdsValue);
        }
      }
    }

    /**
     * Adds one element to {@link ListSpaceDevelopersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param element A auditedOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationId(String element) {
      if (this.auditedOrganizationIds == null) {
        this.auditedOrganizationIds = new ArrayList<String>();
      }
      this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param elements An array of auditedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationIds(String... elements) {
      if (this.auditedOrganizationIds == null) {
        this.auditedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDevelopersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param elements An iterable of auditedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditedOrganizationIds = null;
        return this;
      }
      this.auditedOrganizationIds = new ArrayList<String>();
      return addAllAuditedOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getAuditedOrganizationIds() auditedOrganizationIds} list.
     * @param elements An iterable of auditedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditedOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditedOrganizationIds element");
      if (this.auditedOrganizationIds == null) {
        this.auditedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedOrganizationIds.add(Objects.requireNonNull(element, "auditedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDevelopersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param element A auditedSpaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceId(String element) {
      if (this.auditedSpaceIds == null) {
        this.auditedSpaceIds = new ArrayList<String>();
      }
      this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param elements An array of auditedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceIds(String... elements) {
      if (this.auditedSpaceIds == null) {
        this.auditedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDevelopersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param elements An iterable of auditedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder auditedSpaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.auditedSpaceIds = null;
        return this;
      }
      this.auditedSpaceIds = new ArrayList<String>();
      return addAllAuditedSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getAuditedSpaceIds() auditedSpaceIds} list.
     * @param elements An iterable of auditedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuditedSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "auditedSpaceIds element");
      if (this.auditedSpaceIds == null) {
        this.auditedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.auditedSpaceIds.add(Objects.requireNonNull(element, "auditedSpaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDevelopersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param element A billingManagedOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationId(String element) {
      if (this.billingManagedOrganizationIds == null) {
        this.billingManagedOrganizationIds = new ArrayList<String>();
      }
      this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param elements An array of billingManagedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationIds(String... elements) {
      if (this.billingManagedOrganizationIds == null) {
        this.billingManagedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDevelopersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param elements An iterable of billingManagedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder billingManagedOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.billingManagedOrganizationIds = null;
        return this;
      }
      this.billingManagedOrganizationIds = new ArrayList<String>();
      return addAllBillingManagedOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getBillingManagedOrganizationIds() billingManagedOrganizationIds} list.
     * @param elements An iterable of billingManagedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllBillingManagedOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "billingManagedOrganizationIds element");
      if (this.billingManagedOrganizationIds == null) {
        this.billingManagedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.billingManagedOrganizationIds.add(Objects.requireNonNull(element, "billingManagedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDevelopersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param element A managedOrganizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationId(String element) {
      if (this.managedOrganizationIds == null) {
        this.managedOrganizationIds = new ArrayList<String>();
      }
      this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param elements An array of managedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationIds(String... elements) {
      if (this.managedOrganizationIds == null) {
        this.managedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDevelopersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param elements An iterable of managedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedOrganizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managedOrganizationIds = null;
        return this;
      }
      this.managedOrganizationIds = new ArrayList<String>();
      return addAllManagedOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getManagedOrganizationIds() managedOrganizationIds} list.
     * @param elements An iterable of managedOrganizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagedOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managedOrganizationIds element");
      if (this.managedOrganizationIds == null) {
        this.managedOrganizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedOrganizationIds.add(Objects.requireNonNull(element, "managedOrganizationIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDevelopersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param element A managedSpaceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceId(String element) {
      if (this.managedSpaceIds == null) {
        this.managedSpaceIds = new ArrayList<String>();
      }
      this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param elements An array of managedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceIds(String... elements) {
      if (this.managedSpaceIds == null) {
        this.managedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDevelopersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param elements An iterable of managedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder managedSpaceIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.managedSpaceIds = null;
        return this;
      }
      this.managedSpaceIds = new ArrayList<String>();
      return addAllManagedSpaceIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getManagedSpaceIds() managedSpaceIds} list.
     * @param elements An iterable of managedSpaceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllManagedSpaceIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "managedSpaceIds element");
      if (this.managedSpaceIds == null) {
        this.managedSpaceIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.managedSpaceIds.add(Objects.requireNonNull(element, "managedSpaceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ListSpaceDevelopersRequest#getOrganizationIds() organizationIds} list.
     * @param element A organizationIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationId(String element) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getOrganizationIds() organizationIds} list.
     * @param elements An array of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(String... elements) {
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListSpaceDevelopersRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder organizationIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.organizationIds = null;
        return this;
      }
      this.organizationIds = new ArrayList<String>();
      return addAllOrganizationIds(elements);
    }

    /**
     * Adds elements to {@link ListSpaceDevelopersRequest#getOrganizationIds() organizationIds} list.
     * @param elements An iterable of organizationIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOrganizationIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "organizationIds element");
      if (this.organizationIds == null) {
        this.organizationIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.organizationIds.add(Objects.requireNonNull(element, "organizationIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDevelopersRequest#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder spaceId(String spaceId) {
      this.spaceId = Objects.requireNonNull(spaceId, "spaceId");
      initBits &= ~INIT_BIT_SPACE_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDevelopersRequest#getOrderDirection() orderDirection} attribute.
     * @param orderDirection The value for orderDirection (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
      this.orderDirection = orderDirection;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDevelopersRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListSpaceDevelopersRequest#getResultsPerPage() resultsPerPage} attribute.
     * @param resultsPerPage The value for resultsPerPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
      this.resultsPerPage = resultsPerPage;
      return this;
    }

    /**
     * Builds a new {@link ListSpaceDevelopersRequest ListSpaceDevelopersRequest}.
     * @return An immutable instance of ListSpaceDevelopersRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListSpaceDevelopersRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListSpaceDevelopersRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE_ID) != 0) attributes.add("spaceId");
      return "Cannot build ListSpaceDevelopersRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
