package org.cloudfoundry.client.v2.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.spaces.SpaceResource;
import org.immutables.value.Generated;

/**
 * The response payload for the List all Spaces for the User operation
 */
@Generated(from = "_ListUserSpacesResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListUserSpacesResponse extends org.cloudfoundry.client.v2.users._ListUserSpacesResponse {
  private final @Nullable String nextUrl;
  private final @Nullable String previousUrl;
  private final @Nullable List<SpaceResource> resources;
  private final @Nullable Integer totalPages;
  private final @Nullable Integer totalResults;

  private ListUserSpacesResponse(ListUserSpacesResponse.Builder builder) {
    this.nextUrl = builder.nextUrl;
    this.previousUrl = builder.previousUrl;
    this.resources = builder.resources == null ? null : createUnmodifiableList(true, builder.resources);
    this.totalPages = builder.totalPages;
    this.totalResults = builder.totalResults;
  }

  /**
   * The next url
   */
  @JsonProperty("next_url")
  @Override
  public @Nullable String getNextUrl() {
    return nextUrl;
  }

  /**
   * The previous url
   */
  @JsonProperty("prev_url")
  @Override
  public @Nullable String getPreviousUrl() {
    return previousUrl;
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public @Nullable List<SpaceResource> getResources() {
    return resources;
  }

  /**
   * The total pages
   */
  @JsonProperty("total_pages")
  @Override
  public @Nullable Integer getTotalPages() {
    return totalPages;
  }

  /**
   * The total results
   */
  @JsonProperty("total_results")
  @Override
  public @Nullable Integer getTotalResults() {
    return totalResults;
  }

  /**
   * This instance is equal to all instances of {@code ListUserSpacesResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListUserSpacesResponse
        && equalTo((ListUserSpacesResponse) another);
  }

  private boolean equalTo(ListUserSpacesResponse another) {
    return Objects.equals(nextUrl, another.nextUrl)
        && Objects.equals(previousUrl, another.previousUrl)
        && Objects.equals(resources, another.resources)
        && Objects.equals(totalPages, another.totalPages)
        && Objects.equals(totalResults, another.totalResults);
  }

  /**
   * Computes a hash code from attributes: {@code nextUrl}, {@code previousUrl}, {@code resources}, {@code totalPages}, {@code totalResults}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(nextUrl);
    h += (h << 5) + Objects.hashCode(previousUrl);
    h += (h << 5) + Objects.hashCode(resources);
    h += (h << 5) + Objects.hashCode(totalPages);
    h += (h << 5) + Objects.hashCode(totalResults);
    return h;
  }

  /**
   * Prints the immutable value {@code ListUserSpacesResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListUserSpacesResponse{"
        + "nextUrl=" + nextUrl
        + ", previousUrl=" + previousUrl
        + ", resources=" + resources
        + ", totalPages=" + totalPages
        + ", totalResults=" + totalResults
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ListUserSpacesResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.users._ListUserSpacesResponse {
    String nextUrl;
    String previousUrl;
    List<SpaceResource> resources = null;
    Integer totalPages;
    Integer totalResults;
    @JsonProperty("next_url")
    public void setNextUrl(@Nullable String nextUrl) {
      this.nextUrl = nextUrl;
    }
    @JsonProperty("prev_url")
    public void setPreviousUrl(@Nullable String previousUrl) {
      this.previousUrl = previousUrl;
    }
    @JsonProperty("resources")
    public void setResources(@Nullable List<SpaceResource> resources) {
      this.resources = resources;
    }
    @JsonProperty("total_pages")
    public void setTotalPages(@Nullable Integer totalPages) {
      this.totalPages = totalPages;
    }
    @JsonProperty("total_results")
    public void setTotalResults(@Nullable Integer totalResults) {
      this.totalResults = totalResults;
    }
    @Override
    public String getNextUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getPreviousUrl() { throw new UnsupportedOperationException(); }
    @Override
    public List<SpaceResource> getResources() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalPages() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getTotalResults() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ListUserSpacesResponse fromJson(Json json) {
    ListUserSpacesResponse.Builder builder = ListUserSpacesResponse.builder();
    if (json.nextUrl != null) {
      builder.nextUrl(json.nextUrl);
    }
    if (json.previousUrl != null) {
      builder.previousUrl(json.previousUrl);
    }
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    if (json.totalPages != null) {
      builder.totalPages(json.totalPages);
    }
    if (json.totalResults != null) {
      builder.totalResults(json.totalResults);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ListUserSpacesResponse ListUserSpacesResponse}.
   * <pre>
   * ListUserSpacesResponse.builder()
   *    .nextUrl(String | null) // nullable {@link ListUserSpacesResponse#getNextUrl() nextUrl}
   *    .previousUrl(String | null) // nullable {@link ListUserSpacesResponse#getPreviousUrl() previousUrl}
   *    .resources(List&lt;org.cloudfoundry.client.v2.spaces.SpaceResource&gt; | null) // nullable {@link ListUserSpacesResponse#getResources() resources}
   *    .totalPages(Integer | null) // nullable {@link ListUserSpacesResponse#getTotalPages() totalPages}
   *    .totalResults(Integer | null) // nullable {@link ListUserSpacesResponse#getTotalResults() totalResults}
   *    .build();
   * </pre>
   * @return A new ListUserSpacesResponse builder
   */
  public static ListUserSpacesResponse.Builder builder() {
    return new ListUserSpacesResponse.Builder();
  }

  /**
   * Builds instances of type {@link ListUserSpacesResponse ListUserSpacesResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListUserSpacesResponse", generator = "Immutables")
  public static final class Builder {
    private String nextUrl;
    private String previousUrl;
    private List<SpaceResource> resources = null;
    private Integer totalPages;
    private Integer totalResults;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListUserSpacesResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListUserSpacesResponse instance) {
      return from((_ListUserSpacesResponse) instance);
    }

    /**
     * Copy abstract value type {@code _ListUserSpacesResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListUserSpacesResponse instance) {
      Objects.requireNonNull(instance, "instance");
      String nextUrlValue = instance.getNextUrl();
      if (nextUrlValue != null) {
        nextUrl(nextUrlValue);
      }
      String previousUrlValue = instance.getPreviousUrl();
      if (previousUrlValue != null) {
        previousUrl(previousUrlValue);
      }
      List<SpaceResource> resourcesValue = instance.getResources();
      if (resourcesValue != null) {
        addAllResources(resourcesValue);
      }
      Integer totalPagesValue = instance.getTotalPages();
      if (totalPagesValue != null) {
        totalPages(totalPagesValue);
      }
      Integer totalResultsValue = instance.getTotalResults();
      if (totalResultsValue != null) {
        totalResults(totalResultsValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserSpacesResponse#getNextUrl() nextUrl} attribute.
     * @param nextUrl The value for nextUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("next_url")
    public final Builder nextUrl(@Nullable String nextUrl) {
      this.nextUrl = nextUrl;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserSpacesResponse#getPreviousUrl() previousUrl} attribute.
     * @param previousUrl The value for previousUrl (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("prev_url")
    public final Builder previousUrl(@Nullable String previousUrl) {
      this.previousUrl = previousUrl;
      return this;
    }

    /**
     * Adds one element to {@link ListUserSpacesResponse#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(SpaceResource element) {
      if (this.resources == null) {
        this.resources = new ArrayList<SpaceResource>();
      }
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link ListUserSpacesResponse#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(SpaceResource... elements) {
      if (this.resources == null) {
        this.resources = new ArrayList<SpaceResource>();
      }
      for (SpaceResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListUserSpacesResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(@Nullable Iterable<? extends SpaceResource> elements) {
      if (elements == null) {
        this.resources = null;
        return this;
      }
      this.resources = new ArrayList<SpaceResource>();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link ListUserSpacesResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends SpaceResource> elements) {
      Objects.requireNonNull(elements, "resources element");
      if (this.resources == null) {
        this.resources = new ArrayList<SpaceResource>();
      }
      for (SpaceResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserSpacesResponse#getTotalPages() totalPages} attribute.
     * @param totalPages The value for totalPages (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_pages")
    public final Builder totalPages(@Nullable Integer totalPages) {
      this.totalPages = totalPages;
      return this;
    }

    /**
     * Initializes the value for the {@link ListUserSpacesResponse#getTotalResults() totalResults} attribute.
     * @param totalResults The value for totalResults (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("total_results")
    public final Builder totalResults(@Nullable Integer totalResults) {
      this.totalResults = totalResults;
      return this;
    }

    /**
     * Builds a new {@link ListUserSpacesResponse ListUserSpacesResponse}.
     * @return An immutable instance of ListUserSpacesResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListUserSpacesResponse build() {
      return new ListUserSpacesResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
