package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Metadata;
import org.immutables.value.Generated;

/**
 * The request payload for the Create Application operation
 */
@Generated(from = "_CreateApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class CreateApplicationRequest
    extends org.cloudfoundry.client.v3.applications._CreateApplicationRequest {
  private final @Nullable Map<String, String> environmentVariables;
  private final @Nullable Lifecycle lifecycle;
  private final @Nullable Metadata metadata;
  private final String name;
  private final ApplicationRelationships relationships;

  private CreateApplicationRequest(CreateApplicationRequest.Builder builder) {
    this.environmentVariables = builder.environmentVariables == null ? null : createUnmodifiableMap(false, false, builder.environmentVariables);
    this.lifecycle = builder.lifecycle;
    this.metadata = builder.metadata;
    this.name = builder.name;
    this.relationships = builder.relationships;
  }

  /**
   * The environment variables
   */
  @JsonProperty("environment_variables")
  @Override
  public @Nullable Map<String, String> getEnvironmentVariables() {
    return environmentVariables;
  }

  /**
   * The lifecycle
   */
  @JsonProperty("lifecycle")
  @Override
  public @Nullable Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * The metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * The name
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * The relationships
   */
  @JsonProperty("relationships")
  @Override
  public ApplicationRelationships getRelationships() {
    return relationships;
  }

  /**
   * This instance is equal to all instances of {@code CreateApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof CreateApplicationRequest
        && equalTo((CreateApplicationRequest) another);
  }

  private boolean equalTo(CreateApplicationRequest another) {
    return Objects.equals(environmentVariables, another.environmentVariables)
        && Objects.equals(lifecycle, another.lifecycle)
        && Objects.equals(metadata, another.metadata)
        && name.equals(another.name)
        && relationships.equals(another.relationships);
  }

  /**
   * Computes a hash code from attributes: {@code environmentVariables}, {@code lifecycle}, {@code metadata}, {@code name}, {@code relationships}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(environmentVariables);
    h += (h << 5) + Objects.hashCode(lifecycle);
    h += (h << 5) + Objects.hashCode(metadata);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + relationships.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code CreateApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "CreateApplicationRequest{"
        + "environmentVariables=" + environmentVariables
        + ", lifecycle=" + lifecycle
        + ", metadata=" + metadata
        + ", name=" + name
        + ", relationships=" + relationships
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_CreateApplicationRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._CreateApplicationRequest {
    Map<String, String> environmentVariables = null;
    Lifecycle lifecycle;
    Metadata metadata;
    String name;
    ApplicationRelationships relationships;
    @JsonProperty("environment_variables")
    public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
      this.environmentVariables = environmentVariables;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("relationships")
    public void setRelationships(ApplicationRelationships relationships) {
      this.relationships = relationships;
    }
    @Override
    public Map<String, String> getEnvironmentVariables() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public ApplicationRelationships getRelationships() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static CreateApplicationRequest fromJson(Json json) {
    CreateApplicationRequest.Builder builder = CreateApplicationRequest.builder();
    if (json.environmentVariables != null) {
      builder.putAllEnvironmentVariables(json.environmentVariables);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.relationships != null) {
      builder.relationships(json.relationships);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link CreateApplicationRequest CreateApplicationRequest}.
   * <pre>
   * CreateApplicationRequest.builder()
   *    .environmentVariables(Map&lt;String, String&gt; | null) // nullable {@link CreateApplicationRequest#getEnvironmentVariables() environmentVariables}
   *    .lifecycle(org.cloudfoundry.client.v3.Lifecycle | null) // nullable {@link CreateApplicationRequest#getLifecycle() lifecycle}
   *    .metadata(org.cloudfoundry.client.v3.Metadata | null) // nullable {@link CreateApplicationRequest#getMetadata() metadata}
   *    .name(String) // required {@link CreateApplicationRequest#getName() name}
   *    .relationships(org.cloudfoundry.client.v3.applications.ApplicationRelationships) // required {@link CreateApplicationRequest#getRelationships() relationships}
   *    .build();
   * </pre>
   * @return A new CreateApplicationRequest builder
   */
  public static CreateApplicationRequest.Builder builder() {
    return new CreateApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link CreateApplicationRequest CreateApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_CreateApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_RELATIONSHIPS = 0x2L;
    private long initBits = 0x3L;

    private Map<String, String> environmentVariables = null;
    private Lifecycle lifecycle;
    private Metadata metadata;
    private String name;
    private ApplicationRelationships relationships;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code CreateApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(CreateApplicationRequest instance) {
      return from((_CreateApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _CreateApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_CreateApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
      if (environmentVariablesValue != null) {
        putAllEnvironmentVariables(environmentVariablesValue);
      }
      Lifecycle lifecycleValue = instance.getLifecycle();
      if (lifecycleValue != null) {
        lifecycle(lifecycleValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      name(instance.getName());
      relationships(instance.getRelationships());
      return this;
    }

    /**
     * Put one entry to the {@link CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map.
     * @param key The key in the environmentVariables map
     * @param value The associated value in the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(String key, String value) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      this.environmentVariables.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.environmentVariables.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder environmentVariables(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.environmentVariables = null;
        return this;
      }
      this.environmentVariables = new LinkedHashMap<String, String>();
      return putAllEnvironmentVariables(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CreateApplicationRequest#getEnvironmentVariables() environmentVariables} map. Nulls are not permitted
     * @param entries The entries that will be added to the environmentVariables map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllEnvironmentVariables(Map<String, ? extends String> entries) {
      if (this.environmentVariables == null) {
        this.environmentVariables = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.environmentVariables.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link CreateApplicationRequest#getRelationships() relationships} attribute.
     * @param relationships The value for relationships 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder relationships(ApplicationRelationships relationships) {
      this.relationships = Objects.requireNonNull(relationships, "relationships");
      initBits &= ~INIT_BIT_RELATIONSHIPS;
      return this;
    }

    /**
     * Builds a new {@link CreateApplicationRequest CreateApplicationRequest}.
     * @return An immutable instance of CreateApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public CreateApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new CreateApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_RELATIONSHIPS) != 0) attributes.add("relationships");
      return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
