package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the Scale Application operation
 */
@Generated(from = "_ScaleApplicationRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ScaleApplicationRequest
    extends org.cloudfoundry.client.v3.applications._ScaleApplicationRequest {
  private final String applicationId;
  private final @Nullable Integer diskInMb;
  private final @Nullable Integer instances;
  private final @Nullable Integer memoryInMb;
  private final String type;

  private ScaleApplicationRequest(ScaleApplicationRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.diskInMb = builder.diskInMb;
    this.instances = builder.instances;
    this.memoryInMb = builder.memoryInMb;
    this.type = builder.type;
  }

  /**
   * The application id
   */
  @JsonProperty("applicationId")
  @JsonIgnore
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The disk size
   */
  @JsonProperty("disk_in_mb")
  @Override
  public @Nullable Integer getDiskInMb() {
    return diskInMb;
  }

  /**
   * The number of instances
   */
  @JsonProperty("instances")
  @Override
  public @Nullable Integer getInstances() {
    return instances;
  }

  /**
   * The memory size
   */
  @JsonProperty("memory_in_mb")
  @Override
  public @Nullable Integer getMemoryInMb() {
    return memoryInMb;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @JsonIgnore
  @Override
  public String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code ScaleApplicationRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ScaleApplicationRequest
        && equalTo((ScaleApplicationRequest) another);
  }

  private boolean equalTo(ScaleApplicationRequest another) {
    return applicationId.equals(another.applicationId)
        && Objects.equals(diskInMb, another.diskInMb)
        && Objects.equals(instances, another.instances)
        && Objects.equals(memoryInMb, another.memoryInMb)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code diskInMb}, {@code instances}, {@code memoryInMb}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + Objects.hashCode(diskInMb);
    h += (h << 5) + Objects.hashCode(instances);
    h += (h << 5) + Objects.hashCode(memoryInMb);
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ScaleApplicationRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ScaleApplicationRequest{"
        + "applicationId=" + applicationId
        + ", diskInMb=" + diskInMb
        + ", instances=" + instances
        + ", memoryInMb=" + memoryInMb
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ScaleApplicationRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._ScaleApplicationRequest {
    String applicationId;
    Integer diskInMb;
    Integer instances;
    Integer memoryInMb;
    String type;
    @JsonProperty("applicationId")
    @JsonIgnore
    public void setApplicationId(String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("disk_in_mb")
    public void setDiskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
    }
    @JsonProperty("instances")
    public void setInstances(@Nullable Integer instances) {
      this.instances = instances;
    }
    @JsonProperty("memory_in_mb")
    public void setMemoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
    }
    @JsonProperty("type")
    @JsonIgnore
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getDiskInMb() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getInstances() { throw new UnsupportedOperationException(); }
    @Override
    public Integer getMemoryInMb() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ScaleApplicationRequest fromJson(Json json) {
    ScaleApplicationRequest.Builder builder = ScaleApplicationRequest.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.diskInMb != null) {
      builder.diskInMb(json.diskInMb);
    }
    if (json.instances != null) {
      builder.instances(json.instances);
    }
    if (json.memoryInMb != null) {
      builder.memoryInMb(json.memoryInMb);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ScaleApplicationRequest ScaleApplicationRequest}.
   * <pre>
   * ScaleApplicationRequest.builder()
   *    .applicationId(String) // required {@link ScaleApplicationRequest#getApplicationId() applicationId}
   *    .diskInMb(Integer | null) // nullable {@link ScaleApplicationRequest#getDiskInMb() diskInMb}
   *    .instances(Integer | null) // nullable {@link ScaleApplicationRequest#getInstances() instances}
   *    .memoryInMb(Integer | null) // nullable {@link ScaleApplicationRequest#getMemoryInMb() memoryInMb}
   *    .type(String) // required {@link ScaleApplicationRequest#getType() type}
   *    .build();
   * </pre>
   * @return A new ScaleApplicationRequest builder
   */
  public static ScaleApplicationRequest.Builder builder() {
    return new ScaleApplicationRequest.Builder();
  }

  /**
   * Builds instances of type {@link ScaleApplicationRequest ScaleApplicationRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ScaleApplicationRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private Integer diskInMb;
    private Integer instances;
    private Integer memoryInMb;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ScaleApplicationRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ScaleApplicationRequest instance) {
      return from((_ScaleApplicationRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ScaleApplicationRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ScaleApplicationRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      Integer diskInMbValue = instance.getDiskInMb();
      if (diskInMbValue != null) {
        diskInMb(diskInMbValue);
      }
      Integer instancesValue = instance.getInstances();
      if (instancesValue != null) {
        instances(instancesValue);
      }
      Integer memoryInMbValue = instance.getMemoryInMb();
      if (memoryInMbValue != null) {
        memoryInMb(memoryInMbValue);
      }
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getDiskInMb() diskInMb} attribute.
     * @param diskInMb The value for diskInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder diskInMb(@Nullable Integer diskInMb) {
      this.diskInMb = diskInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getInstances() instances} attribute.
     * @param instances The value for instances (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder instances(@Nullable Integer instances) {
      this.instances = instances;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getMemoryInMb() memoryInMb} attribute.
     * @param memoryInMb The value for memoryInMb (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder memoryInMb(@Nullable Integer memoryInMb) {
      this.memoryInMb = memoryInMb;
      return this;
    }

    /**
     * Initializes the value for the {@link ScaleApplicationRequest#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ScaleApplicationRequest ScaleApplicationRequest}.
     * @return An immutable instance of ScaleApplicationRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ScaleApplicationRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ScaleApplicationRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ScaleApplicationRequest, some of required attributes are not set " + attributes;
    }
  }
}
