package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _UpdateApplicationEnvironmentVariablesRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UpdateApplicationEnvironmentVariablesRequest.builder()}.
 */
@Generated(from = "_UpdateApplicationEnvironmentVariablesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateApplicationEnvironmentVariablesRequest
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationEnvironmentVariablesRequest {
  private final String applicationId;
  private final Map<String, String> vars;

  private UpdateApplicationEnvironmentVariablesRequest(UpdateApplicationEnvironmentVariablesRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.vars = createUnmodifiableMap(false, false, builder.vars);
  }

  /**
   * The application id
   */
  @JsonProperty("applicationId")
  @JsonIgnore
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The application's environment variables
   */
  @JsonProperty("var")
  @Override
  public Map<String, String> getVars() {
    return vars;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationEnvironmentVariablesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationEnvironmentVariablesRequest
        && equalTo((UpdateApplicationEnvironmentVariablesRequest) another);
  }

  private boolean equalTo(UpdateApplicationEnvironmentVariablesRequest another) {
    return applicationId.equals(another.applicationId)
        && vars.equals(another.vars);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code vars}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + vars.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationEnvironmentVariablesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationEnvironmentVariablesRequest{"
        + "applicationId=" + applicationId
        + ", vars=" + vars
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateApplicationEnvironmentVariablesRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.applications._UpdateApplicationEnvironmentVariablesRequest {
    String applicationId;
    Map<String, String> vars = Collections.emptyMap();
    @JsonProperty("applicationId")
    @JsonIgnore
    public void setApplicationId(String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("var")
    public void setVars(Map<String, String> vars) {
      this.vars = vars;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getVars() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateApplicationEnvironmentVariablesRequest fromJson(Json json) {
    UpdateApplicationEnvironmentVariablesRequest.Builder builder = UpdateApplicationEnvironmentVariablesRequest.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.vars != null) {
      builder.putAllVars(json.vars);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateApplicationEnvironmentVariablesRequest UpdateApplicationEnvironmentVariablesRequest}.
   * <pre>
   * UpdateApplicationEnvironmentVariablesRequest.builder()
   *    .applicationId(String) // required {@link UpdateApplicationEnvironmentVariablesRequest#getApplicationId() applicationId}
   *    .var|putAllVars(String => String) // {@link UpdateApplicationEnvironmentVariablesRequest#getVars() vars} mappings
   *    .build();
   * </pre>
   * @return A new UpdateApplicationEnvironmentVariablesRequest builder
   */
  public static UpdateApplicationEnvironmentVariablesRequest.Builder builder() {
    return new UpdateApplicationEnvironmentVariablesRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationEnvironmentVariablesRequest UpdateApplicationEnvironmentVariablesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateApplicationEnvironmentVariablesRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private long initBits = 0x1L;

    private String applicationId;
    private Map<String, String> vars = new LinkedHashMap<String, String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationEnvironmentVariablesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationEnvironmentVariablesRequest instance) {
      return from((_UpdateApplicationEnvironmentVariablesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationEnvironmentVariablesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateApplicationEnvironmentVariablesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      putAllVars(instance.getVars());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationEnvironmentVariablesRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Put one entry to the {@link UpdateApplicationEnvironmentVariablesRequest#getVars() vars} map.
     * @param key The key in the vars map
     * @param value The associated value in the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder var(String key, String value) {
      this.vars.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link UpdateApplicationEnvironmentVariablesRequest#getVars() vars} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder var(Map.Entry<String, ? extends String> entry) {
      String k = entry.getKey();
      String v = entry.getValue();
      this.vars.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link UpdateApplicationEnvironmentVariablesRequest#getVars() vars} map. Nulls are not permitted
     * @param entries The entries that will be added to the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder vars(Map<String, ? extends String> entries) {
      this.vars.clear();
      return putAllVars(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link UpdateApplicationEnvironmentVariablesRequest#getVars() vars} map. Nulls are not permitted
     * @param entries The entries that will be added to the vars map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllVars(Map<String, ? extends String> entries) {
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.vars.put(k, v);
      }
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationEnvironmentVariablesRequest UpdateApplicationEnvironmentVariablesRequest}.
     * @return An immutable instance of UpdateApplicationEnvironmentVariablesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationEnvironmentVariablesRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateApplicationEnvironmentVariablesRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      return "Cannot build UpdateApplicationEnvironmentVariablesRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
