package org.cloudfoundry.client.v3.builds;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.*;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Relationship;
import org.cloudfoundry.client.v3.Resource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Build operation
 */
@Generated(from = "_GetBuildResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetBuildResponse extends org.cloudfoundry.client.v3.builds._GetBuildResponse {
  private final CreatedBy createdBy;
  private final @Nullable Droplet droplet;
  private final @Nullable String error;
  private final Relationship inputPackage;
  private final Lifecycle lifecycle;
  private final BuildState state;
  private final String createdAt;
  private final String id;
  private final Map<String, Link> links;
  private final @Nullable String updatedAt;

  private GetBuildResponse(GetBuildResponse.Builder builder) {
    this.createdBy = builder.createdBy;
    this.droplet = builder.droplet;
    this.error = builder.error;
    this.inputPackage = builder.inputPackage;
    this.lifecycle = builder.lifecycle;
    this.state = builder.state;
    this.createdAt = builder.createdAt;
    this.id = builder.id;
    this.links = createUnmodifiableMap(false, false, builder.links);
    this.updatedAt = builder.updatedAt;
  }

  /**
   * The user that created the build
   */
  @JsonProperty("created_by")
  @Override
  public CreatedBy getCreatedBy() {
    return createdBy;
  }

  /**
   * A resulting droplet from the staging process
   */
  @JsonProperty("droplet")
  @Override
  public @Nullable Droplet getDroplet() {
    return droplet;
  }

  /**
   * Describes errors during the build process
   */
  @JsonProperty("error")
  @Override
  public @Nullable String getError() {
    return error;
  }

  /**
   * The package that is the input to the staging process
   */
  @JsonProperty("package")
  @Override
  public Relationship getInputPackage() {
    return inputPackage;
  }

  /**
   * The lifecycle that was configured or discovered from the application
   */
  @JsonProperty("lifecycle")
  @Override
  public Lifecycle getLifecycle() {
    return lifecycle;
  }

  /**
   * State of the build
   */
  @JsonProperty("state")
  @Override
  public BuildState getState() {
    return state;
  }

  /**
   * When the resource was created
   */
  @JsonProperty("created_at")
  @Override
  public String getCreatedAt() {
    return createdAt;
  }

  /**
   * The resource's id
   */
  @JsonProperty("guid")
  @Override
  public String getId() {
    return id;
  }

  /**
   * Links to related resources and actions for the resource
   */
  @JsonProperty("links")
  @Override
  public Map<String, Link> getLinks() {
    return links;
  }

  /**
   * When the resource was last updated
   */
  @JsonProperty("updated_at")
  @Override
  public @Nullable String getUpdatedAt() {
    return updatedAt;
  }

  /**
   * This instance is equal to all instances of {@code GetBuildResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetBuildResponse
        && equalTo((GetBuildResponse) another);
  }

  private boolean equalTo(GetBuildResponse another) {
    return createdBy.equals(another.createdBy)
        && Objects.equals(droplet, another.droplet)
        && Objects.equals(error, another.error)
        && inputPackage.equals(another.inputPackage)
        && lifecycle.equals(another.lifecycle)
        && state.equals(another.state)
        && createdAt.equals(another.createdAt)
        && id.equals(another.id)
        && links.equals(another.links)
        && Objects.equals(updatedAt, another.updatedAt);
  }

  /**
   * Computes a hash code from attributes: {@code createdBy}, {@code droplet}, {@code error}, {@code inputPackage}, {@code lifecycle}, {@code state}, {@code createdAt}, {@code id}, {@code links}, {@code updatedAt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + createdBy.hashCode();
    h += (h << 5) + Objects.hashCode(droplet);
    h += (h << 5) + Objects.hashCode(error);
    h += (h << 5) + inputPackage.hashCode();
    h += (h << 5) + lifecycle.hashCode();
    h += (h << 5) + state.hashCode();
    h += (h << 5) + createdAt.hashCode();
    h += (h << 5) + id.hashCode();
    h += (h << 5) + links.hashCode();
    h += (h << 5) + Objects.hashCode(updatedAt);
    return h;
  }

  /**
   * Prints the immutable value {@code GetBuildResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetBuildResponse{"
        + "createdBy=" + createdBy
        + ", droplet=" + droplet
        + ", error=" + error
        + ", inputPackage=" + inputPackage
        + ", lifecycle=" + lifecycle
        + ", state=" + state
        + ", createdAt=" + createdAt
        + ", id=" + id
        + ", links=" + links
        + ", updatedAt=" + updatedAt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetBuildResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.builds._GetBuildResponse {
    CreatedBy createdBy;
    Droplet droplet;
    String error;
    Relationship inputPackage;
    Lifecycle lifecycle;
    BuildState state;
    String createdAt;
    String id;
    Map<String, Link> links = Collections.emptyMap();
    String updatedAt;
    @JsonProperty("created_by")
    public void setCreatedBy(CreatedBy createdBy) {
      this.createdBy = createdBy;
    }
    @JsonProperty("droplet")
    public void setDroplet(@Nullable Droplet droplet) {
      this.droplet = droplet;
    }
    @JsonProperty("error")
    public void setError(@Nullable String error) {
      this.error = error;
    }
    @JsonProperty("package")
    public void setInputPackage(Relationship inputPackage) {
      this.inputPackage = inputPackage;
    }
    @JsonProperty("lifecycle")
    public void setLifecycle(Lifecycle lifecycle) {
      this.lifecycle = lifecycle;
    }
    @JsonProperty("state")
    public void setState(BuildState state) {
      this.state = state;
    }
    @JsonProperty("created_at")
    public void setCreatedAt(String createdAt) {
      this.createdAt = createdAt;
    }
    @JsonProperty("guid")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("links")
    public void setLinks(Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("updated_at")
    public void setUpdatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
    }
    @Override
    public CreatedBy getCreatedBy() { throw new UnsupportedOperationException(); }
    @Override
    public Droplet getDroplet() { throw new UnsupportedOperationException(); }
    @Override
    public String getError() { throw new UnsupportedOperationException(); }
    @Override
    public Relationship getInputPackage() { throw new UnsupportedOperationException(); }
    @Override
    public Lifecycle getLifecycle() { throw new UnsupportedOperationException(); }
    @Override
    public BuildState getState() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedAt() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getUpdatedAt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetBuildResponse fromJson(Json json) {
    GetBuildResponse.Builder builder = GetBuildResponse.builder();
    if (json.createdBy != null) {
      builder.createdBy(json.createdBy);
    }
    if (json.droplet != null) {
      builder.droplet(json.droplet);
    }
    if (json.error != null) {
      builder.error(json.error);
    }
    if (json.inputPackage != null) {
      builder.inputPackage(json.inputPackage);
    }
    if (json.lifecycle != null) {
      builder.lifecycle(json.lifecycle);
    }
    if (json.state != null) {
      builder.state(json.state);
    }
    if (json.createdAt != null) {
      builder.createdAt(json.createdAt);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.updatedAt != null) {
      builder.updatedAt(json.updatedAt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetBuildResponse GetBuildResponse}.
   * <pre>
   * GetBuildResponse.builder()
   *    .createdBy(org.cloudfoundry.client.v3.builds.CreatedBy) // required {@link GetBuildResponse#getCreatedBy() createdBy}
   *    .droplet(org.cloudfoundry.client.v3.builds.Droplet | null) // nullable {@link GetBuildResponse#getDroplet() droplet}
   *    .error(String | null) // nullable {@link GetBuildResponse#getError() error}
   *    .inputPackage(org.cloudfoundry.client.v3.Relationship) // required {@link GetBuildResponse#getInputPackage() inputPackage}
   *    .lifecycle(org.cloudfoundry.client.v3.Lifecycle) // required {@link GetBuildResponse#getLifecycle() lifecycle}
   *    .state(org.cloudfoundry.client.v3.builds.BuildState) // required {@link GetBuildResponse#getState() state}
   *    .createdAt(String) // required {@link GetBuildResponse#getCreatedAt() createdAt}
   *    .id(String) // required {@link GetBuildResponse#getId() id}
   *    .link|putAllLinks(String => Link) // {@link GetBuildResponse#getLinks() links} mappings
   *    .updatedAt(String | null) // nullable {@link GetBuildResponse#getUpdatedAt() updatedAt}
   *    .build();
   * </pre>
   * @return A new GetBuildResponse builder
   */
  public static GetBuildResponse.Builder builder() {
    return new GetBuildResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetBuildResponse GetBuildResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetBuildResponse", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CREATED_BY = 0x1L;
    private static final long INIT_BIT_INPUT_PACKAGE = 0x2L;
    private static final long INIT_BIT_LIFECYCLE = 0x4L;
    private static final long INIT_BIT_STATE = 0x8L;
    private static final long INIT_BIT_CREATED_AT = 0x10L;
    private static final long INIT_BIT_ID = 0x20L;
    private long initBits = 0x3fL;

    private CreatedBy createdBy;
    private Droplet droplet;
    private String error;
    private Relationship inputPackage;
    private Lifecycle lifecycle;
    private BuildState state;
    private String createdAt;
    private String id;
    private Map<String, Link> links = new LinkedHashMap<String, Link>();
    private String updatedAt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.builds.Build} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Build instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.Resource} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Resource instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetBuildResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetBuildResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _GetBuildResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_GetBuildResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof Build) {
        Build instance = (Build) object;
        lifecycle(instance.getLifecycle());
        inputPackage(instance.getInputPackage());
        state(instance.getState());
        Droplet dropletValue = instance.getDroplet();
        if (dropletValue != null) {
          droplet(dropletValue);
        }
        String errorValue = instance.getError();
        if (errorValue != null) {
          error(errorValue);
        }
        createdBy(instance.getCreatedBy());
      }
      if (object instanceof Resource) {
        Resource instance = (Resource) object;
        createdAt(instance.getCreatedAt());
        putAllLinks(instance.getLinks());
        id(instance.getId());
        String updatedAtValue = instance.getUpdatedAt();
        if (updatedAtValue != null) {
          updatedAt(updatedAtValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getCreatedBy() createdBy} attribute.
     * @param createdBy The value for createdBy 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_by")
    public final Builder createdBy(CreatedBy createdBy) {
      this.createdBy = Objects.requireNonNull(createdBy, "createdBy");
      initBits &= ~INIT_BIT_CREATED_BY;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getDroplet() droplet} attribute.
     * @param droplet The value for droplet (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("droplet")
    public final Builder droplet(@Nullable Droplet droplet) {
      this.droplet = droplet;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getError() error} attribute.
     * @param error The value for error (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("error")
    public final Builder error(@Nullable String error) {
      this.error = error;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getInputPackage() inputPackage} attribute.
     * @param inputPackage The value for inputPackage 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("package")
    public final Builder inputPackage(Relationship inputPackage) {
      this.inputPackage = Objects.requireNonNull(inputPackage, "inputPackage");
      initBits &= ~INIT_BIT_INPUT_PACKAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getLifecycle() lifecycle} attribute.
     * @param lifecycle The value for lifecycle 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lifecycle")
    public final Builder lifecycle(Lifecycle lifecycle) {
      this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle");
      initBits &= ~INIT_BIT_LIFECYCLE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getState() state} attribute.
     * @param state The value for state 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("state")
    public final Builder state(BuildState state) {
      this.state = Objects.requireNonNull(state, "state");
      initBits &= ~INIT_BIT_STATE;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getCreatedAt() createdAt} attribute.
     * @param createdAt The value for createdAt 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created_at")
    public final Builder createdAt(String createdAt) {
      this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
      initBits &= ~INIT_BIT_CREATED_AT;
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("guid")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Put one entry to the {@link GetBuildResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetBuildResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetBuildResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(Map<String, ? extends Link> entries) {
      this.links.clear();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetBuildResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetBuildResponse#getUpdatedAt() updatedAt} attribute.
     * @param updatedAt The value for updatedAt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("updated_at")
    public final Builder updatedAt(@Nullable String updatedAt) {
      this.updatedAt = updatedAt;
      return this;
    }

    /**
     * Builds a new {@link GetBuildResponse GetBuildResponse}.
     * @return An immutable instance of GetBuildResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetBuildResponse build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new GetBuildResponse(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CREATED_BY) != 0) attributes.add("createdBy");
      if ((initBits & INIT_BIT_INPUT_PACKAGE) != 0) attributes.add("inputPackage");
      if ((initBits & INIT_BIT_LIFECYCLE) != 0) attributes.add("lifecycle");
      if ((initBits & INIT_BIT_STATE) != 0) attributes.add("state");
      if ((initBits & INIT_BIT_CREATED_AT) != 0) attributes.add("createdAt");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build GetBuildResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
