package org.cloudfoundry.client.v3.droplets;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The relationships for the Copy Droplet request
 */
@Generated(from = "_DropletRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class DropletRelationships extends org.cloudfoundry.client.v3.droplets._DropletRelationships {
  private final ToOneRelationship application;

  private DropletRelationships(DropletRelationships.Builder builder) {
    this.application = builder.application;
  }

  /**
   * The space relationship
   */
  @Override
  public ToOneRelationship getApplication() {
    return application;
  }

  /**
   * This instance is equal to all instances of {@code DropletRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof DropletRelationships
        && equalTo((DropletRelationships) another);
  }

  private boolean equalTo(DropletRelationships another) {
    return application.equals(another.application);
  }

  /**
   * Computes a hash code from attributes: {@code application}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + application.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code DropletRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "DropletRelationships{"
        + "application=" + application
        + "}";
  }

  /**
   * Creates a builder for {@link DropletRelationships DropletRelationships}.
   * <pre>
   * DropletRelationships.builder()
   *    .application(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link DropletRelationships#getApplication() application}
   *    .build();
   * </pre>
   * @return A new DropletRelationships builder
   */
  public static DropletRelationships.Builder builder() {
    return new DropletRelationships.Builder();
  }

  /**
   * Builds instances of type {@link DropletRelationships DropletRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_DropletRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship application;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code DropletRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(DropletRelationships instance) {
      return from((_DropletRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _DropletRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_DropletRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      application(instance.getApplication());
      return this;
    }

    /**
     * Initializes the value for the {@link DropletRelationships#getApplication() application} attribute.
     * @param application The value for application 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder application(ToOneRelationship application) {
      this.application = Objects.requireNonNull(application, "application");
      initBits &= ~INIT_BIT_APPLICATION;
      return this;
    }

    /**
     * Builds a new {@link DropletRelationships DropletRelationships}.
     * @return An immutable instance of DropletRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public DropletRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new DropletRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION) != 0) attributes.add("application");
      return "Cannot build DropletRelationships, some of required attributes are not set " + attributes;
    }
  }
}
