package org.cloudfoundry.client.v3.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.PaginatedRequest;
import org.cloudfoundry.client.v3.droplets.DropletState;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link _ListPackageDropletsRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ListPackageDropletsRequest.builder()}.
 */
@Generated(from = "_ListPackageDropletsRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListPackageDropletsRequest
    extends org.cloudfoundry.client.v3.packages._ListPackageDropletsRequest {
  private final List<String> dropletIds;
  private final String packageId;
  private final List<DropletState> states;
  private final @Nullable String orderBy;
  private final @Nullable Integer page;
  private final @Nullable Integer perPage;

  private ListPackageDropletsRequest(ListPackageDropletsRequest.Builder builder) {
    this.dropletIds = createUnmodifiableList(true, builder.dropletIds);
    this.packageId = builder.packageId;
    this.states = createUnmodifiableList(true, builder.states);
    this.orderBy = builder.orderBy;
    this.page = builder.page;
    this.perPage = builder.perPage;
  }

  /**
   * The droplet ids to filter by
   */
  @Override
  public List<String> getDropletIds() {
    return dropletIds;
  }

  /**
   * The package id
   */
  @Override
  public String getPackageId() {
    return packageId;
  }

  /**
   * The droplet states to filter by
   */
  @Override
  public List<DropletState> getStates() {
    return states;
  }

  /**
   * The order by
   */
  @Override
  public @Nullable String getOrderBy() {
    return orderBy;
  }

  /**
   * The page
   */
  @Override
  public @Nullable Integer getPage() {
    return page;
  }

  /**
   * The results per page
   */
  @Override
  public @Nullable Integer getPerPage() {
    return perPage;
  }

  /**
   * This instance is equal to all instances of {@code ListPackageDropletsRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListPackageDropletsRequest
        && equalTo((ListPackageDropletsRequest) another);
  }

  private boolean equalTo(ListPackageDropletsRequest another) {
    return dropletIds.equals(another.dropletIds)
        && packageId.equals(another.packageId)
        && states.equals(another.states)
        && Objects.equals(orderBy, another.orderBy)
        && Objects.equals(page, another.page)
        && Objects.equals(perPage, another.perPage);
  }

  /**
   * Computes a hash code from attributes: {@code dropletIds}, {@code packageId}, {@code states}, {@code orderBy}, {@code page}, {@code perPage}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + dropletIds.hashCode();
    h += (h << 5) + packageId.hashCode();
    h += (h << 5) + states.hashCode();
    h += (h << 5) + Objects.hashCode(orderBy);
    h += (h << 5) + Objects.hashCode(page);
    h += (h << 5) + Objects.hashCode(perPage);
    return h;
  }

  /**
   * Prints the immutable value {@code ListPackageDropletsRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListPackageDropletsRequest{"
        + "dropletIds=" + dropletIds
        + ", packageId=" + packageId
        + ", states=" + states
        + ", orderBy=" + orderBy
        + ", page=" + page
        + ", perPage=" + perPage
        + "}";
  }

  /**
   * Creates a builder for {@link ListPackageDropletsRequest ListPackageDropletsRequest}.
   * <pre>
   * ListPackageDropletsRequest.builder()
   *    .dropletId|addAllDropletIds(String) // {@link ListPackageDropletsRequest#getDropletIds() dropletIds} elements
   *    .packageId(String) // required {@link ListPackageDropletsRequest#getPackageId() packageId}
   *    .state|addAllStates(org.cloudfoundry.client.v3.droplets.DropletState) // {@link ListPackageDropletsRequest#getStates() states} elements
   *    .orderBy(String | null) // nullable {@link ListPackageDropletsRequest#getOrderBy() orderBy}
   *    .page(Integer | null) // nullable {@link ListPackageDropletsRequest#getPage() page}
   *    .perPage(Integer | null) // nullable {@link ListPackageDropletsRequest#getPerPage() perPage}
   *    .build();
   * </pre>
   * @return A new ListPackageDropletsRequest builder
   */
  public static ListPackageDropletsRequest.Builder builder() {
    return new ListPackageDropletsRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListPackageDropletsRequest ListPackageDropletsRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListPackageDropletsRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_PACKAGE_ID = 0x1L;
    private long initBits = 0x1L;

    private List<String> dropletIds = new ArrayList<String>();
    private String packageId;
    private List<DropletState> states = new ArrayList<DropletState>();
    private String orderBy;
    private Integer page;
    private Integer perPage;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.client.v3.PaginatedRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PaginatedRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListPackageDropletsRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListPackageDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ListPackageDropletsRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ListPackageDropletsRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PaginatedRequest) {
        PaginatedRequest instance = (PaginatedRequest) object;
        String orderByValue = instance.getOrderBy();
        if (orderByValue != null) {
          orderBy(orderByValue);
        }
        Integer perPageValue = instance.getPerPage();
        if (perPageValue != null) {
          perPage(perPageValue);
        }
        Integer pageValue = instance.getPage();
        if (pageValue != null) {
          page(pageValue);
        }
      }
      if (object instanceof org.cloudfoundry.client.v3.packages._ListPackageDropletsRequest) {
        org.cloudfoundry.client.v3.packages._ListPackageDropletsRequest instance = (org.cloudfoundry.client.v3.packages._ListPackageDropletsRequest) object;
        packageId(instance.getPackageId());
        addAllDropletIds(instance.getDropletIds());
        addAllStates(instance.getStates());
      }
    }

    /**
     * Adds one element to {@link ListPackageDropletsRequest#getDropletIds() dropletIds} list.
     * @param element A dropletIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletId(String element) {
      this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackageDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An array of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletIds(String... elements) {
      for (String element : elements) {
        this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackageDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An iterable of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dropletIds(Iterable<String> elements) {
      this.dropletIds.clear();
      return addAllDropletIds(elements);
    }

    /**
     * Adds elements to {@link ListPackageDropletsRequest#getDropletIds() dropletIds} list.
     * @param elements An iterable of dropletIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllDropletIds(Iterable<String> elements) {
      for (String element : elements) {
        this.dropletIds.add(Objects.requireNonNull(element, "dropletIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackageDropletsRequest#getPackageId() packageId} attribute.
     * @param packageId The value for packageId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder packageId(String packageId) {
      this.packageId = Objects.requireNonNull(packageId, "packageId");
      initBits &= ~INIT_BIT_PACKAGE_ID;
      return this;
    }

    /**
     * Adds one element to {@link ListPackageDropletsRequest#getStates() states} list.
     * @param element A states element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder state(DropletState element) {
      this.states.add(Objects.requireNonNull(element, "states element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPackageDropletsRequest#getStates() states} list.
     * @param elements An array of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(DropletState... elements) {
      for (DropletState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPackageDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder states(Iterable<? extends DropletState> elements) {
      this.states.clear();
      return addAllStates(elements);
    }

    /**
     * Adds elements to {@link ListPackageDropletsRequest#getStates() states} list.
     * @param elements An iterable of states elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllStates(Iterable<? extends DropletState> elements) {
      for (DropletState element : elements) {
        this.states.add(Objects.requireNonNull(element, "states element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackageDropletsRequest#getOrderBy() orderBy} attribute.
     * @param orderBy The value for orderBy (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder orderBy(@Nullable String orderBy) {
      this.orderBy = orderBy;
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackageDropletsRequest#getPage() page} attribute.
     * @param page The value for page (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder page(@Nullable Integer page) {
      this.page = page;
      return this;
    }

    /**
     * Initializes the value for the {@link ListPackageDropletsRequest#getPerPage() perPage} attribute.
     * @param perPage The value for perPage (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder perPage(@Nullable Integer perPage) {
      this.perPage = perPage;
      return this;
    }

    /**
     * Builds a new {@link ListPackageDropletsRequest ListPackageDropletsRequest}.
     * @return An immutable instance of ListPackageDropletsRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListPackageDropletsRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ListPackageDropletsRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PACKAGE_ID) != 0) attributes.add("packageId");
      return "Cannot build ListPackageDropletsRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
