// Code generated by Wire protocol buffer compiler, do not edit.
// Source file: log.proto at 7:1
package org.cloudfoundry.dropsonde.events;

import com.squareup.wire.FieldEncoding;
import com.squareup.wire.Message;
import com.squareup.wire.ProtoAdapter;
import com.squareup.wire.ProtoReader;
import com.squareup.wire.ProtoWriter;
import com.squareup.wire.WireEnum;
import com.squareup.wire.WireField;
import com.squareup.wire.internal.Internal;
import java.io.IOException;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.StringBuilder;
import okio.ByteString;

/**
 * / A LogMessage contains a "log line" and associated metadata.
 */
public final class LogMessage extends Message<LogMessage, LogMessage.Builder> {
  public static final ProtoAdapter<LogMessage> ADAPTER = new ProtoAdapter_LogMessage();

  private static final long serialVersionUID = 0L;

  public static final ByteString DEFAULT_MESSAGE = ByteString.EMPTY;

  public static final MessageType DEFAULT_MESSAGE_TYPE = MessageType.OUT;

  public static final Long DEFAULT_TIMESTAMP = 0L;

  public static final String DEFAULT_APP_ID = "";

  public static final String DEFAULT_SOURCE_TYPE = "";

  public static final String DEFAULT_SOURCE_INSTANCE = "";

  /**
   * / Bytes of the log message. (Note that it is not required to be a single line.)
   */
  @WireField(
      tag = 1,
      adapter = "com.squareup.wire.ProtoAdapter#BYTES",
      label = WireField.Label.REQUIRED
  )
  public final ByteString message;

  /**
   * / Type of the message (OUT or ERR).
   */
  @WireField(
      tag = 2,
      adapter = "org.cloudfoundry.dropsonde.events.LogMessage$MessageType#ADAPTER",
      label = WireField.Label.REQUIRED
  )
  public final MessageType message_type;

  /**
   * / UNIX timestamp (in nanoseconds) when the log was written.
   */
  @WireField(
      tag = 3,
      adapter = "com.squareup.wire.ProtoAdapter#INT64",
      label = WireField.Label.REQUIRED
  )
  public final Long timestamp;

  /**
   * / Application that emitted the message (or to which the application is related).
   */
  @WireField(
      tag = 4,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String app_id;

  /**
   * / Source of the message. For Cloud Foundry, this can be "APP", "RTR", "DEA", "STG", etc.
   */
  @WireField(
      tag = 5,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String source_type;

  /**
   * / Instance that emitted the message.
   */
  @WireField(
      tag = 6,
      adapter = "com.squareup.wire.ProtoAdapter#STRING"
  )
  public final String source_instance;

  public LogMessage(ByteString message, MessageType message_type, Long timestamp, String app_id, String source_type, String source_instance) {
    this(message, message_type, timestamp, app_id, source_type, source_instance, ByteString.EMPTY);
  }

  public LogMessage(ByteString message, MessageType message_type, Long timestamp, String app_id, String source_type, String source_instance, ByteString unknownFields) {
    super(ADAPTER, unknownFields);
    this.message = message;
    this.message_type = message_type;
    this.timestamp = timestamp;
    this.app_id = app_id;
    this.source_type = source_type;
    this.source_instance = source_instance;
  }

  @Override
  public Builder newBuilder() {
    Builder builder = new Builder();
    builder.message = message;
    builder.message_type = message_type;
    builder.timestamp = timestamp;
    builder.app_id = app_id;
    builder.source_type = source_type;
    builder.source_instance = source_instance;
    builder.addUnknownFields(unknownFields());
    return builder;
  }

  @Override
  public boolean equals(Object other) {
    if (other == this) return true;
    if (!(other instanceof LogMessage)) return false;
    LogMessage o = (LogMessage) other;
    return unknownFields().equals(o.unknownFields())
        && message.equals(o.message)
        && message_type.equals(o.message_type)
        && timestamp.equals(o.timestamp)
        && Internal.equals(app_id, o.app_id)
        && Internal.equals(source_type, o.source_type)
        && Internal.equals(source_instance, o.source_instance);
  }

  @Override
  public int hashCode() {
    int result = super.hashCode;
    if (result == 0) {
      result = unknownFields().hashCode();
      result = result * 37 + message.hashCode();
      result = result * 37 + message_type.hashCode();
      result = result * 37 + timestamp.hashCode();
      result = result * 37 + (app_id != null ? app_id.hashCode() : 0);
      result = result * 37 + (source_type != null ? source_type.hashCode() : 0);
      result = result * 37 + (source_instance != null ? source_instance.hashCode() : 0);
      super.hashCode = result;
    }
    return result;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(", message=").append(message);
    builder.append(", message_type=").append(message_type);
    builder.append(", timestamp=").append(timestamp);
    if (app_id != null) builder.append(", app_id=").append(app_id);
    if (source_type != null) builder.append(", source_type=").append(source_type);
    if (source_instance != null) builder.append(", source_instance=").append(source_instance);
    return builder.replace(0, 2, "LogMessage{").append('}').toString();
  }

  public static final class Builder extends Message.Builder<LogMessage, Builder> {
    public ByteString message;

    public MessageType message_type;

    public Long timestamp;

    public String app_id;

    public String source_type;

    public String source_instance;

    public Builder() {
    }

    /**
     * / Bytes of the log message. (Note that it is not required to be a single line.)
     */
    public Builder message(ByteString message) {
      this.message = message;
      return this;
    }

    /**
     * / Type of the message (OUT or ERR).
     */
    public Builder message_type(MessageType message_type) {
      this.message_type = message_type;
      return this;
    }

    /**
     * / UNIX timestamp (in nanoseconds) when the log was written.
     */
    public Builder timestamp(Long timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * / Application that emitted the message (or to which the application is related).
     */
    public Builder app_id(String app_id) {
      this.app_id = app_id;
      return this;
    }

    /**
     * / Source of the message. For Cloud Foundry, this can be "APP", "RTR", "DEA", "STG", etc.
     */
    public Builder source_type(String source_type) {
      this.source_type = source_type;
      return this;
    }

    /**
     * / Instance that emitted the message.
     */
    public Builder source_instance(String source_instance) {
      this.source_instance = source_instance;
      return this;
    }

    @Override
    public LogMessage build() {
      if (message == null
          || message_type == null
          || timestamp == null) {
        throw Internal.missingRequiredFields(message, "message",
            message_type, "message_type",
            timestamp, "timestamp");
      }
      return new LogMessage(message, message_type, timestamp, app_id, source_type, source_instance, super.buildUnknownFields());
    }
  }

  /**
   * / MessageType stores the destination of the message (corresponding to STDOUT or STDERR).
   */
  public enum MessageType implements WireEnum {
    OUT(1),

    ERR(2);

    public static final ProtoAdapter<MessageType> ADAPTER = ProtoAdapter.newEnumAdapter(MessageType.class);

    private final int value;

    MessageType(int value) {
      this.value = value;
    }

    /**
     * Return the constant for {@code value} or null.
     */
    public static MessageType fromValue(int value) {
      switch (value) {
        case 1: return OUT;
        case 2: return ERR;
        default: return null;
      }
    }

    @Override
    public int getValue() {
      return value;
    }
  }

  private static final class ProtoAdapter_LogMessage extends ProtoAdapter<LogMessage> {
    ProtoAdapter_LogMessage() {
      super(FieldEncoding.LENGTH_DELIMITED, LogMessage.class);
    }

    @Override
    public int encodedSize(LogMessage value) {
      return ProtoAdapter.BYTES.encodedSizeWithTag(1, value.message)
          + MessageType.ADAPTER.encodedSizeWithTag(2, value.message_type)
          + ProtoAdapter.INT64.encodedSizeWithTag(3, value.timestamp)
          + (value.app_id != null ? ProtoAdapter.STRING.encodedSizeWithTag(4, value.app_id) : 0)
          + (value.source_type != null ? ProtoAdapter.STRING.encodedSizeWithTag(5, value.source_type) : 0)
          + (value.source_instance != null ? ProtoAdapter.STRING.encodedSizeWithTag(6, value.source_instance) : 0)
          + value.unknownFields().size();
    }

    @Override
    public void encode(ProtoWriter writer, LogMessage value) throws IOException {
      ProtoAdapter.BYTES.encodeWithTag(writer, 1, value.message);
      MessageType.ADAPTER.encodeWithTag(writer, 2, value.message_type);
      ProtoAdapter.INT64.encodeWithTag(writer, 3, value.timestamp);
      if (value.app_id != null) ProtoAdapter.STRING.encodeWithTag(writer, 4, value.app_id);
      if (value.source_type != null) ProtoAdapter.STRING.encodeWithTag(writer, 5, value.source_type);
      if (value.source_instance != null) ProtoAdapter.STRING.encodeWithTag(writer, 6, value.source_instance);
      writer.writeBytes(value.unknownFields());
    }

    @Override
    public LogMessage decode(ProtoReader reader) throws IOException {
      Builder builder = new Builder();
      long token = reader.beginMessage();
      for (int tag; (tag = reader.nextTag()) != -1;) {
        switch (tag) {
          case 1: builder.message(ProtoAdapter.BYTES.decode(reader)); break;
          case 2: {
            try {
              builder.message_type(MessageType.ADAPTER.decode(reader));
            } catch (ProtoAdapter.EnumConstantNotFoundException e) {
              builder.addUnknownField(tag, FieldEncoding.VARINT, (long) e.value);
            }
            break;
          }
          case 3: builder.timestamp(ProtoAdapter.INT64.decode(reader)); break;
          case 4: builder.app_id(ProtoAdapter.STRING.decode(reader)); break;
          case 5: builder.source_type(ProtoAdapter.STRING.decode(reader)); break;
          case 6: builder.source_instance(ProtoAdapter.STRING.decode(reader)); break;
          default: {
            FieldEncoding fieldEncoding = reader.peekFieldEncoding();
            Object value = fieldEncoding.rawProtoAdapter().decode(reader);
            builder.addUnknownField(tag, fieldEncoding, value);
          }
        }
      }
      reader.endMessage(token);
      return builder.build();
    }

    @Override
    public LogMessage redact(LogMessage value) {
      Builder builder = value.newBuilder();
      builder.clearUnknownFields();
      return builder.build();
    }
  }
}
