package org.cloudfoundry.networking.v1.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The request payload for the List Policies operation
 */
@Generated(from = "_ListPoliciesRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ListPoliciesRequest extends org.cloudfoundry.networking.v1.policies._ListPoliciesRequest {
  private final @Nullable List<String> policyGroupIds;

  private ListPoliciesRequest(ListPoliciesRequest.Builder builder) {
    this.policyGroupIds = builder.policyGroupIds == null ? null : createUnmodifiableList(true, builder.policyGroupIds);
  }

  /**
   * Policy group ids to filter on
   */
  @Override
  public @Nullable List<String> getPolicyGroupIds() {
    return policyGroupIds;
  }

  /**
   * This instance is equal to all instances of {@code ListPoliciesRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ListPoliciesRequest
        && equalTo((ListPoliciesRequest) another);
  }

  private boolean equalTo(ListPoliciesRequest another) {
    return Objects.equals(policyGroupIds, another.policyGroupIds);
  }

  /**
   * Computes a hash code from attributes: {@code policyGroupIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(policyGroupIds);
    return h;
  }

  /**
   * Prints the immutable value {@code ListPoliciesRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ListPoliciesRequest{"
        + "policyGroupIds=" + policyGroupIds
        + "}";
  }

  /**
   * Creates a builder for {@link ListPoliciesRequest ListPoliciesRequest}.
   * <pre>
   * ListPoliciesRequest.builder()
   *    .policyGroupIds(List&lt;String&gt; | null) // nullable {@link ListPoliciesRequest#getPolicyGroupIds() policyGroupIds}
   *    .build();
   * </pre>
   * @return A new ListPoliciesRequest builder
   */
  public static ListPoliciesRequest.Builder builder() {
    return new ListPoliciesRequest.Builder();
  }

  /**
   * Builds instances of type {@link ListPoliciesRequest ListPoliciesRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ListPoliciesRequest", generator = "Immutables")
  public static final class Builder {
    private List<String> policyGroupIds = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ListPoliciesRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ListPoliciesRequest instance) {
      return from((_ListPoliciesRequest) instance);
    }

    /**
     * Copy abstract value type {@code _ListPoliciesRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ListPoliciesRequest instance) {
      Objects.requireNonNull(instance, "instance");
      List<String> policyGroupIdsValue = instance.getPolicyGroupIds();
      if (policyGroupIdsValue != null) {
        addAllPolicyGroupIds(policyGroupIdsValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link ListPoliciesRequest#getPolicyGroupIds() policyGroupIds} list.
     * @param element A policyGroupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policyGroupId(String element) {
      if (this.policyGroupIds == null) {
        this.policyGroupIds = new ArrayList<String>();
      }
      this.policyGroupIds.add(Objects.requireNonNull(element, "policyGroupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ListPoliciesRequest#getPolicyGroupIds() policyGroupIds} list.
     * @param elements An array of policyGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policyGroupIds(String... elements) {
      if (this.policyGroupIds == null) {
        this.policyGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.policyGroupIds.add(Objects.requireNonNull(element, "policyGroupIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ListPoliciesRequest#getPolicyGroupIds() policyGroupIds} list.
     * @param elements An iterable of policyGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder policyGroupIds(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.policyGroupIds = null;
        return this;
      }
      this.policyGroupIds = new ArrayList<String>();
      return addAllPolicyGroupIds(elements);
    }

    /**
     * Adds elements to {@link ListPoliciesRequest#getPolicyGroupIds() policyGroupIds} list.
     * @param elements An iterable of policyGroupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllPolicyGroupIds(Iterable<String> elements) {
      Objects.requireNonNull(elements, "policyGroupIds element");
      if (this.policyGroupIds == null) {
        this.policyGroupIds = new ArrayList<String>();
      }
      for (String element : elements) {
        this.policyGroupIds.add(Objects.requireNonNull(element, "policyGroupIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ListPoliciesRequest ListPoliciesRequest}.
     * @return An immutable instance of ListPoliciesRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ListPoliciesRequest build() {
      return new ListPoliciesRequest(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
