package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.tokens.GrantType;
import org.immutables.value.Generated;

/**
 * The resource in the list clients response
 */
@Generated(from = "_ActionClient", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ActionClient extends org.cloudfoundry.uaa.clients._ActionClient {
  private final @Nullable Long accessTokenValidity;
  private final @Nullable String action;
  private final @Nullable List<String> allowedProviders;
  private final @Nullable Boolean approvalsDeleted;
  private final List<String> authorities;
  private final List<GrantType> authorizedGrantTypes;
  private final List<String> autoApproves;
  private final String clientId;
  private final @Nullable String createdWith;
  private final @Nullable Long lastModified;
  private final @Nullable String name;
  private final @Nullable List<String> redirectUriPatterns;
  private final @Nullable Long refreshTokenValidity;
  private final @Nullable List<String> requiredUserGroups;
  private final List<String> resourceIds;
  private final List<String> scopes;
  private final @Nullable String tokenSalt;

  private ActionClient(ActionClient.Builder builder) {
    this.accessTokenValidity = builder.accessTokenValidity;
    this.action = builder.action;
    this.allowedProviders = builder.allowedProviders == null ? null : createUnmodifiableList(true, builder.allowedProviders);
    this.approvalsDeleted = builder.approvalsDeleted;
    this.authorities = createUnmodifiableList(true, builder.authorities);
    this.authorizedGrantTypes = createUnmodifiableList(true, builder.authorizedGrantTypes);
    this.autoApproves = createUnmodifiableList(true, builder.autoApproves);
    this.clientId = builder.clientId;
    this.createdWith = builder.createdWith;
    this.lastModified = builder.lastModified;
    this.name = builder.name;
    this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : createUnmodifiableList(true, builder.redirectUriPatterns);
    this.refreshTokenValidity = builder.refreshTokenValidity;
    this.requiredUserGroups = builder.requiredUserGroups == null ? null : createUnmodifiableList(true, builder.requiredUserGroups);
    this.resourceIds = createUnmodifiableList(true, builder.resourceIds);
    this.scopes = createUnmodifiableList(true, builder.scopes);
    this.tokenSalt = builder.tokenSalt;
  }

  /**
   * The access token validity
   */
  @JsonProperty("access_token_validity")
  @Override
  public @Nullable Long getAccessTokenValidity() {
    return accessTokenValidity;
  }

  /**
   * The action
   */
  @JsonProperty("action")
  @Override
  public @Nullable String getAction() {
    return action;
  }

  /**
   * A list of origin keys (alias) for identity providers the client is limited to. Null implies any identity provider is allowed.
   */
  @JsonProperty("allowedproviders")
  @Override
  public @Nullable List<String> getAllowedProviders() {
    return allowedProviders;
  }

  /**
   * Were the approvals deleted for the client, and an audit event sent
   */
  @JsonProperty("approvals_deleted")
  @Override
  public @Nullable Boolean getApprovalsDeleted() {
    return approvalsDeleted;
  }

  /**
   * Scopes that the client is able to grant when creating a client
   */
  @JsonProperty("authorities")
  @Override
  public List<String> getAuthorities() {
    return authorities;
  }

  /**
   * List of grant types that can be used to obtain a token with this client. Can include authorization_code, password, implicit, and/or client_credentials.
   */
  @JsonProperty("authorized_grant_types")
  @Override
  public List<GrantType> getAuthorizedGrantTypes() {
    return authorizedGrantTypes;
  }

  /**
   * Scopes that do not require user approval
   */
  @JsonProperty("autoapprove")
  @Override
  public List<String> getAutoApproves() {
    return autoApproves;
  }

  /**
   * Client identifier, unique within identity zone
   */
  @JsonProperty("client_id")
  @Override
  public String getClientId() {
    return clientId;
  }

  /**
   * What scope the bearer token had when client was created
   */
  @JsonProperty("createdwith")
  @Override
  public @Nullable String getCreatedWith() {
    return createdWith;
  }

  /**
   * Epoch of the moment the client information was last altered
   */
  @JsonProperty("lastModified")
  @Override
  public @Nullable Long getLastModified() {
    return lastModified;
  }

  /**
   * A human readable name for the client
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * Allowed URI patterns for redirect during authorization
   */
  @JsonProperty("redirect_uri")
  @Override
  public @Nullable List<String> getRedirectUriPatterns() {
    return redirectUriPatterns;
  }

  /**
   * The refresh token validity
   */
  @JsonProperty("refresh_token_validity")
  @Override
  public @Nullable Long getRefreshTokenValidity() {
    return refreshTokenValidity;
  }

  /**
   * The required user groups
   */
  @JsonProperty("required_user_groups")
  @Override
  public @Nullable List<String> getRequiredUserGroups() {
    return requiredUserGroups;
  }

  /**
   * Resources the client is allowed access to
   */
  @JsonProperty("resource_ids")
  @Override
  public List<String> getResourceIds() {
    return resourceIds;
  }

  /**
   * Scopes allowed for the client
   */
  @JsonProperty("scope")
  @Override
  public List<String> getScopes() {
    return scopes;
  }

  /**
   * A random string used to generate the client’s revocation key. Change this value to revoke all active tokens for the client
   */
  @JsonProperty("token_salt")
  @Override
  public @Nullable String getTokenSalt() {
    return tokenSalt;
  }

  /**
   * This instance is equal to all instances of {@code ActionClient} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ActionClient
        && equalTo((ActionClient) another);
  }

  private boolean equalTo(ActionClient another) {
    return Objects.equals(accessTokenValidity, another.accessTokenValidity)
        && Objects.equals(action, another.action)
        && Objects.equals(allowedProviders, another.allowedProviders)
        && Objects.equals(approvalsDeleted, another.approvalsDeleted)
        && authorities.equals(another.authorities)
        && authorizedGrantTypes.equals(another.authorizedGrantTypes)
        && autoApproves.equals(another.autoApproves)
        && clientId.equals(another.clientId)
        && Objects.equals(createdWith, another.createdWith)
        && Objects.equals(lastModified, another.lastModified)
        && Objects.equals(name, another.name)
        && Objects.equals(redirectUriPatterns, another.redirectUriPatterns)
        && Objects.equals(refreshTokenValidity, another.refreshTokenValidity)
        && Objects.equals(requiredUserGroups, another.requiredUserGroups)
        && resourceIds.equals(another.resourceIds)
        && scopes.equals(another.scopes)
        && Objects.equals(tokenSalt, another.tokenSalt);
  }

  /**
   * Computes a hash code from attributes: {@code accessTokenValidity}, {@code action}, {@code allowedProviders}, {@code approvalsDeleted}, {@code authorities}, {@code authorizedGrantTypes}, {@code autoApproves}, {@code clientId}, {@code createdWith}, {@code lastModified}, {@code name}, {@code redirectUriPatterns}, {@code refreshTokenValidity}, {@code requiredUserGroups}, {@code resourceIds}, {@code scopes}, {@code tokenSalt}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(accessTokenValidity);
    h += (h << 5) + Objects.hashCode(action);
    h += (h << 5) + Objects.hashCode(allowedProviders);
    h += (h << 5) + Objects.hashCode(approvalsDeleted);
    h += (h << 5) + authorities.hashCode();
    h += (h << 5) + authorizedGrantTypes.hashCode();
    h += (h << 5) + autoApproves.hashCode();
    h += (h << 5) + clientId.hashCode();
    h += (h << 5) + Objects.hashCode(createdWith);
    h += (h << 5) + Objects.hashCode(lastModified);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(redirectUriPatterns);
    h += (h << 5) + Objects.hashCode(refreshTokenValidity);
    h += (h << 5) + Objects.hashCode(requiredUserGroups);
    h += (h << 5) + resourceIds.hashCode();
    h += (h << 5) + scopes.hashCode();
    h += (h << 5) + Objects.hashCode(tokenSalt);
    return h;
  }

  /**
   * Prints the immutable value {@code ActionClient} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ActionClient{"
        + "accessTokenValidity=" + accessTokenValidity
        + ", action=" + action
        + ", allowedProviders=" + allowedProviders
        + ", approvalsDeleted=" + approvalsDeleted
        + ", authorities=" + authorities
        + ", authorizedGrantTypes=" + authorizedGrantTypes
        + ", autoApproves=" + autoApproves
        + ", clientId=" + clientId
        + ", createdWith=" + createdWith
        + ", lastModified=" + lastModified
        + ", name=" + name
        + ", redirectUriPatterns=" + redirectUriPatterns
        + ", refreshTokenValidity=" + refreshTokenValidity
        + ", requiredUserGroups=" + requiredUserGroups
        + ", resourceIds=" + resourceIds
        + ", scopes=" + scopes
        + ", tokenSalt=" + tokenSalt
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ActionClient", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._ActionClient {
    Long accessTokenValidity;
    String action;
    List<String> allowedProviders = null;
    Boolean approvalsDeleted;
    List<String> authorities = Collections.emptyList();
    List<GrantType> authorizedGrantTypes = Collections.emptyList();
    List<String> autoApproves = Collections.emptyList();
    String clientId;
    String createdWith;
    Long lastModified;
    String name;
    List<String> redirectUriPatterns = null;
    Long refreshTokenValidity;
    List<String> requiredUserGroups = null;
    List<String> resourceIds = Collections.emptyList();
    List<String> scopes = Collections.emptyList();
    String tokenSalt;
    @JsonProperty("access_token_validity")
    public void setAccessTokenValidity(@Nullable Long accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
    }
    @JsonProperty("action")
    public void setAction(@Nullable String action) {
      this.action = action;
    }
    @JsonProperty("allowedproviders")
    public void setAllowedProviders(@Nullable List<String> allowedProviders) {
      this.allowedProviders = allowedProviders;
    }
    @JsonProperty("approvals_deleted")
    public void setApprovalsDeleted(@Nullable Boolean approvalsDeleted) {
      this.approvalsDeleted = approvalsDeleted;
    }
    @JsonProperty("authorities")
    public void setAuthorities(List<String> authorities) {
      this.authorities = authorities;
    }
    @JsonProperty("authorized_grant_types")
    public void setAuthorizedGrantTypes(List<GrantType> authorizedGrantTypes) {
      this.authorizedGrantTypes = authorizedGrantTypes;
    }
    @JsonProperty("autoapprove")
    public void setAutoApproves(List<String> autoApproves) {
      this.autoApproves = autoApproves;
    }
    @JsonProperty("client_id")
    public void setClientId(String clientId) {
      this.clientId = clientId;
    }
    @JsonProperty("createdwith")
    public void setCreatedWith(@Nullable String createdWith) {
      this.createdWith = createdWith;
    }
    @JsonProperty("lastModified")
    public void setLastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("redirect_uri")
    public void setRedirectUriPatterns(@Nullable List<String> redirectUriPatterns) {
      this.redirectUriPatterns = redirectUriPatterns;
    }
    @JsonProperty("refresh_token_validity")
    public void setRefreshTokenValidity(@Nullable Long refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
    }
    @JsonProperty("required_user_groups")
    public void setRequiredUserGroups(@Nullable List<String> requiredUserGroups) {
      this.requiredUserGroups = requiredUserGroups;
    }
    @JsonProperty("resource_ids")
    public void setResourceIds(List<String> resourceIds) {
      this.resourceIds = resourceIds;
    }
    @JsonProperty("scope")
    public void setScopes(List<String> scopes) {
      this.scopes = scopes;
    }
    @JsonProperty("token_salt")
    public void setTokenSalt(@Nullable String tokenSalt) {
      this.tokenSalt = tokenSalt;
    }
    @Override
    public Long getAccessTokenValidity() { throw new UnsupportedOperationException(); }
    @Override
    public String getAction() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAllowedProviders() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getApprovalsDeleted() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuthorities() { throw new UnsupportedOperationException(); }
    @Override
    public List<GrantType> getAuthorizedGrantTypes() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAutoApproves() { throw new UnsupportedOperationException(); }
    @Override
    public String getClientId() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatedWith() { throw new UnsupportedOperationException(); }
    @Override
    public Long getLastModified() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRedirectUriPatterns() { throw new UnsupportedOperationException(); }
    @Override
    public Long getRefreshTokenValidity() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getRequiredUserGroups() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getResourceIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getScopes() { throw new UnsupportedOperationException(); }
    @Override
    public String getTokenSalt() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ActionClient fromJson(Json json) {
    ActionClient.Builder builder = ActionClient.builder();
    if (json.accessTokenValidity != null) {
      builder.accessTokenValidity(json.accessTokenValidity);
    }
    if (json.action != null) {
      builder.action(json.action);
    }
    if (json.allowedProviders != null) {
      builder.addAllAllowedProviders(json.allowedProviders);
    }
    if (json.approvalsDeleted != null) {
      builder.approvalsDeleted(json.approvalsDeleted);
    }
    if (json.authorities != null) {
      builder.addAllAuthorities(json.authorities);
    }
    if (json.authorizedGrantTypes != null) {
      builder.addAllAuthorizedGrantTypes(json.authorizedGrantTypes);
    }
    if (json.autoApproves != null) {
      builder.addAllAutoApproves(json.autoApproves);
    }
    if (json.clientId != null) {
      builder.clientId(json.clientId);
    }
    if (json.createdWith != null) {
      builder.createdWith(json.createdWith);
    }
    if (json.lastModified != null) {
      builder.lastModified(json.lastModified);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.redirectUriPatterns != null) {
      builder.addAllRedirectUriPatterns(json.redirectUriPatterns);
    }
    if (json.refreshTokenValidity != null) {
      builder.refreshTokenValidity(json.refreshTokenValidity);
    }
    if (json.requiredUserGroups != null) {
      builder.addAllRequiredUserGroups(json.requiredUserGroups);
    }
    if (json.resourceIds != null) {
      builder.addAllResourceIds(json.resourceIds);
    }
    if (json.scopes != null) {
      builder.addAllScopes(json.scopes);
    }
    if (json.tokenSalt != null) {
      builder.tokenSalt(json.tokenSalt);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ActionClient ActionClient}.
   * <pre>
   * ActionClient.builder()
   *    .accessTokenValidity(Long | null) // nullable {@link ActionClient#getAccessTokenValidity() accessTokenValidity}
   *    .action(String | null) // nullable {@link ActionClient#getAction() action}
   *    .allowedProviders(List&lt;String&gt; | null) // nullable {@link ActionClient#getAllowedProviders() allowedProviders}
   *    .approvalsDeleted(Boolean | null) // nullable {@link ActionClient#getApprovalsDeleted() approvalsDeleted}
   *    .authority|addAllAuthorities(String) // {@link ActionClient#getAuthorities() authorities} elements
   *    .authorizedGrantType|addAllAuthorizedGrantTypes(org.cloudfoundry.uaa.tokens.GrantType) // {@link ActionClient#getAuthorizedGrantTypes() authorizedGrantTypes} elements
   *    .autoApprove|addAllAutoApproves(String) // {@link ActionClient#getAutoApproves() autoApproves} elements
   *    .clientId(String) // required {@link ActionClient#getClientId() clientId}
   *    .createdWith(String | null) // nullable {@link ActionClient#getCreatedWith() createdWith}
   *    .lastModified(Long | null) // nullable {@link ActionClient#getLastModified() lastModified}
   *    .name(String | null) // nullable {@link ActionClient#getName() name}
   *    .redirectUriPatterns(List&lt;String&gt; | null) // nullable {@link ActionClient#getRedirectUriPatterns() redirectUriPatterns}
   *    .refreshTokenValidity(Long | null) // nullable {@link ActionClient#getRefreshTokenValidity() refreshTokenValidity}
   *    .requiredUserGroups(List&lt;String&gt; | null) // nullable {@link ActionClient#getRequiredUserGroups() requiredUserGroups}
   *    .resourceId|addAllResourceIds(String) // {@link ActionClient#getResourceIds() resourceIds} elements
   *    .scope|addAllScopes(String) // {@link ActionClient#getScopes() scopes} elements
   *    .tokenSalt(String | null) // nullable {@link ActionClient#getTokenSalt() tokenSalt}
   *    .build();
   * </pre>
   * @return A new ActionClient builder
   */
  public static ActionClient.Builder builder() {
    return new ActionClient.Builder();
  }

  /**
   * Builds instances of type {@link ActionClient ActionClient}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ActionClient", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_CLIENT_ID = 0x1L;
    private long initBits = 0x1L;

    private Long accessTokenValidity;
    private String action;
    private List<String> allowedProviders = null;
    private Boolean approvalsDeleted;
    private List<String> authorities = new ArrayList<String>();
    private List<GrantType> authorizedGrantTypes = new ArrayList<GrantType>();
    private List<String> autoApproves = new ArrayList<String>();
    private String clientId;
    private String createdWith;
    private Long lastModified;
    private String name;
    private List<String> redirectUriPatterns = null;
    private Long refreshTokenValidity;
    private List<String> requiredUserGroups = null;
    private List<String> resourceIds = new ArrayList<String>();
    private List<String> scopes = new ArrayList<String>();
    private String tokenSalt;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.clients.AbstractClient} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code ActionClient} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ActionClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _ActionClient} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_ActionClient instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof AbstractClient) {
        AbstractClient instance = (AbstractClient) object;
        addAllAuthorizedGrantTypes(instance.getAuthorizedGrantTypes());
        String tokenSaltValue = instance.getTokenSalt();
        if (tokenSaltValue != null) {
          tokenSalt(tokenSaltValue);
        }
        clientId(instance.getClientId());
        String createdWithValue = instance.getCreatedWith();
        if (createdWithValue != null) {
          createdWith(createdWithValue);
        }
        List<String> redirectUriPatternsValue = instance.getRedirectUriPatterns();
        if (redirectUriPatternsValue != null) {
          addAllRedirectUriPatterns(redirectUriPatternsValue);
        }
        Long accessTokenValidityValue = instance.getAccessTokenValidity();
        if (accessTokenValidityValue != null) {
          accessTokenValidity(accessTokenValidityValue);
        }
        addAllAuthorities(instance.getAuthorities());
        Long refreshTokenValidityValue = instance.getRefreshTokenValidity();
        if (refreshTokenValidityValue != null) {
          refreshTokenValidity(refreshTokenValidityValue);
        }
        String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        String actionValue = instance.getAction();
        if (actionValue != null) {
          action(actionValue);
        }
        Boolean approvalsDeletedValue = instance.getApprovalsDeleted();
        if (approvalsDeletedValue != null) {
          approvalsDeleted(approvalsDeletedValue);
        }
        Long lastModifiedValue = instance.getLastModified();
        if (lastModifiedValue != null) {
          lastModified(lastModifiedValue);
        }
        addAllScopes(instance.getScopes());
        List<String> requiredUserGroupsValue = instance.getRequiredUserGroups();
        if (requiredUserGroupsValue != null) {
          addAllRequiredUserGroups(requiredUserGroupsValue);
        }
        addAllAutoApproves(instance.getAutoApproves());
        List<String> allowedProvidersValue = instance.getAllowedProviders();
        if (allowedProvidersValue != null) {
          addAllAllowedProviders(allowedProvidersValue);
        }
        addAllResourceIds(instance.getResourceIds());
      }
    }

    /**
     * Initializes the value for the {@link ActionClient#getAccessTokenValidity() accessTokenValidity} attribute.
     * @param accessTokenValidity The value for accessTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access_token_validity")
    public final Builder accessTokenValidity(@Nullable Long accessTokenValidity) {
      this.accessTokenValidity = accessTokenValidity;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getAction() action} attribute.
     * @param action The value for action (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("action")
    public final Builder action(@Nullable String action) {
      this.action = action;
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getAllowedProviders() allowedProviders} list.
     * @param element A allowedProviders element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProvider(String element) {
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getAllowedProviders() allowedProviders} list.
     * @param elements An array of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder allowedProviders(String... elements) {
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getAllowedProviders() allowedProviders} list.
     * @param elements An iterable of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("allowedproviders")
    public final Builder allowedProviders(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.allowedProviders = null;
        return this;
      }
      this.allowedProviders = new ArrayList<String>();
      return addAllAllowedProviders(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getAllowedProviders() allowedProviders} list.
     * @param elements An iterable of allowedProviders elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAllowedProviders(Iterable<String> elements) {
      Objects.requireNonNull(elements, "allowedProviders element");
      if (this.allowedProviders == null) {
        this.allowedProviders = new ArrayList<String>();
      }
      for (String element : elements) {
        this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getApprovalsDeleted() approvalsDeleted} attribute.
     * @param approvalsDeleted The value for approvalsDeleted (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("approvals_deleted")
    public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
      this.approvalsDeleted = approvalsDeleted;
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getAuthorities() authorities} list.
     * @param element A authorities element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authority(String element) {
      this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getAuthorities() authorities} list.
     * @param elements An array of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorities(String... elements) {
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authorities")
    public final Builder authorities(Iterable<String> elements) {
      this.authorities.clear();
      return addAllAuthorities(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getAuthorities() authorities} list.
     * @param elements An iterable of authorities elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorities(Iterable<String> elements) {
      for (String element : elements) {
        this.authorities.add(Objects.requireNonNull(element, "authorities element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param element A authorizedGrantTypes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantType(GrantType element) {
      this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An array of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder authorizedGrantTypes(GrantType... elements) {
      for (GrantType element : elements) {
        this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An iterable of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("authorized_grant_types")
    public final Builder authorizedGrantTypes(Iterable<? extends GrantType> elements) {
      this.authorizedGrantTypes.clear();
      return addAllAuthorizedGrantTypes(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getAuthorizedGrantTypes() authorizedGrantTypes} list.
     * @param elements An iterable of authorizedGrantTypes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
      for (GrantType element : elements) {
        this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getAutoApproves() autoApproves} list.
     * @param element A autoApproves element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApprove(String element) {
      this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getAutoApproves() autoApproves} list.
     * @param elements An array of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder autoApproves(String... elements) {
      for (String element : elements) {
        this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getAutoApproves() autoApproves} list.
     * @param elements An iterable of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("autoapprove")
    public final Builder autoApproves(Iterable<String> elements) {
      this.autoApproves.clear();
      return addAllAutoApproves(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getAutoApproves() autoApproves} list.
     * @param elements An iterable of autoApproves elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAutoApproves(Iterable<String> elements) {
      for (String element : elements) {
        this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getClientId() clientId} attribute.
     * @param clientId The value for clientId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("client_id")
    public final Builder clientId(String clientId) {
      this.clientId = Objects.requireNonNull(clientId, "clientId");
      initBits &= ~INIT_BIT_CLIENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getCreatedWith() createdWith} attribute.
     * @param createdWith The value for createdWith (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("createdwith")
    public final Builder createdWith(@Nullable String createdWith) {
      this.createdWith = createdWith;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getLastModified() lastModified} attribute.
     * @param lastModified The value for lastModified (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("lastModified")
    public final Builder lastModified(@Nullable Long lastModified) {
      this.lastModified = lastModified;
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param element A redirectUriPatterns element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPattern(String element) {
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An array of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder redirectUriPatterns(String... elements) {
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An iterable of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("redirect_uri")
    public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.redirectUriPatterns = null;
        return this;
      }
      this.redirectUriPatterns = new ArrayList<String>();
      return addAllRedirectUriPatterns(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getRedirectUriPatterns() redirectUriPatterns} list.
     * @param elements An iterable of redirectUriPatterns elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
      Objects.requireNonNull(elements, "redirectUriPatterns element");
      if (this.redirectUriPatterns == null) {
        this.redirectUriPatterns = new ArrayList<String>();
      }
      for (String element : elements) {
        this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getRefreshTokenValidity() refreshTokenValidity} attribute.
     * @param refreshTokenValidity The value for refreshTokenValidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("refresh_token_validity")
    public final Builder refreshTokenValidity(@Nullable Long refreshTokenValidity) {
      this.refreshTokenValidity = refreshTokenValidity;
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getRequiredUserGroups() requiredUserGroups} list.
     * @param element A requiredUserGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requiredUserGroup(String element) {
      if (this.requiredUserGroups == null) {
        this.requiredUserGroups = new ArrayList<String>();
      }
      this.requiredUserGroups.add(Objects.requireNonNull(element, "requiredUserGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getRequiredUserGroups() requiredUserGroups} list.
     * @param elements An array of requiredUserGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder requiredUserGroups(String... elements) {
      if (this.requiredUserGroups == null) {
        this.requiredUserGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.requiredUserGroups.add(Objects.requireNonNull(element, "requiredUserGroups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getRequiredUserGroups() requiredUserGroups} list.
     * @param elements An iterable of requiredUserGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("required_user_groups")
    public final Builder requiredUserGroups(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.requiredUserGroups = null;
        return this;
      }
      this.requiredUserGroups = new ArrayList<String>();
      return addAllRequiredUserGroups(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getRequiredUserGroups() requiredUserGroups} list.
     * @param elements An iterable of requiredUserGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllRequiredUserGroups(Iterable<String> elements) {
      Objects.requireNonNull(elements, "requiredUserGroups element");
      if (this.requiredUserGroups == null) {
        this.requiredUserGroups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.requiredUserGroups.add(Objects.requireNonNull(element, "requiredUserGroups element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getResourceIds() resourceIds} list.
     * @param element A resourceIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceId(String element) {
      this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getResourceIds() resourceIds} list.
     * @param elements An array of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resourceIds(String... elements) {
      for (String element : elements) {
        this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resource_ids")
    public final Builder resourceIds(Iterable<String> elements) {
      this.resourceIds.clear();
      return addAllResourceIds(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getResourceIds() resourceIds} list.
     * @param elements An iterable of resourceIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResourceIds(Iterable<String> elements) {
      for (String element : elements) {
        this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link ActionClient#getScopes() scopes} list.
     * @param element A scopes element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scope(String element) {
      this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      return this;
    }

    /**
     * Adds elements to {@link ActionClient#getScopes() scopes} list.
     * @param elements An array of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder scopes(String... elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link ActionClient#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("scope")
    public final Builder scopes(Iterable<String> elements) {
      this.scopes.clear();
      return addAllScopes(elements);
    }

    /**
     * Adds elements to {@link ActionClient#getScopes() scopes} list.
     * @param elements An iterable of scopes elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllScopes(Iterable<String> elements) {
      for (String element : elements) {
        this.scopes.add(Objects.requireNonNull(element, "scopes element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ActionClient#getTokenSalt() tokenSalt} attribute.
     * @param tokenSalt The value for tokenSalt (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token_salt")
    public final Builder tokenSalt(@Nullable String tokenSalt) {
      this.tokenSalt = tokenSalt;
      return this;
    }

    /**
     * Builds a new {@link ActionClient ActionClient}.
     * @return An immutable instance of ActionClient
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ActionClient build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ActionClient(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT_ID) != 0) attributes.add("clientId");
      return "Cannot build ActionClient, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
