package org.cloudfoundry.uaa.clients;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the Batch Create Clients operation
 */
@Generated(from = "_BatchChangeSecretRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class BatchChangeSecretRequest extends org.cloudfoundry.uaa.clients._BatchChangeSecretRequest {
  private final List<ChangeSecret> changeSecrets;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private BatchChangeSecretRequest(BatchChangeSecretRequest.Builder builder) {
    this.changeSecrets = createUnmodifiableList(true, builder.changeSecrets);
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * A list of secrets to change
   */
  @JsonProperty("changeSecrets")
  @JsonIgnore
  @Override
  public List<ChangeSecret> getChangeSecrets() {
    return changeSecrets;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code BatchChangeSecretRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof BatchChangeSecretRequest
        && equalTo((BatchChangeSecretRequest) another);
  }

  private boolean equalTo(BatchChangeSecretRequest another) {
    return changeSecrets.equals(another.changeSecrets)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code changeSecrets}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + changeSecrets.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchChangeSecretRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchChangeSecretRequest{"
        + "changeSecrets=" + changeSecrets
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_BatchChangeSecretRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.clients._BatchChangeSecretRequest {
    List<ChangeSecret> changeSecrets = Collections.emptyList();
    String identityZoneId;
    String identityZoneSubdomain;
    @JsonProperty("changeSecrets")
    @JsonIgnore
    public void setChangeSecrets(List<ChangeSecret> changeSecrets) {
      this.changeSecrets = changeSecrets;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @Override
    public List<ChangeSecret> getChangeSecrets() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static BatchChangeSecretRequest fromJson(Json json) {
    BatchChangeSecretRequest.Builder builder = BatchChangeSecretRequest.builder();
    if (json.changeSecrets != null) {
      builder.addAllChangeSecrets(json.changeSecrets);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    return builder.build();
  }

  private static BatchChangeSecretRequest validate(BatchChangeSecretRequest instance) {
    instance.checkClients();
    return instance;
  }

  /**
   * Creates a builder for {@link BatchChangeSecretRequest BatchChangeSecretRequest}.
   * <pre>
   * BatchChangeSecretRequest.builder()
   *    .changeSecret|addAllChangeSecrets(ChangeSecret) // {@link BatchChangeSecretRequest#getChangeSecrets() changeSecrets} elements
   *    .identityZoneId(String | null) // nullable {@link BatchChangeSecretRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link BatchChangeSecretRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .build();
   * </pre>
   * @return A new BatchChangeSecretRequest builder
   */
  public static BatchChangeSecretRequest.Builder builder() {
    return new BatchChangeSecretRequest.Builder();
  }

  /**
   * Builds instances of type {@link BatchChangeSecretRequest BatchChangeSecretRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_BatchChangeSecretRequest", generator = "Immutables")
  public static final class Builder {
    private List<ChangeSecret> changeSecrets = new ArrayList<ChangeSecret>();
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code BatchChangeSecretRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(BatchChangeSecretRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _BatchChangeSecretRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_BatchChangeSecretRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.clients._BatchChangeSecretRequest) {
        org.cloudfoundry.uaa.clients._BatchChangeSecretRequest instance = (org.cloudfoundry.uaa.clients._BatchChangeSecretRequest) object;
        addAllChangeSecrets(instance.getChangeSecrets());
      }
    }

    /**
     * Adds one element to {@link BatchChangeSecretRequest#getChangeSecrets() changeSecrets} list.
     * @param element A changeSecrets element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder changeSecret(ChangeSecret element) {
      this.changeSecrets.add(Objects.requireNonNull(element, "changeSecrets element"));
      return this;
    }

    /**
     * Adds elements to {@link BatchChangeSecretRequest#getChangeSecrets() changeSecrets} list.
     * @param elements An array of changeSecrets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder changeSecrets(ChangeSecret... elements) {
      for (ChangeSecret element : elements) {
        this.changeSecrets.add(Objects.requireNonNull(element, "changeSecrets element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link BatchChangeSecretRequest#getChangeSecrets() changeSecrets} list.
     * @param elements An iterable of changeSecrets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder changeSecrets(Iterable<? extends ChangeSecret> elements) {
      this.changeSecrets.clear();
      return addAllChangeSecrets(elements);
    }

    /**
     * Adds elements to {@link BatchChangeSecretRequest#getChangeSecrets() changeSecrets} list.
     * @param elements An iterable of changeSecrets elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChangeSecrets(Iterable<? extends ChangeSecret> elements) {
      for (ChangeSecret element : elements) {
        this.changeSecrets.add(Objects.requireNonNull(element, "changeSecrets element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link BatchChangeSecretRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link BatchChangeSecretRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link BatchChangeSecretRequest BatchChangeSecretRequest}.
     * @return An immutable instance of BatchChangeSecretRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public BatchChangeSecretRequest build() {
      return BatchChangeSecretRequest.validate(new BatchChangeSecretRequest(this));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
