package org.cloudfoundry.uaa.groups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the map external group request
 */
@Generated(from = "_MapExternalGroupRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class MapExternalGroupRequest extends org.cloudfoundry.uaa.groups._MapExternalGroupRequest {
  private final String externalGroup;
  private final String groupId;
  private final @Nullable String origin;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private MapExternalGroupRequest(MapExternalGroupRequest.Builder builder) {
    this.externalGroup = builder.externalGroup;
    this.groupId = builder.groupId;
    this.origin = builder.origin;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * The identifier for the group in external identity provider that needs to be mapped to internal UAA groups
   */
  @JsonProperty("externalGroup")
  @Override
  public String getExternalGroup() {
    return externalGroup;
  }

  /**
   * The group unique ID
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Unique alias of the identity provider
   */
  @JsonProperty("origin")
  @Override
  public @Nullable String getOrigin() {
    return origin;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @JsonProperty("identityZoneId")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @JsonProperty("identityZoneSubdomain")
  @JsonIgnore
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code MapExternalGroupRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof MapExternalGroupRequest
        && equalTo((MapExternalGroupRequest) another);
  }

  private boolean equalTo(MapExternalGroupRequest another) {
    return externalGroup.equals(another.externalGroup)
        && groupId.equals(another.groupId)
        && Objects.equals(origin, another.origin)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code externalGroup}, {@code groupId}, {@code origin}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + externalGroup.hashCode();
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + Objects.hashCode(origin);
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code MapExternalGroupRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MapExternalGroupRequest{"
        + "externalGroup=" + externalGroup
        + ", groupId=" + groupId
        + ", origin=" + origin
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_MapExternalGroupRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.groups._MapExternalGroupRequest {
    String externalGroup;
    String groupId;
    String origin;
    String identityZoneId;
    String identityZoneSubdomain;
    @JsonProperty("externalGroup")
    public void setExternalGroup(String externalGroup) {
      this.externalGroup = externalGroup;
    }
    @JsonProperty("groupId")
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @JsonProperty("origin")
    public void setOrigin(@Nullable String origin) {
      this.origin = origin;
    }
    @JsonProperty("identityZoneId")
    @JsonIgnore
    public void setIdentityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
    }
    @JsonProperty("identityZoneSubdomain")
    @JsonIgnore
    public void setIdentityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
    }
    @Override
    public String getExternalGroup() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrigin() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneId() { throw new UnsupportedOperationException(); }
    @Override
    public String getIdentityZoneSubdomain() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static MapExternalGroupRequest fromJson(Json json) {
    MapExternalGroupRequest.Builder builder = MapExternalGroupRequest.builder();
    if (json.externalGroup != null) {
      builder.externalGroup(json.externalGroup);
    }
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    if (json.origin != null) {
      builder.origin(json.origin);
    }
    if (json.identityZoneId != null) {
      builder.identityZoneId(json.identityZoneId);
    }
    if (json.identityZoneSubdomain != null) {
      builder.identityZoneSubdomain(json.identityZoneSubdomain);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link MapExternalGroupRequest MapExternalGroupRequest}.
   * <pre>
   * MapExternalGroupRequest.builder()
   *    .externalGroup(String) // required {@link MapExternalGroupRequest#getExternalGroup() externalGroup}
   *    .groupId(String) // required {@link MapExternalGroupRequest#getGroupId() groupId}
   *    .origin(String | null) // nullable {@link MapExternalGroupRequest#getOrigin() origin}
   *    .identityZoneId(String | null) // nullable {@link MapExternalGroupRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link MapExternalGroupRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .build();
   * </pre>
   * @return A new MapExternalGroupRequest builder
   */
  public static MapExternalGroupRequest.Builder builder() {
    return new MapExternalGroupRequest.Builder();
  }

  /**
   * Builds instances of type {@link MapExternalGroupRequest MapExternalGroupRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_MapExternalGroupRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_GROUP = 0x1L;
    private static final long INIT_BIT_GROUP_ID = 0x2L;
    private long initBits = 0x3L;

    private String externalGroup;
    private String groupId;
    private String origin;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code MapExternalGroupRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MapExternalGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _MapExternalGroupRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_MapExternalGroupRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._MapExternalGroupRequest) {
        org.cloudfoundry.uaa.groups._MapExternalGroupRequest instance = (org.cloudfoundry.uaa.groups._MapExternalGroupRequest) object;
        externalGroup(instance.getExternalGroup());
        groupId(instance.getGroupId());
        String originValue = instance.getOrigin();
        if (originValue != null) {
          origin(originValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link MapExternalGroupRequest#getExternalGroup() externalGroup} attribute.
     * @param externalGroup The value for externalGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String externalGroup) {
      this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
      initBits &= ~INIT_BIT_EXTERNAL_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link MapExternalGroupRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MapExternalGroupRequest#getOrigin() origin} attribute.
     * @param origin The value for origin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(@Nullable String origin) {
      this.origin = origin;
      return this;
    }

    /**
     * Initializes the value for the {@link MapExternalGroupRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link MapExternalGroupRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link MapExternalGroupRequest MapExternalGroupRequest}.
     * @return An immutable instance of MapExternalGroupRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public MapExternalGroupRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new MapExternalGroupRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXTERNAL_GROUP) != 0) attributes.add("externalGroup");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build MapExternalGroupRequest, some of required attributes are not set " + attributes;
    }
  }
}
