package org.cloudfoundry.uaa.groups;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.IdentityZoned;
import org.immutables.value.Generated;

/**
 * The request payload for the unmap external group by group id request
 */
@Generated(from = "_UnmapExternalGroupByGroupIdRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UnmapExternalGroupByGroupIdRequest
    extends org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupIdRequest {
  private final String externalGroup;
  private final String groupId;
  private final String origin;
  private final @Nullable String identityZoneId;
  private final @Nullable String identityZoneSubdomain;

  private UnmapExternalGroupByGroupIdRequest(UnmapExternalGroupByGroupIdRequest.Builder builder) {
    this.externalGroup = builder.externalGroup;
    this.groupId = builder.groupId;
    this.origin = builder.origin;
    this.identityZoneId = builder.identityZoneId;
    this.identityZoneSubdomain = builder.identityZoneSubdomain;
  }

  /**
   * The identifier for the group in external identity provider that needs to be unmapped to internal UAA groups
   */
  @Override
  public String getExternalGroup() {
    return externalGroup;
  }

  /**
   * The group unique ID
   */
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Unique alias of the identity provider
   */
  @Override
  public String getOrigin() {
    return origin;
  }

  /**
   * Returns the identity zone id
   * @return the identity zone id
   */
  @Override
  public @Nullable String getIdentityZoneId() {
    return identityZoneId;
  }

  /**
   * Returns the identity zone subdomain
   * @return the identity zone subdomain
   */
  @Override
  public @Nullable String getIdentityZoneSubdomain() {
    return identityZoneSubdomain;
  }

  /**
   * This instance is equal to all instances of {@code UnmapExternalGroupByGroupIdRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UnmapExternalGroupByGroupIdRequest
        && equalTo((UnmapExternalGroupByGroupIdRequest) another);
  }

  private boolean equalTo(UnmapExternalGroupByGroupIdRequest another) {
    return externalGroup.equals(another.externalGroup)
        && groupId.equals(another.groupId)
        && origin.equals(another.origin)
        && Objects.equals(identityZoneId, another.identityZoneId)
        && Objects.equals(identityZoneSubdomain, another.identityZoneSubdomain);
  }

  /**
   * Computes a hash code from attributes: {@code externalGroup}, {@code groupId}, {@code origin}, {@code identityZoneId}, {@code identityZoneSubdomain}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + externalGroup.hashCode();
    h += (h << 5) + groupId.hashCode();
    h += (h << 5) + origin.hashCode();
    h += (h << 5) + Objects.hashCode(identityZoneId);
    h += (h << 5) + Objects.hashCode(identityZoneSubdomain);
    return h;
  }

  /**
   * Prints the immutable value {@code UnmapExternalGroupByGroupIdRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UnmapExternalGroupByGroupIdRequest{"
        + "externalGroup=" + externalGroup
        + ", groupId=" + groupId
        + ", origin=" + origin
        + ", identityZoneId=" + identityZoneId
        + ", identityZoneSubdomain=" + identityZoneSubdomain
        + "}";
  }

  /**
   * Creates a builder for {@link UnmapExternalGroupByGroupIdRequest UnmapExternalGroupByGroupIdRequest}.
   * <pre>
   * UnmapExternalGroupByGroupIdRequest.builder()
   *    .externalGroup(String) // required {@link UnmapExternalGroupByGroupIdRequest#getExternalGroup() externalGroup}
   *    .groupId(String) // required {@link UnmapExternalGroupByGroupIdRequest#getGroupId() groupId}
   *    .origin(String) // required {@link UnmapExternalGroupByGroupIdRequest#getOrigin() origin}
   *    .identityZoneId(String | null) // nullable {@link UnmapExternalGroupByGroupIdRequest#getIdentityZoneId() identityZoneId}
   *    .identityZoneSubdomain(String | null) // nullable {@link UnmapExternalGroupByGroupIdRequest#getIdentityZoneSubdomain() identityZoneSubdomain}
   *    .build();
   * </pre>
   * @return A new UnmapExternalGroupByGroupIdRequest builder
   */
  public static UnmapExternalGroupByGroupIdRequest.Builder builder() {
    return new UnmapExternalGroupByGroupIdRequest.Builder();
  }

  /**
   * Builds instances of type {@link UnmapExternalGroupByGroupIdRequest UnmapExternalGroupByGroupIdRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UnmapExternalGroupByGroupIdRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_EXTERNAL_GROUP = 0x1L;
    private static final long INIT_BIT_GROUP_ID = 0x2L;
    private static final long INIT_BIT_ORIGIN = 0x4L;
    private long initBits = 0x7L;

    private String externalGroup;
    private String groupId;
    private String origin;
    private String identityZoneId;
    private String identityZoneSubdomain;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.cloudfoundry.uaa.IdentityZoned} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(IdentityZoned instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code UnmapExternalGroupByGroupIdRequest} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UnmapExternalGroupByGroupIdRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Copy abstract value type {@code _UnmapExternalGroupByGroupIdRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(_UnmapExternalGroupByGroupIdRequest instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof IdentityZoned) {
        IdentityZoned instance = (IdentityZoned) object;
        String identityZoneSubdomainValue = instance.getIdentityZoneSubdomain();
        if (identityZoneSubdomainValue != null) {
          identityZoneSubdomain(identityZoneSubdomainValue);
        }
        String identityZoneIdValue = instance.getIdentityZoneId();
        if (identityZoneIdValue != null) {
          identityZoneId(identityZoneIdValue);
        }
      }
      if (object instanceof org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupIdRequest) {
        org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupIdRequest instance = (org.cloudfoundry.uaa.groups._UnmapExternalGroupByGroupIdRequest) object;
        externalGroup(instance.getExternalGroup());
        groupId(instance.getGroupId());
        origin(instance.getOrigin());
      }
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupIdRequest#getExternalGroup() externalGroup} attribute.
     * @param externalGroup The value for externalGroup 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder externalGroup(String externalGroup) {
      this.externalGroup = Objects.requireNonNull(externalGroup, "externalGroup");
      initBits &= ~INIT_BIT_EXTERNAL_GROUP;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupIdRequest#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupIdRequest#getOrigin() origin} attribute.
     * @param origin The value for origin 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder origin(String origin) {
      this.origin = Objects.requireNonNull(origin, "origin");
      initBits &= ~INIT_BIT_ORIGIN;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupIdRequest#getIdentityZoneId() identityZoneId} attribute.
     * @param identityZoneId The value for identityZoneId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneId(@Nullable String identityZoneId) {
      this.identityZoneId = identityZoneId;
      return this;
    }

    /**
     * Initializes the value for the {@link UnmapExternalGroupByGroupIdRequest#getIdentityZoneSubdomain() identityZoneSubdomain} attribute.
     * @param identityZoneSubdomain The value for identityZoneSubdomain (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder identityZoneSubdomain(@Nullable String identityZoneSubdomain) {
      this.identityZoneSubdomain = identityZoneSubdomain;
      return this;
    }

    /**
     * Builds a new {@link UnmapExternalGroupByGroupIdRequest UnmapExternalGroupByGroupIdRequest}.
     * @return An immutable instance of UnmapExternalGroupByGroupIdRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UnmapExternalGroupByGroupIdRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UnmapExternalGroupByGroupIdRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_EXTERNAL_GROUP) != 0) attributes.add("externalGroup");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      if ((initBits & INIT_BIT_ORIGIN) != 0) attributes.add("origin");
      return "Cannot build UnmapExternalGroupByGroupIdRequest, some of required attributes are not set " + attributes;
    }
  }
}
