package org.cloudfoundry.uaa.identityzones;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The payload for the identity branding configuration
 */
@Generated(from = "_Branding", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class Branding extends org.cloudfoundry.uaa.identityzones._Branding {
  private final @Nullable Banner banner;
  private final @Nullable String companyName;
  private final @Nullable Consent consent;
  private final @Nullable String footerLegalText;
  private final @Nullable Map<String, String> footerLinks;
  private final @Nullable String productLogo;
  private final @Nullable String squareLogo;

  private Branding(Branding.Builder builder) {
    this.banner = builder.banner;
    this.companyName = builder.companyName;
    this.consent = builder.consent;
    this.footerLegalText = builder.footerLegalText;
    this.footerLinks = builder.footerLinks == null ? null : createUnmodifiableMap(false, false, builder.footerLinks);
    this.productLogo = builder.productLogo;
    this.squareLogo = builder.squareLogo;
  }

  /**
   * The banner configuration
   */
  @JsonProperty("banner")
  @Override
  public @Nullable Banner getBanner() {
    return banner;
  }

  /**
   * This name is used on the UAA Pages and in account management related communication in UAA
   */
  @JsonProperty("companyName")
  @Override
  public @Nullable String getCompanyName() {
    return companyName;
  }

  /**
   * The consent configuration
   */
  @JsonProperty("consent")
  @Override
  public @Nullable Consent getConsent() {
    return consent;
  }

  /**
   * This text appears on the footer of all UAA pages
   */
  @JsonProperty("footerLegalText")
  @Override
  public @Nullable String getFooterLegalText() {
    return footerLegalText;
  }

  /**
   * These links appear on the footer of all UAA pages. You may choose to add multiple urls for things like Support, Terms of Service etc.
   */
  @JsonProperty("footerLinks")
  @Override
  public @Nullable Map<String, String> getFooterLinks() {
    return footerLinks;
  }

  /**
   * This is a base64Url encoded PNG image which will be used as the logo on all UAA pages like Login, Sign Up etc.
   */
  @JsonProperty("productLogo")
  @Override
  public @Nullable String getProductLogo() {
    return productLogo;
  }

  /**
   * This is a base64 encoded PNG image which will be used as the favicon for the UAA pages
   */
  @JsonProperty("squareLogo")
  @Override
  public @Nullable String getSquareLogo() {
    return squareLogo;
  }

  /**
   * This instance is equal to all instances of {@code Branding} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof Branding
        && equalTo((Branding) another);
  }

  private boolean equalTo(Branding another) {
    return Objects.equals(banner, another.banner)
        && Objects.equals(companyName, another.companyName)
        && Objects.equals(consent, another.consent)
        && Objects.equals(footerLegalText, another.footerLegalText)
        && Objects.equals(footerLinks, another.footerLinks)
        && Objects.equals(productLogo, another.productLogo)
        && Objects.equals(squareLogo, another.squareLogo);
  }

  /**
   * Computes a hash code from attributes: {@code banner}, {@code companyName}, {@code consent}, {@code footerLegalText}, {@code footerLinks}, {@code productLogo}, {@code squareLogo}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(banner);
    h += (h << 5) + Objects.hashCode(companyName);
    h += (h << 5) + Objects.hashCode(consent);
    h += (h << 5) + Objects.hashCode(footerLegalText);
    h += (h << 5) + Objects.hashCode(footerLinks);
    h += (h << 5) + Objects.hashCode(productLogo);
    h += (h << 5) + Objects.hashCode(squareLogo);
    return h;
  }

  /**
   * Prints the immutable value {@code Branding} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Branding{"
        + "banner=" + banner
        + ", companyName=" + companyName
        + ", consent=" + consent
        + ", footerLegalText=" + footerLegalText
        + ", footerLinks=" + footerLinks
        + ", productLogo=" + productLogo
        + ", squareLogo=" + squareLogo
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_Branding", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.uaa.identityzones._Branding {
    Banner banner;
    String companyName;
    Consent consent;
    String footerLegalText;
    Map<String, String> footerLinks = null;
    String productLogo;
    String squareLogo;
    @JsonProperty("banner")
    public void setBanner(@Nullable Banner banner) {
      this.banner = banner;
    }
    @JsonProperty("companyName")
    public void setCompanyName(@Nullable String companyName) {
      this.companyName = companyName;
    }
    @JsonProperty("consent")
    public void setConsent(@Nullable Consent consent) {
      this.consent = consent;
    }
    @JsonProperty("footerLegalText")
    public void setFooterLegalText(@Nullable String footerLegalText) {
      this.footerLegalText = footerLegalText;
    }
    @JsonProperty("footerLinks")
    public void setFooterLinks(@Nullable Map<String, String> footerLinks) {
      this.footerLinks = footerLinks;
    }
    @JsonProperty("productLogo")
    public void setProductLogo(@Nullable String productLogo) {
      this.productLogo = productLogo;
    }
    @JsonProperty("squareLogo")
    public void setSquareLogo(@Nullable String squareLogo) {
      this.squareLogo = squareLogo;
    }
    @Override
    public Banner getBanner() { throw new UnsupportedOperationException(); }
    @Override
    public String getCompanyName() { throw new UnsupportedOperationException(); }
    @Override
    public Consent getConsent() { throw new UnsupportedOperationException(); }
    @Override
    public String getFooterLegalText() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, String> getFooterLinks() { throw new UnsupportedOperationException(); }
    @Override
    public String getProductLogo() { throw new UnsupportedOperationException(); }
    @Override
    public String getSquareLogo() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static Branding fromJson(Json json) {
    Branding.Builder builder = Branding.builder();
    if (json.banner != null) {
      builder.banner(json.banner);
    }
    if (json.companyName != null) {
      builder.companyName(json.companyName);
    }
    if (json.consent != null) {
      builder.consent(json.consent);
    }
    if (json.footerLegalText != null) {
      builder.footerLegalText(json.footerLegalText);
    }
    if (json.footerLinks != null) {
      builder.putAllFooterLinks(json.footerLinks);
    }
    if (json.productLogo != null) {
      builder.productLogo(json.productLogo);
    }
    if (json.squareLogo != null) {
      builder.squareLogo(json.squareLogo);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link Branding Branding}.
   * <pre>
   * Branding.builder()
   *    .banner(org.cloudfoundry.uaa.identityzones.Banner | null) // nullable {@link Branding#getBanner() banner}
   *    .companyName(String | null) // nullable {@link Branding#getCompanyName() companyName}
   *    .consent(org.cloudfoundry.uaa.identityzones.Consent | null) // nullable {@link Branding#getConsent() consent}
   *    .footerLegalText(String | null) // nullable {@link Branding#getFooterLegalText() footerLegalText}
   *    .footerLinks(Map&lt;String, String&gt; | null) // nullable {@link Branding#getFooterLinks() footerLinks}
   *    .productLogo(String | null) // nullable {@link Branding#getProductLogo() productLogo}
   *    .squareLogo(String | null) // nullable {@link Branding#getSquareLogo() squareLogo}
   *    .build();
   * </pre>
   * @return A new Branding builder
   */
  public static Branding.Builder builder() {
    return new Branding.Builder();
  }

  /**
   * Builds instances of type {@link Branding Branding}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_Branding", generator = "Immutables")
  public static final class Builder {
    private Banner banner;
    private String companyName;
    private Consent consent;
    private String footerLegalText;
    private Map<String, String> footerLinks = null;
    private String productLogo;
    private String squareLogo;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Branding} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(Branding instance) {
      return from((_Branding) instance);
    }

    /**
     * Copy abstract value type {@code _Branding} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_Branding instance) {
      Objects.requireNonNull(instance, "instance");
      Banner bannerValue = instance.getBanner();
      if (bannerValue != null) {
        banner(bannerValue);
      }
      String companyNameValue = instance.getCompanyName();
      if (companyNameValue != null) {
        companyName(companyNameValue);
      }
      Consent consentValue = instance.getConsent();
      if (consentValue != null) {
        consent(consentValue);
      }
      String footerLegalTextValue = instance.getFooterLegalText();
      if (footerLegalTextValue != null) {
        footerLegalText(footerLegalTextValue);
      }
      Map<String, String> footerLinksValue = instance.getFooterLinks();
      if (footerLinksValue != null) {
        putAllFooterLinks(footerLinksValue);
      }
      String productLogoValue = instance.getProductLogo();
      if (productLogoValue != null) {
        productLogo(productLogoValue);
      }
      String squareLogoValue = instance.getSquareLogo();
      if (squareLogoValue != null) {
        squareLogo(squareLogoValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Branding#getBanner() banner} attribute.
     * @param banner The value for banner (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("banner")
    public final Builder banner(@Nullable Banner banner) {
      this.banner = banner;
      return this;
    }

    /**
     * Initializes the value for the {@link Branding#getCompanyName() companyName} attribute.
     * @param companyName The value for companyName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("companyName")
    public final Builder companyName(@Nullable String companyName) {
      this.companyName = companyName;
      return this;
    }

    /**
     * Initializes the value for the {@link Branding#getConsent() consent} attribute.
     * @param consent The value for consent (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("consent")
    public final Builder consent(@Nullable Consent consent) {
      this.consent = consent;
      return this;
    }

    /**
     * Initializes the value for the {@link Branding#getFooterLegalText() footerLegalText} attribute.
     * @param footerLegalText The value for footerLegalText (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("footerLegalText")
    public final Builder footerLegalText(@Nullable String footerLegalText) {
      this.footerLegalText = footerLegalText;
      return this;
    }

    /**
     * Put one entry to the {@link Branding#getFooterLinks() footerLinks} map.
     * @param key The key in the footerLinks map
     * @param value The associated value in the footerLinks map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder footerLink(String key, String value) {
      if (this.footerLinks == null) {
        this.footerLinks = new LinkedHashMap<String, String>();
      }
      this.footerLinks.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link Branding#getFooterLinks() footerLinks} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder footerLink(Map.Entry<String, ? extends String> entry) {
      if (this.footerLinks == null) {
        this.footerLinks = new LinkedHashMap<String, String>();
      }
      String k = entry.getKey();
      String v = entry.getValue();
      this.footerLinks.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link Branding#getFooterLinks() footerLinks} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the footerLinks map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("footerLinks")
    public final Builder footerLinks(@Nullable Map<String, ? extends String> entries) {
      if (entries == null) {
        this.footerLinks = null;
        return this;
      }
      this.footerLinks = new LinkedHashMap<String, String>();
      return putAllFooterLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link Branding#getFooterLinks() footerLinks} map. Nulls are not permitted
     * @param entries The entries that will be added to the footerLinks map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllFooterLinks(Map<String, ? extends String> entries) {
      if (this.footerLinks == null) {
        this.footerLinks = new LinkedHashMap<String, String>();
      }
      for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
        String k = e.getKey();
        String v = e.getValue();
        this.footerLinks.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Branding#getProductLogo() productLogo} attribute.
     * @param productLogo The value for productLogo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("productLogo")
    public final Builder productLogo(@Nullable String productLogo) {
      this.productLogo = productLogo;
      return this;
    }

    /**
     * Initializes the value for the {@link Branding#getSquareLogo() squareLogo} attribute.
     * @param squareLogo The value for squareLogo (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("squareLogo")
    public final Builder squareLogo(@Nullable String squareLogo) {
      this.squareLogo = squareLogo;
      return this;
    }

    /**
     * Builds a new {@link Branding Branding}.
     * @return An immutable instance of Branding
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public Branding build() {
      return new Branding(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
