/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.serviceinstances;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.OrderDirection;
import org.cloudfoundry.client.v2.PaginatedRequest;
import org.cloudfoundry.client.v2.serviceinstances._ListServiceInstanceRoutesRequest;
import org.immutables.value.Generated;

@Generated(from="_ListServiceInstanceRoutesRequest", generator="Immutables")
public final class ListServiceInstanceRoutesRequest
extends _ListServiceInstanceRoutesRequest {
    @Nullable
    private final List<String> domainId;
    @Nullable
    private final List<String> host;
    @Nullable
    private final List<String> organizationId;
    @Nullable
    private final List<String> path;
    @Nullable
    private final List<String> port;
    private final String serviceInstanceId;
    @Nullable
    private final OrderDirection orderDirection;
    @Nullable
    private final Integer page;
    @Nullable
    private final Integer resultsPerPage;

    private ListServiceInstanceRoutesRequest(Builder builder) {
        this.domainId = builder.domainId == null ? null : ListServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.domainId);
        this.host = builder.host == null ? null : ListServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.host);
        this.organizationId = builder.organizationId == null ? null : ListServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.organizationId);
        this.path = builder.path == null ? null : ListServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.path);
        this.port = builder.port == null ? null : ListServiceInstanceRoutesRequest.createUnmodifiableList(true, builder.port);
        this.serviceInstanceId = builder.serviceInstanceId;
        this.orderDirection = builder.orderDirection;
        this.page = builder.page;
        this.resultsPerPage = builder.resultsPerPage;
    }

    @Override
    @Nullable
    public List<String> getDomainId() {
        return this.domainId;
    }

    @Override
    @Nullable
    public List<String> getHost() {
        return this.host;
    }

    @Override
    @Nullable
    public List<String> getOrganizationId() {
        return this.organizationId;
    }

    @Override
    @Nullable
    public List<String> getPath() {
        return this.path;
    }

    @Override
    @Nullable
    public List<String> getPort() {
        return this.port;
    }

    @Override
    public String getServiceInstanceId() {
        return this.serviceInstanceId;
    }

    @Override
    @Nullable
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    @Override
    @Nullable
    public Integer getPage() {
        return this.page;
    }

    @Override
    @Nullable
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ListServiceInstanceRoutesRequest && this.equalTo((ListServiceInstanceRoutesRequest)another);
    }

    private boolean equalTo(ListServiceInstanceRoutesRequest another) {
        return Objects.equals(this.domainId, another.domainId) && Objects.equals(this.host, another.host) && Objects.equals(this.organizationId, another.organizationId) && Objects.equals(this.path, another.path) && Objects.equals(this.port, another.port) && this.serviceInstanceId.equals(another.serviceInstanceId) && Objects.equals((Object)this.orderDirection, (Object)another.orderDirection) && Objects.equals(this.page, another.page) && Objects.equals(this.resultsPerPage, another.resultsPerPage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.domainId);
        h += (h << 5) + Objects.hashCode(this.host);
        h += (h << 5) + Objects.hashCode(this.organizationId);
        h += (h << 5) + Objects.hashCode(this.path);
        h += (h << 5) + Objects.hashCode(this.port);
        h += (h << 5) + this.serviceInstanceId.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.orderDirection);
        h += (h << 5) + Objects.hashCode(this.page);
        h += (h << 5) + Objects.hashCode(this.resultsPerPage);
        return h;
    }

    public String toString() {
        return "ListServiceInstanceRoutesRequest{domainId=" + this.domainId + ", host=" + this.host + ", organizationId=" + this.organizationId + ", path=" + this.path + ", port=" + this.port + ", serviceInstanceId=" + this.serviceInstanceId + ", orderDirection=" + (Object)((Object)this.orderDirection) + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_ListServiceInstanceRoutesRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE_INSTANCE_ID = 1L;
        private long initBits = 1L;
        private List<String> domainId = null;
        private List<String> host = null;
        private List<String> organizationId = null;
        private List<String> path = null;
        private List<String> port = null;
        private String serviceInstanceId;
        private OrderDirection orderDirection;
        private Integer page;
        private Integer resultsPerPage;

        private Builder() {
        }

        public final Builder from(PaginatedRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ListServiceInstanceRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_ListServiceInstanceRoutesRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PaginatedRequest instance;
            if (object instanceof PaginatedRequest) {
                Integer pageValue;
                Integer resultsPerPageValue;
                instance = (PaginatedRequest)object;
                OrderDirection orderDirectionValue = instance.getOrderDirection();
                if (orderDirectionValue != null) {
                    this.orderDirection(orderDirectionValue);
                }
                if ((resultsPerPageValue = instance.getResultsPerPage()) != null) {
                    this.resultsPerPage(resultsPerPageValue);
                }
                if ((pageValue = instance.getPage()) != null) {
                    this.page(pageValue);
                }
            }
            if (object instanceof _ListServiceInstanceRoutesRequest) {
                List<String> domainIdValue;
                List<String> pathValue;
                List<String> hostValue;
                instance = (_ListServiceInstanceRoutesRequest)object;
                List<String> organizationIdValue = ((_ListServiceInstanceRoutesRequest)instance).getOrganizationId();
                if (organizationIdValue != null) {
                    this.addAllOrganizationId(organizationIdValue);
                }
                if ((hostValue = ((_ListServiceInstanceRoutesRequest)instance).getHost()) != null) {
                    this.addAllHost(hostValue);
                }
                if ((pathValue = ((_ListServiceInstanceRoutesRequest)instance).getPath()) != null) {
                    this.addAllPath(pathValue);
                }
                this.serviceInstanceId(((_ListServiceInstanceRoutesRequest)instance).getServiceInstanceId());
                List<String> portValue = ((_ListServiceInstanceRoutesRequest)instance).getPort();
                if (portValue != null) {
                    this.addAllPort(portValue);
                }
                if ((domainIdValue = ((_ListServiceInstanceRoutesRequest)instance).getDomainId()) != null) {
                    this.addAllDomainId(domainIdValue);
                }
            }
        }

        public final Builder domainId(String element) {
            if (this.domainId == null) {
                this.domainId = new ArrayList<String>();
            }
            this.domainId.add(Objects.requireNonNull(element, "domainId element"));
            return this;
        }

        public final Builder domainId(String ... elements) {
            if (this.domainId == null) {
                this.domainId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainId.add(Objects.requireNonNull(element, "domainId element"));
            }
            return this;
        }

        public final Builder domainId(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.domainId = null;
                return this;
            }
            this.domainId = new ArrayList<String>();
            return this.addAllDomainId(elements);
        }

        public final Builder addAllDomainId(Iterable<String> elements) {
            Objects.requireNonNull(elements, "domainId element");
            if (this.domainId == null) {
                this.domainId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.domainId.add(Objects.requireNonNull(element, "domainId element"));
            }
            return this;
        }

        public final Builder host(String element) {
            if (this.host == null) {
                this.host = new ArrayList<String>();
            }
            this.host.add(Objects.requireNonNull(element, "host element"));
            return this;
        }

        public final Builder host(String ... elements) {
            if (this.host == null) {
                this.host = new ArrayList<String>();
            }
            for (String element : elements) {
                this.host.add(Objects.requireNonNull(element, "host element"));
            }
            return this;
        }

        public final Builder host(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.host = null;
                return this;
            }
            this.host = new ArrayList<String>();
            return this.addAllHost(elements);
        }

        public final Builder addAllHost(Iterable<String> elements) {
            Objects.requireNonNull(elements, "host element");
            if (this.host == null) {
                this.host = new ArrayList<String>();
            }
            for (String element : elements) {
                this.host.add(Objects.requireNonNull(element, "host element"));
            }
            return this;
        }

        public final Builder organizationId(String element) {
            if (this.organizationId == null) {
                this.organizationId = new ArrayList<String>();
            }
            this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
            return this;
        }

        public final Builder organizationId(String ... elements) {
            if (this.organizationId == null) {
                this.organizationId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
            }
            return this;
        }

        public final Builder organizationId(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.organizationId = null;
                return this;
            }
            this.organizationId = new ArrayList<String>();
            return this.addAllOrganizationId(elements);
        }

        public final Builder addAllOrganizationId(Iterable<String> elements) {
            Objects.requireNonNull(elements, "organizationId element");
            if (this.organizationId == null) {
                this.organizationId = new ArrayList<String>();
            }
            for (String element : elements) {
                this.organizationId.add(Objects.requireNonNull(element, "organizationId element"));
            }
            return this;
        }

        public final Builder path(String element) {
            if (this.path == null) {
                this.path = new ArrayList<String>();
            }
            this.path.add(Objects.requireNonNull(element, "path element"));
            return this;
        }

        public final Builder path(String ... elements) {
            if (this.path == null) {
                this.path = new ArrayList<String>();
            }
            for (String element : elements) {
                this.path.add(Objects.requireNonNull(element, "path element"));
            }
            return this;
        }

        public final Builder path(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.path = null;
                return this;
            }
            this.path = new ArrayList<String>();
            return this.addAllPath(elements);
        }

        public final Builder addAllPath(Iterable<String> elements) {
            Objects.requireNonNull(elements, "path element");
            if (this.path == null) {
                this.path = new ArrayList<String>();
            }
            for (String element : elements) {
                this.path.add(Objects.requireNonNull(element, "path element"));
            }
            return this;
        }

        public final Builder port(String element) {
            if (this.port == null) {
                this.port = new ArrayList<String>();
            }
            this.port.add(Objects.requireNonNull(element, "port element"));
            return this;
        }

        public final Builder port(String ... elements) {
            if (this.port == null) {
                this.port = new ArrayList<String>();
            }
            for (String element : elements) {
                this.port.add(Objects.requireNonNull(element, "port element"));
            }
            return this;
        }

        public final Builder port(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.port = null;
                return this;
            }
            this.port = new ArrayList<String>();
            return this.addAllPort(elements);
        }

        public final Builder addAllPort(Iterable<String> elements) {
            Objects.requireNonNull(elements, "port element");
            if (this.port == null) {
                this.port = new ArrayList<String>();
            }
            for (String element : elements) {
                this.port.add(Objects.requireNonNull(element, "port element"));
            }
            return this;
        }

        public final Builder serviceInstanceId(String serviceInstanceId) {
            this.serviceInstanceId = Objects.requireNonNull(serviceInstanceId, "serviceInstanceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder orderDirection(@Nullable OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        public final Builder page(@Nullable Integer page) {
            this.page = page;
            return this;
        }

        public final Builder resultsPerPage(@Nullable Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        public ListServiceInstanceRoutesRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ListServiceInstanceRoutesRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("serviceInstanceId");
            }
            return "Cannot build ListServiceInstanceRoutesRequest, some of required attributes are not set " + attributes;
        }
    }
}

