/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v2.spaces;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.applications.AbstractApplicationEntity;
import org.cloudfoundry.client.v2.applications.DockerCredentials;
import org.cloudfoundry.client.v2.routes.Route;
import org.cloudfoundry.client.v2.spaces._SpaceApplicationSummary;
import org.immutables.value.Generated;

@Generated(from="_SpaceApplicationSummary", generator="Immutables")
public final class SpaceApplicationSummary
extends _SpaceApplicationSummary {
    @Nullable
    private final String detectedBuildpack;
    @Nullable
    private final String detectedBuildpackId;
    @Nullable
    private final Boolean enableSsh;
    @Nullable
    private final String id;
    @Nullable
    private final String packageState;
    @Nullable
    private final String packageUpdatedAt;
    @Nullable
    private final List<Integer> ports;
    @Nullable
    private final List<Route> routes;
    @Nullable
    private final Integer runningInstances;
    @Nullable
    private final Integer serviceCount;
    private final List<String> serviceNames;
    @Nullable
    private final List<String> urls;
    @Nullable
    private final String version;
    @Nullable
    private final String buildpack;
    @Nullable
    private final String command;
    @Nullable
    private final Boolean console;
    @Nullable
    private final String debug;
    @Nullable
    private final String detectedStartCommand;
    @Nullable
    private final Boolean diego;
    @Nullable
    private final Integer diskQuota;
    @Nullable
    private final DockerCredentials dockerCredentials;
    @Nullable
    private final String dockerImage;
    @Nullable
    private final Map<String, Object> environmentJsons;
    @Nullable
    private final String healthCheckHttpEndpoint;
    @Nullable
    private final Integer healthCheckTimeout;
    @Nullable
    private final String healthCheckType;
    @Nullable
    private final Integer instances;
    @Nullable
    private final Integer memory;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean production;
    @Nullable
    private final String spaceId;
    @Nullable
    private final String stackId;
    @Nullable
    private final String stagingFailedDescription;
    @Nullable
    private final String stagingFailedReason;
    @Nullable
    private final String stagingTaskId;
    @Nullable
    private final String state;

    private SpaceApplicationSummary(Builder builder) {
        this.detectedBuildpack = builder.detectedBuildpack;
        this.detectedBuildpackId = builder.detectedBuildpackId;
        this.enableSsh = builder.enableSsh;
        this.id = builder.id;
        this.packageState = builder.packageState;
        this.packageUpdatedAt = builder.packageUpdatedAt;
        this.ports = builder.ports == null ? null : SpaceApplicationSummary.createUnmodifiableList(true, builder.ports);
        this.routes = builder.routes == null ? null : SpaceApplicationSummary.createUnmodifiableList(true, builder.routes);
        this.runningInstances = builder.runningInstances;
        this.serviceCount = builder.serviceCount;
        this.serviceNames = SpaceApplicationSummary.createUnmodifiableList(true, builder.serviceNames);
        this.urls = builder.urls == null ? null : SpaceApplicationSummary.createUnmodifiableList(true, builder.urls);
        this.version = builder.version;
        this.buildpack = builder.buildpack;
        this.command = builder.command;
        this.console = builder.console;
        this.debug = builder.debug;
        this.detectedStartCommand = builder.detectedStartCommand;
        this.diego = builder.diego;
        this.diskQuota = builder.diskQuota;
        this.dockerCredentials = builder.dockerCredentials;
        this.dockerImage = builder.dockerImage;
        this.environmentJsons = builder.environmentJsons == null ? null : SpaceApplicationSummary.createUnmodifiableMap(false, false, builder.environmentJsons);
        this.healthCheckHttpEndpoint = builder.healthCheckHttpEndpoint;
        this.healthCheckTimeout = builder.healthCheckTimeout;
        this.healthCheckType = builder.healthCheckType;
        this.instances = builder.instances;
        this.memory = builder.memory;
        this.name = builder.name;
        this.production = builder.production;
        this.spaceId = builder.spaceId;
        this.stackId = builder.stackId;
        this.stagingFailedDescription = builder.stagingFailedDescription;
        this.stagingFailedReason = builder.stagingFailedReason;
        this.stagingTaskId = builder.stagingTaskId;
        this.state = builder.state;
    }

    @Override
    @JsonProperty(value="detected_buildpack")
    @Nullable
    public String getDetectedBuildpack() {
        return this.detectedBuildpack;
    }

    @Override
    @JsonProperty(value="detected_buildpack_guid")
    @Nullable
    public String getDetectedBuildpackId() {
        return this.detectedBuildpackId;
    }

    @Override
    @JsonProperty(value="enable_ssh")
    @Nullable
    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    @Override
    @JsonProperty(value="guid")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="package_state")
    @Nullable
    public String getPackageState() {
        return this.packageState;
    }

    @Override
    @JsonProperty(value="package_updated_at")
    @Nullable
    public String getPackageUpdatedAt() {
        return this.packageUpdatedAt;
    }

    @Override
    @JsonProperty(value="ports")
    @Nullable
    public List<Integer> getPorts() {
        return this.ports;
    }

    @Override
    @JsonProperty(value="routes")
    @Nullable
    public List<Route> getRoutes() {
        return this.routes;
    }

    @Override
    @JsonProperty(value="running_instances")
    @Nullable
    public Integer getRunningInstances() {
        return this.runningInstances;
    }

    @Override
    @JsonProperty(value="service_count")
    @Nullable
    public Integer getServiceCount() {
        return this.serviceCount;
    }

    @Override
    @JsonProperty(value="service_names")
    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    @Override
    @JsonProperty(value="urls")
    @Nullable
    public List<String> getUrls() {
        return this.urls;
    }

    @Override
    @JsonProperty(value="version")
    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="buildpack")
    @Nullable
    public String getBuildpack() {
        return this.buildpack;
    }

    @Override
    @JsonProperty(value="command")
    @Nullable
    public String getCommand() {
        return this.command;
    }

    @Override
    @JsonProperty(value="console")
    @Deprecated
    @Nullable
    public Boolean getConsole() {
        return this.console;
    }

    @Override
    @JsonProperty(value="debug")
    @Deprecated
    @Nullable
    public String getDebug() {
        return this.debug;
    }

    @Override
    @JsonProperty(value="detected_start_command")
    @Nullable
    public String getDetectedStartCommand() {
        return this.detectedStartCommand;
    }

    @Override
    @JsonProperty(value="diego")
    @Nullable
    public Boolean getDiego() {
        return this.diego;
    }

    @Override
    @JsonProperty(value="disk_quota")
    @Nullable
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    @Override
    @JsonProperty(value="docker_credentials")
    @Nullable
    public DockerCredentials getDockerCredentials() {
        return this.dockerCredentials;
    }

    @Override
    @JsonProperty(value="docker_image")
    @Nullable
    public String getDockerImage() {
        return this.dockerImage;
    }

    @Override
    @JsonProperty(value="environment_json")
    @Nullable
    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    @Override
    @JsonProperty(value="health_check_http_endpoint")
    @Nullable
    public String getHealthCheckHttpEndpoint() {
        return this.healthCheckHttpEndpoint;
    }

    @Override
    @JsonProperty(value="health_check_timeout")
    @Nullable
    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    @Override
    @JsonProperty(value="health_check_type")
    @Nullable
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    @Override
    @JsonProperty(value="instances")
    @Nullable
    public Integer getInstances() {
        return this.instances;
    }

    @Override
    @JsonProperty(value="memory")
    @Nullable
    public Integer getMemory() {
        return this.memory;
    }

    @Override
    @JsonProperty(value="name")
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="production")
    @Deprecated
    @Nullable
    public Boolean getProduction() {
        return this.production;
    }

    @Override
    @JsonProperty(value="space_guid")
    @Nullable
    public String getSpaceId() {
        return this.spaceId;
    }

    @Override
    @JsonProperty(value="stack_guid")
    @Nullable
    public String getStackId() {
        return this.stackId;
    }

    @Override
    @JsonProperty(value="staging_failed_description")
    @Nullable
    public String getStagingFailedDescription() {
        return this.stagingFailedDescription;
    }

    @Override
    @JsonProperty(value="staging_failed_reason")
    @Nullable
    public String getStagingFailedReason() {
        return this.stagingFailedReason;
    }

    @Override
    @JsonProperty(value="staging_task_id")
    @Nullable
    public String getStagingTaskId() {
        return this.stagingTaskId;
    }

    @Override
    @JsonProperty(value="state")
    @Nullable
    public String getState() {
        return this.state;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SpaceApplicationSummary && this.equalTo((SpaceApplicationSummary)another);
    }

    private boolean equalTo(SpaceApplicationSummary another) {
        return Objects.equals(this.detectedBuildpack, another.detectedBuildpack) && Objects.equals(this.detectedBuildpackId, another.detectedBuildpackId) && Objects.equals(this.enableSsh, another.enableSsh) && Objects.equals(this.id, another.id) && Objects.equals(this.packageState, another.packageState) && Objects.equals(this.packageUpdatedAt, another.packageUpdatedAt) && Objects.equals(this.ports, another.ports) && Objects.equals(this.routes, another.routes) && Objects.equals(this.runningInstances, another.runningInstances) && Objects.equals(this.serviceCount, another.serviceCount) && this.serviceNames.equals(another.serviceNames) && Objects.equals(this.urls, another.urls) && Objects.equals(this.version, another.version) && Objects.equals(this.buildpack, another.buildpack) && Objects.equals(this.command, another.command) && Objects.equals(this.console, another.console) && Objects.equals(this.debug, another.debug) && Objects.equals(this.detectedStartCommand, another.detectedStartCommand) && Objects.equals(this.diego, another.diego) && Objects.equals(this.diskQuota, another.diskQuota) && Objects.equals(this.dockerCredentials, another.dockerCredentials) && Objects.equals(this.dockerImage, another.dockerImage) && Objects.equals(this.environmentJsons, another.environmentJsons) && Objects.equals(this.healthCheckHttpEndpoint, another.healthCheckHttpEndpoint) && Objects.equals(this.healthCheckTimeout, another.healthCheckTimeout) && Objects.equals(this.healthCheckType, another.healthCheckType) && Objects.equals(this.instances, another.instances) && Objects.equals(this.memory, another.memory) && Objects.equals(this.name, another.name) && Objects.equals(this.production, another.production) && Objects.equals(this.spaceId, another.spaceId) && Objects.equals(this.stackId, another.stackId) && Objects.equals(this.stagingFailedDescription, another.stagingFailedDescription) && Objects.equals(this.stagingFailedReason, another.stagingFailedReason) && Objects.equals(this.stagingTaskId, another.stagingTaskId) && Objects.equals(this.state, another.state);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.detectedBuildpack);
        h += (h << 5) + Objects.hashCode(this.detectedBuildpackId);
        h += (h << 5) + Objects.hashCode(this.enableSsh);
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.packageState);
        h += (h << 5) + Objects.hashCode(this.packageUpdatedAt);
        h += (h << 5) + Objects.hashCode(this.ports);
        h += (h << 5) + Objects.hashCode(this.routes);
        h += (h << 5) + Objects.hashCode(this.runningInstances);
        h += (h << 5) + Objects.hashCode(this.serviceCount);
        h += (h << 5) + this.serviceNames.hashCode();
        h += (h << 5) + Objects.hashCode(this.urls);
        h += (h << 5) + Objects.hashCode(this.version);
        h += (h << 5) + Objects.hashCode(this.buildpack);
        h += (h << 5) + Objects.hashCode(this.command);
        h += (h << 5) + Objects.hashCode(this.console);
        h += (h << 5) + Objects.hashCode(this.debug);
        h += (h << 5) + Objects.hashCode(this.detectedStartCommand);
        h += (h << 5) + Objects.hashCode(this.diego);
        h += (h << 5) + Objects.hashCode(this.diskQuota);
        h += (h << 5) + Objects.hashCode(this.dockerCredentials);
        h += (h << 5) + Objects.hashCode(this.dockerImage);
        h += (h << 5) + Objects.hashCode(this.environmentJsons);
        h += (h << 5) + Objects.hashCode(this.healthCheckHttpEndpoint);
        h += (h << 5) + Objects.hashCode(this.healthCheckTimeout);
        h += (h << 5) + Objects.hashCode(this.healthCheckType);
        h += (h << 5) + Objects.hashCode(this.instances);
        h += (h << 5) + Objects.hashCode(this.memory);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.production);
        h += (h << 5) + Objects.hashCode(this.spaceId);
        h += (h << 5) + Objects.hashCode(this.stackId);
        h += (h << 5) + Objects.hashCode(this.stagingFailedDescription);
        h += (h << 5) + Objects.hashCode(this.stagingFailedReason);
        h += (h << 5) + Objects.hashCode(this.stagingTaskId);
        h += (h << 5) + Objects.hashCode(this.state);
        return h;
    }

    public String toString() {
        return "SpaceApplicationSummary{detectedBuildpack=" + this.detectedBuildpack + ", detectedBuildpackId=" + this.detectedBuildpackId + ", enableSsh=" + this.enableSsh + ", id=" + this.id + ", packageState=" + this.packageState + ", packageUpdatedAt=" + this.packageUpdatedAt + ", ports=" + this.ports + ", routes=" + this.routes + ", runningInstances=" + this.runningInstances + ", serviceCount=" + this.serviceCount + ", serviceNames=" + this.serviceNames + ", urls=" + this.urls + ", version=" + this.version + ", buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentials=" + this.dockerCredentials + ", dockerImage=" + this.dockerImage + ", environmentJsons=" + this.environmentJsons + ", healthCheckHttpEndpoint=" + this.healthCheckHttpEndpoint + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", production=" + this.production + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", stagingFailedDescription=" + this.stagingFailedDescription + ", stagingFailedReason=" + this.stagingFailedReason + ", stagingTaskId=" + this.stagingTaskId + ", state=" + this.state + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SpaceApplicationSummary fromJson(Json json) {
        Builder builder = SpaceApplicationSummary.builder();
        if (json.detectedBuildpack != null) {
            builder.detectedBuildpack(json.detectedBuildpack);
        }
        if (json.detectedBuildpackId != null) {
            builder.detectedBuildpackId(json.detectedBuildpackId);
        }
        if (json.enableSsh != null) {
            builder.enableSsh(json.enableSsh);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.packageState != null) {
            builder.packageState(json.packageState);
        }
        if (json.packageUpdatedAt != null) {
            builder.packageUpdatedAt(json.packageUpdatedAt);
        }
        if (json.ports != null) {
            builder.addAllPorts(json.ports);
        }
        if (json.routes != null) {
            builder.addAllRoutes(json.routes);
        }
        if (json.runningInstances != null) {
            builder.runningInstances(json.runningInstances);
        }
        if (json.serviceCount != null) {
            builder.serviceCount(json.serviceCount);
        }
        if (json.serviceNames != null) {
            builder.addAllServiceNames(json.serviceNames);
        }
        if (json.urls != null) {
            builder.addAllUrls(json.urls);
        }
        if (json.version != null) {
            builder.version(json.version);
        }
        if (json.buildpack != null) {
            builder.buildpack(json.buildpack);
        }
        if (json.command != null) {
            builder.command(json.command);
        }
        if (json.console != null) {
            builder.console(json.console);
        }
        if (json.debug != null) {
            builder.debug(json.debug);
        }
        if (json.detectedStartCommand != null) {
            builder.detectedStartCommand(json.detectedStartCommand);
        }
        if (json.diego != null) {
            builder.diego(json.diego);
        }
        if (json.diskQuota != null) {
            builder.diskQuota(json.diskQuota);
        }
        if (json.dockerCredentials != null) {
            builder.dockerCredentials(json.dockerCredentials);
        }
        if (json.dockerImage != null) {
            builder.dockerImage(json.dockerImage);
        }
        if (json.environmentJsons != null) {
            builder.putAllEnvironmentJsons(json.environmentJsons);
        }
        if (json.healthCheckHttpEndpoint != null) {
            builder.healthCheckHttpEndpoint(json.healthCheckHttpEndpoint);
        }
        if (json.healthCheckTimeout != null) {
            builder.healthCheckTimeout(json.healthCheckTimeout);
        }
        if (json.healthCheckType != null) {
            builder.healthCheckType(json.healthCheckType);
        }
        if (json.instances != null) {
            builder.instances(json.instances);
        }
        if (json.memory != null) {
            builder.memory(json.memory);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.production != null) {
            builder.production(json.production);
        }
        if (json.spaceId != null) {
            builder.spaceId(json.spaceId);
        }
        if (json.stackId != null) {
            builder.stackId(json.stackId);
        }
        if (json.stagingFailedDescription != null) {
            builder.stagingFailedDescription(json.stagingFailedDescription);
        }
        if (json.stagingFailedReason != null) {
            builder.stagingFailedReason(json.stagingFailedReason);
        }
        if (json.stagingTaskId != null) {
            builder.stagingTaskId(json.stagingTaskId);
        }
        if (json.state != null) {
            builder.state(json.state);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_SpaceApplicationSummary", generator="Immutables")
    public static final class Builder {
        private String detectedBuildpack;
        private String detectedBuildpackId;
        private Boolean enableSsh;
        private String id;
        private String packageState;
        private String packageUpdatedAt;
        private List<Integer> ports = null;
        private List<Route> routes = null;
        private Integer runningInstances;
        private Integer serviceCount;
        private List<String> serviceNames = new ArrayList<String>();
        private List<String> urls = null;
        private String version;
        private String buildpack;
        private String command;
        private Boolean console;
        private String debug;
        private String detectedStartCommand;
        private Boolean diego;
        private Integer diskQuota;
        private DockerCredentials dockerCredentials;
        private String dockerImage;
        private Map<String, Object> environmentJsons = null;
        private String healthCheckHttpEndpoint;
        private Integer healthCheckTimeout;
        private String healthCheckType;
        private Integer instances;
        private Integer memory;
        private String name;
        private Boolean production;
        private String spaceId;
        private String stackId;
        private String stagingFailedDescription;
        private String stagingFailedReason;
        private String stagingTaskId;
        private String state;

        private Builder() {
        }

        public final Builder from(SpaceApplicationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_SpaceApplicationSummary instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractApplicationEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            AbstractApplicationEntity instance;
            if (object instanceof _SpaceApplicationSummary) {
                String packageStateValue;
                Boolean enableSshValue;
                String idValue;
                String detectedBuildpackIdValue;
                Integer serviceCountValue;
                List<String> urlsValue;
                List<Route> routesValue;
                Integer runningInstancesValue;
                List<Integer> portsValue;
                String packageUpdatedAtValue;
                instance = (_SpaceApplicationSummary)object;
                String detectedBuildpackValue = ((_SpaceApplicationSummary)instance).getDetectedBuildpack();
                if (detectedBuildpackValue != null) {
                    this.detectedBuildpack(detectedBuildpackValue);
                }
                if ((packageUpdatedAtValue = ((_SpaceApplicationSummary)instance).getPackageUpdatedAt()) != null) {
                    this.packageUpdatedAt(packageUpdatedAtValue);
                }
                if ((portsValue = ((_SpaceApplicationSummary)instance).getPorts()) != null) {
                    this.addAllPorts(portsValue);
                }
                if ((runningInstancesValue = ((_SpaceApplicationSummary)instance).getRunningInstances()) != null) {
                    this.runningInstances(runningInstancesValue);
                }
                this.addAllServiceNames(((_SpaceApplicationSummary)instance).getServiceNames());
                String versionValue = ((_SpaceApplicationSummary)instance).getVersion();
                if (versionValue != null) {
                    this.version(versionValue);
                }
                if ((routesValue = ((_SpaceApplicationSummary)instance).getRoutes()) != null) {
                    this.addAllRoutes(routesValue);
                }
                if ((urlsValue = ((_SpaceApplicationSummary)instance).getUrls()) != null) {
                    this.addAllUrls(urlsValue);
                }
                if ((serviceCountValue = ((_SpaceApplicationSummary)instance).getServiceCount()) != null) {
                    this.serviceCount(serviceCountValue);
                }
                if ((detectedBuildpackIdValue = ((_SpaceApplicationSummary)instance).getDetectedBuildpackId()) != null) {
                    this.detectedBuildpackId(detectedBuildpackIdValue);
                }
                if ((idValue = ((_SpaceApplicationSummary)instance).getId()) != null) {
                    this.id(idValue);
                }
                if ((enableSshValue = ((_SpaceApplicationSummary)instance).getEnableSsh()) != null) {
                    this.enableSsh(enableSshValue);
                }
                if ((packageStateValue = ((_SpaceApplicationSummary)instance).getPackageState()) != null) {
                    this.packageState(packageStateValue);
                }
            }
            if (object instanceof AbstractApplicationEntity) {
                Integer diskQuotaValue;
                String stagingTaskIdValue;
                String stateValue;
                Map<String, Object> environmentJsonsValue;
                Boolean diegoValue;
                String nameValue;
                String healthCheckHttpEndpointValue;
                String spaceIdValue;
                String commandValue;
                String stagingFailedDescriptionValue;
                String buildpackValue;
                DockerCredentials dockerCredentialsValue;
                String detectedStartCommandValue;
                String stackIdValue;
                Boolean productionValue;
                Integer instancesValue;
                String debugValue;
                Integer memoryValue;
                String dockerImageValue;
                String stagingFailedReasonValue;
                Boolean consoleValue;
                String healthCheckTypeValue;
                instance = (AbstractApplicationEntity)object;
                Integer healthCheckTimeoutValue = instance.getHealthCheckTimeout();
                if (healthCheckTimeoutValue != null) {
                    this.healthCheckTimeout(healthCheckTimeoutValue);
                }
                if ((healthCheckTypeValue = instance.getHealthCheckType()) != null) {
                    this.healthCheckType(healthCheckTypeValue);
                }
                if ((consoleValue = instance.getConsole()) != null) {
                    this.console(consoleValue);
                }
                if ((stagingFailedReasonValue = instance.getStagingFailedReason()) != null) {
                    this.stagingFailedReason(stagingFailedReasonValue);
                }
                if ((dockerImageValue = instance.getDockerImage()) != null) {
                    this.dockerImage(dockerImageValue);
                }
                if ((memoryValue = instance.getMemory()) != null) {
                    this.memory(memoryValue);
                }
                if ((debugValue = instance.getDebug()) != null) {
                    this.debug(debugValue);
                }
                if ((instancesValue = instance.getInstances()) != null) {
                    this.instances(instancesValue);
                }
                if ((productionValue = instance.getProduction()) != null) {
                    this.production(productionValue);
                }
                if ((stackIdValue = instance.getStackId()) != null) {
                    this.stackId(stackIdValue);
                }
                if ((detectedStartCommandValue = instance.getDetectedStartCommand()) != null) {
                    this.detectedStartCommand(detectedStartCommandValue);
                }
                if ((dockerCredentialsValue = instance.getDockerCredentials()) != null) {
                    this.dockerCredentials(dockerCredentialsValue);
                }
                if ((buildpackValue = instance.getBuildpack()) != null) {
                    this.buildpack(buildpackValue);
                }
                if ((stagingFailedDescriptionValue = instance.getStagingFailedDescription()) != null) {
                    this.stagingFailedDescription(stagingFailedDescriptionValue);
                }
                if ((commandValue = instance.getCommand()) != null) {
                    this.command(commandValue);
                }
                if ((spaceIdValue = instance.getSpaceId()) != null) {
                    this.spaceId(spaceIdValue);
                }
                if ((healthCheckHttpEndpointValue = instance.getHealthCheckHttpEndpoint()) != null) {
                    this.healthCheckHttpEndpoint(healthCheckHttpEndpointValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((diegoValue = instance.getDiego()) != null) {
                    this.diego(diegoValue);
                }
                if ((environmentJsonsValue = instance.getEnvironmentJsons()) != null) {
                    this.putAllEnvironmentJsons(environmentJsonsValue);
                }
                if ((stateValue = instance.getState()) != null) {
                    this.state(stateValue);
                }
                if ((stagingTaskIdValue = instance.getStagingTaskId()) != null) {
                    this.stagingTaskId(stagingTaskIdValue);
                }
                if ((diskQuotaValue = instance.getDiskQuota()) != null) {
                    this.diskQuota(diskQuotaValue);
                }
            }
        }

        @JsonProperty(value="detected_buildpack")
        public final Builder detectedBuildpack(@Nullable String detectedBuildpack) {
            this.detectedBuildpack = detectedBuildpack;
            return this;
        }

        @JsonProperty(value="detected_buildpack_guid")
        public final Builder detectedBuildpackId(@Nullable String detectedBuildpackId) {
            this.detectedBuildpackId = detectedBuildpackId;
            return this;
        }

        @JsonProperty(value="enable_ssh")
        public final Builder enableSsh(@Nullable Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        @JsonProperty(value="guid")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="package_state")
        public final Builder packageState(@Nullable String packageState) {
            this.packageState = packageState;
            return this;
        }

        @JsonProperty(value="package_updated_at")
        public final Builder packageUpdatedAt(@Nullable String packageUpdatedAt) {
            this.packageUpdatedAt = packageUpdatedAt;
            return this;
        }

        public final Builder port(int element) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            this.ports.add(element);
            return this;
        }

        public final Builder ports(int ... elements) {
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(element);
            }
            return this;
        }

        @JsonProperty(value="ports")
        public final Builder ports(@Nullable Iterable<Integer> elements) {
            if (elements == null) {
                this.ports = null;
                return this;
            }
            this.ports = new ArrayList<Integer>();
            return this.addAllPorts(elements);
        }

        public final Builder addAllPorts(Iterable<Integer> elements) {
            Objects.requireNonNull(elements, "ports element");
            if (this.ports == null) {
                this.ports = new ArrayList<Integer>();
            }
            for (int element : elements) {
                this.ports.add(Objects.requireNonNull(Integer.valueOf(element), "ports element"));
            }
            return this;
        }

        public final Builder route(Route element) {
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
            }
            this.routes.add(Objects.requireNonNull(element, "routes element"));
            return this;
        }

        public final Builder routes(Route ... elements) {
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
            }
            for (Route element : elements) {
                this.routes.add(Objects.requireNonNull(element, "routes element"));
            }
            return this;
        }

        @JsonProperty(value="routes")
        public final Builder routes(@Nullable Iterable<? extends Route> elements) {
            if (elements == null) {
                this.routes = null;
                return this;
            }
            this.routes = new ArrayList<Route>();
            return this.addAllRoutes(elements);
        }

        public final Builder addAllRoutes(Iterable<? extends Route> elements) {
            Objects.requireNonNull(elements, "routes element");
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
            }
            for (Route route : elements) {
                this.routes.add(Objects.requireNonNull(route, "routes element"));
            }
            return this;
        }

        @JsonProperty(value="running_instances")
        public final Builder runningInstances(@Nullable Integer runningInstances) {
            this.runningInstances = runningInstances;
            return this;
        }

        @JsonProperty(value="service_count")
        public final Builder serviceCount(@Nullable Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        public final Builder serviceName(String element) {
            this.serviceNames.add(Objects.requireNonNull(element, "serviceNames element"));
            return this;
        }

        public final Builder serviceNames(String ... elements) {
            for (String element : elements) {
                this.serviceNames.add(Objects.requireNonNull(element, "serviceNames element"));
            }
            return this;
        }

        @JsonProperty(value="service_names")
        public final Builder serviceNames(Iterable<String> elements) {
            this.serviceNames.clear();
            return this.addAllServiceNames(elements);
        }

        public final Builder addAllServiceNames(Iterable<String> elements) {
            for (String element : elements) {
                this.serviceNames.add(Objects.requireNonNull(element, "serviceNames element"));
            }
            return this;
        }

        public final Builder url(String element) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            this.urls.add(Objects.requireNonNull(element, "urls element"));
            return this;
        }

        public final Builder urls(String ... elements) {
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        @JsonProperty(value="urls")
        public final Builder urls(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.urls = null;
                return this;
            }
            this.urls = new ArrayList<String>();
            return this.addAllUrls(elements);
        }

        public final Builder addAllUrls(Iterable<String> elements) {
            Objects.requireNonNull(elements, "urls element");
            if (this.urls == null) {
                this.urls = new ArrayList<String>();
            }
            for (String element : elements) {
                this.urls.add(Objects.requireNonNull(element, "urls element"));
            }
            return this;
        }

        @JsonProperty(value="version")
        public final Builder version(@Nullable String version) {
            this.version = version;
            return this;
        }

        @JsonProperty(value="buildpack")
        public final Builder buildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        @JsonProperty(value="command")
        public final Builder command(@Nullable String command) {
            this.command = command;
            return this;
        }

        @JsonProperty(value="console")
        @Deprecated
        public final Builder console(@Nullable Boolean console) {
            this.console = console;
            return this;
        }

        @JsonProperty(value="debug")
        @Deprecated
        public final Builder debug(@Nullable String debug) {
            this.debug = debug;
            return this;
        }

        @JsonProperty(value="detected_start_command")
        public final Builder detectedStartCommand(@Nullable String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        @JsonProperty(value="diego")
        public final Builder diego(@Nullable Boolean diego) {
            this.diego = diego;
            return this;
        }

        @JsonProperty(value="disk_quota")
        public final Builder diskQuota(@Nullable Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @JsonProperty(value="docker_credentials")
        public final Builder dockerCredentials(@Nullable DockerCredentials dockerCredentials) {
            this.dockerCredentials = dockerCredentials;
            return this;
        }

        @JsonProperty(value="docker_image")
        public final Builder dockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        public final Builder environmentJson(String key, Object value) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            this.environmentJsons.put(key, value);
            return this;
        }

        public final Builder environmentJson(Map.Entry<String, ? extends Object> entry) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            Object v = entry.getValue();
            this.environmentJsons.put(k, v);
            return this;
        }

        @JsonProperty(value="environment_json")
        public final Builder environmentJsons(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.environmentJsons = null;
                return this;
            }
            this.environmentJsons = new LinkedHashMap<String, Object>();
            return this.putAllEnvironmentJsons(entries);
        }

        public final Builder putAllEnvironmentJsons(Map<String, ? extends Object> entries) {
            if (this.environmentJsons == null) {
                this.environmentJsons = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.environmentJsons.put(k, v);
            }
            return this;
        }

        @JsonProperty(value="health_check_http_endpoint")
        public final Builder healthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
            return this;
        }

        @JsonProperty(value="health_check_timeout")
        public final Builder healthCheckTimeout(@Nullable Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        @JsonProperty(value="health_check_type")
        public final Builder healthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        @JsonProperty(value="instances")
        public final Builder instances(@Nullable Integer instances) {
            this.instances = instances;
            return this;
        }

        @JsonProperty(value="memory")
        public final Builder memory(@Nullable Integer memory) {
            this.memory = memory;
            return this;
        }

        @JsonProperty(value="name")
        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="production")
        @Deprecated
        public final Builder production(@Nullable Boolean production) {
            this.production = production;
            return this;
        }

        @JsonProperty(value="space_guid")
        public final Builder spaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @JsonProperty(value="stack_guid")
        public final Builder stackId(@Nullable String stackId) {
            this.stackId = stackId;
            return this;
        }

        @JsonProperty(value="staging_failed_description")
        public final Builder stagingFailedDescription(@Nullable String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
            return this;
        }

        @JsonProperty(value="staging_failed_reason")
        public final Builder stagingFailedReason(@Nullable String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
            return this;
        }

        @JsonProperty(value="staging_task_id")
        public final Builder stagingTaskId(@Nullable String stagingTaskId) {
            this.stagingTaskId = stagingTaskId;
            return this;
        }

        @JsonProperty(value="state")
        public final Builder state(@Nullable String state) {
            this.state = state;
            return this;
        }

        public SpaceApplicationSummary build() {
            return new SpaceApplicationSummary(this);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_SpaceApplicationSummary", generator="Immutables")
    static final class Json
    extends _SpaceApplicationSummary {
        String detectedBuildpack;
        String detectedBuildpackId;
        Boolean enableSsh;
        String id;
        String packageState;
        String packageUpdatedAt;
        List<Integer> ports = null;
        List<Route> routes = null;
        Integer runningInstances;
        Integer serviceCount;
        List<String> serviceNames = Collections.emptyList();
        List<String> urls = null;
        String version;
        String buildpack;
        String command;
        Boolean console;
        String debug;
        String detectedStartCommand;
        Boolean diego;
        Integer diskQuota;
        DockerCredentials dockerCredentials;
        String dockerImage;
        Map<String, Object> environmentJsons = null;
        String healthCheckHttpEndpoint;
        Integer healthCheckTimeout;
        String healthCheckType;
        Integer instances;
        Integer memory;
        String name;
        Boolean production;
        String spaceId;
        String stackId;
        String stagingFailedDescription;
        String stagingFailedReason;
        String stagingTaskId;
        String state;

        Json() {
        }

        @JsonProperty(value="detected_buildpack")
        public void setDetectedBuildpack(@Nullable String detectedBuildpack) {
            this.detectedBuildpack = detectedBuildpack;
        }

        @JsonProperty(value="detected_buildpack_guid")
        public void setDetectedBuildpackId(@Nullable String detectedBuildpackId) {
            this.detectedBuildpackId = detectedBuildpackId;
        }

        @JsonProperty(value="enable_ssh")
        public void setEnableSsh(@Nullable Boolean enableSsh) {
            this.enableSsh = enableSsh;
        }

        @JsonProperty(value="guid")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="package_state")
        public void setPackageState(@Nullable String packageState) {
            this.packageState = packageState;
        }

        @JsonProperty(value="package_updated_at")
        public void setPackageUpdatedAt(@Nullable String packageUpdatedAt) {
            this.packageUpdatedAt = packageUpdatedAt;
        }

        @JsonProperty(value="ports")
        public void setPorts(@Nullable List<Integer> ports) {
            this.ports = ports;
        }

        @JsonProperty(value="routes")
        public void setRoutes(@Nullable List<Route> routes) {
            this.routes = routes;
        }

        @JsonProperty(value="running_instances")
        public void setRunningInstances(@Nullable Integer runningInstances) {
            this.runningInstances = runningInstances;
        }

        @JsonProperty(value="service_count")
        public void setServiceCount(@Nullable Integer serviceCount) {
            this.serviceCount = serviceCount;
        }

        @JsonProperty(value="service_names")
        public void setServiceNames(List<String> serviceNames) {
            this.serviceNames = serviceNames;
        }

        @JsonProperty(value="urls")
        public void setUrls(@Nullable List<String> urls) {
            this.urls = urls;
        }

        @JsonProperty(value="version")
        public void setVersion(@Nullable String version) {
            this.version = version;
        }

        @JsonProperty(value="buildpack")
        public void setBuildpack(@Nullable String buildpack) {
            this.buildpack = buildpack;
        }

        @JsonProperty(value="command")
        public void setCommand(@Nullable String command) {
            this.command = command;
        }

        @JsonProperty(value="console")
        public void setConsole(@Nullable Boolean console) {
            this.console = console;
        }

        @JsonProperty(value="debug")
        public void setDebug(@Nullable String debug) {
            this.debug = debug;
        }

        @JsonProperty(value="detected_start_command")
        public void setDetectedStartCommand(@Nullable String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
        }

        @JsonProperty(value="diego")
        public void setDiego(@Nullable Boolean diego) {
            this.diego = diego;
        }

        @JsonProperty(value="disk_quota")
        public void setDiskQuota(@Nullable Integer diskQuota) {
            this.diskQuota = diskQuota;
        }

        @JsonProperty(value="docker_credentials")
        public void setDockerCredentials(@Nullable DockerCredentials dockerCredentials) {
            this.dockerCredentials = dockerCredentials;
        }

        @JsonProperty(value="docker_image")
        public void setDockerImage(@Nullable String dockerImage) {
            this.dockerImage = dockerImage;
        }

        @JsonProperty(value="environment_json")
        public void setEnvironmentJsons(@Nullable Map<String, Object> environmentJsons) {
            this.environmentJsons = environmentJsons;
        }

        @JsonProperty(value="health_check_http_endpoint")
        public void setHealthCheckHttpEndpoint(@Nullable String healthCheckHttpEndpoint) {
            this.healthCheckHttpEndpoint = healthCheckHttpEndpoint;
        }

        @JsonProperty(value="health_check_timeout")
        public void setHealthCheckTimeout(@Nullable Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
        }

        @JsonProperty(value="health_check_type")
        public void setHealthCheckType(@Nullable String healthCheckType) {
            this.healthCheckType = healthCheckType;
        }

        @JsonProperty(value="instances")
        public void setInstances(@Nullable Integer instances) {
            this.instances = instances;
        }

        @JsonProperty(value="memory")
        public void setMemory(@Nullable Integer memory) {
            this.memory = memory;
        }

        @JsonProperty(value="name")
        public void setName(@Nullable String name) {
            this.name = name;
        }

        @JsonProperty(value="production")
        public void setProduction(@Nullable Boolean production) {
            this.production = production;
        }

        @JsonProperty(value="space_guid")
        public void setSpaceId(@Nullable String spaceId) {
            this.spaceId = spaceId;
        }

        @JsonProperty(value="stack_guid")
        public void setStackId(@Nullable String stackId) {
            this.stackId = stackId;
        }

        @JsonProperty(value="staging_failed_description")
        public void setStagingFailedDescription(@Nullable String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
        }

        @JsonProperty(value="staging_failed_reason")
        public void setStagingFailedReason(@Nullable String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
        }

        @JsonProperty(value="staging_task_id")
        public void setStagingTaskId(@Nullable String stagingTaskId) {
            this.stagingTaskId = stagingTaskId;
        }

        @JsonProperty(value="state")
        public void setState(@Nullable String state) {
            this.state = state;
        }

        @Override
        public String getDetectedBuildpack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDetectedBuildpackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getEnableSsh() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPackageState() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPackageUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Integer> getPorts() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Route> getRoutes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getRunningInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getServiceCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUrls() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBuildpack() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getConsole() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDebug() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDetectedStartCommand() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getDiego() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getDiskQuota() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DockerCredentials getDockerCredentials() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDockerImage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getEnvironmentJsons() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHealthCheckHttpEndpoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getHealthCheckTimeout() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getHealthCheckType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getInstances() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean getProduction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpaceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStagingFailedDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStagingFailedReason() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getStagingTaskId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getState() {
            throw new UnsupportedOperationException();
        }
    }
}

