/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Lifecycle;
import org.cloudfoundry.client.v3.Metadata;
import org.cloudfoundry.client.v3.applications.ApplicationRelationships;
import org.cloudfoundry.client.v3.applications._CreateApplicationRequest;
import org.immutables.value.Generated;

@Generated(from="_CreateApplicationRequest", generator="Immutables")
public final class CreateApplicationRequest
extends _CreateApplicationRequest {
    @Nullable
    private final Map<String, String> environmentVariables;
    @Nullable
    private final Lifecycle lifecycle;
    @Nullable
    private final Metadata metadata;
    private final String name;
    private final ApplicationRelationships relationships;

    private CreateApplicationRequest(Builder builder) {
        this.environmentVariables = builder.environmentVariables == null ? null : CreateApplicationRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.lifecycle = builder.lifecycle;
        this.metadata = builder.metadata;
        this.name = builder.name;
        this.relationships = builder.relationships;
    }

    @Override
    @JsonProperty(value="environment_variables")
    @Nullable
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    @JsonProperty(value="lifecycle")
    @Nullable
    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    @Override
    @JsonProperty(value="metadata")
    @Nullable
    public Metadata getMetadata() {
        return this.metadata;
    }

    @Override
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="relationships")
    public ApplicationRelationships getRelationships() {
        return this.relationships;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CreateApplicationRequest && this.equalTo((CreateApplicationRequest)another);
    }

    private boolean equalTo(CreateApplicationRequest another) {
        return Objects.equals(this.environmentVariables, another.environmentVariables) && Objects.equals(this.lifecycle, another.lifecycle) && Objects.equals(this.metadata, another.metadata) && this.name.equals(another.name) && this.relationships.equals(another.relationships);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.environmentVariables);
        h += (h << 5) + Objects.hashCode(this.lifecycle);
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.relationships.hashCode();
        return h;
    }

    public String toString() {
        return "CreateApplicationRequest{environmentVariables=" + this.environmentVariables + ", lifecycle=" + this.lifecycle + ", metadata=" + this.metadata + ", name=" + this.name + ", relationships=" + this.relationships + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CreateApplicationRequest fromJson(Json json) {
        Builder builder = CreateApplicationRequest.builder();
        if (json.environmentVariables != null) {
            builder.putAllEnvironmentVariables(json.environmentVariables);
        }
        if (json.lifecycle != null) {
            builder.lifecycle(json.lifecycle);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.name != null) {
            builder.name(json.name);
        }
        if (json.relationships != null) {
            builder.relationships(json.relationships);
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="_CreateApplicationRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_RELATIONSHIPS = 2L;
        private long initBits = 3L;
        private Map<String, String> environmentVariables = null;
        private Lifecycle lifecycle;
        private Metadata metadata;
        private String name;
        private ApplicationRelationships relationships;

        private Builder() {
        }

        public final Builder from(CreateApplicationRequest instance) {
            return this.from((_CreateApplicationRequest)instance);
        }

        final Builder from(_CreateApplicationRequest instance) {
            Metadata metadataValue;
            Lifecycle lifecycleValue;
            Objects.requireNonNull(instance, "instance");
            Map<String, String> environmentVariablesValue = instance.getEnvironmentVariables();
            if (environmentVariablesValue != null) {
                this.putAllEnvironmentVariables(environmentVariablesValue);
            }
            if ((lifecycleValue = instance.getLifecycle()) != null) {
                this.lifecycle(lifecycleValue);
            }
            if ((metadataValue = instance.getMetadata()) != null) {
                this.metadata(metadataValue);
            }
            this.name(instance.getName());
            this.relationships(instance.getRelationships());
            return this;
        }

        public final Builder environmentVariable(String key, String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder environmentVariable(Map.Entry<String, ? extends String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        public final Builder environmentVariables(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.environmentVariables = null;
                return this;
            }
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(entries);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends String> entries) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public final Builder lifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final Builder metadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationships(ApplicationRelationships relationships) {
            this.relationships = Objects.requireNonNull(relationships, "relationships");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CreateApplicationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CreateApplicationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("relationships");
            }
            return "Cannot build CreateApplicationRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="_CreateApplicationRequest", generator="Immutables")
    static final class Json
    extends _CreateApplicationRequest {
        Map<String, String> environmentVariables = null;
        Lifecycle lifecycle;
        Metadata metadata;
        String name;
        ApplicationRelationships relationships;

        Json() {
        }

        @JsonProperty(value="environment_variables")
        public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
        }

        @JsonProperty(value="lifecycle")
        public void setLifecycle(@Nullable Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
        }

        @JsonProperty(value="metadata")
        public void setMetadata(@Nullable Metadata metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="name")
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty(value="relationships")
        public void setRelationships(ApplicationRelationships relationships) {
            this.relationships = relationships;
        }

        @Override
        public Map<String, String> getEnvironmentVariables() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Lifecycle getLifecycle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Metadata getMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ApplicationRelationships getRelationships() {
            throw new UnsupportedOperationException();
        }
    }
}

