/*
 * Decompiled with CFR 0.152.
 */
package org.cloudfoundry.uaa.clients;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.uaa.clients.AbstractUpdateClient;
import org.cloudfoundry.uaa.clients._UpdateClientAction;
import org.cloudfoundry.uaa.tokens.GrantType;
import org.immutables.value.Generated;

@Generated(from="_UpdateClientAction", generator="Immutables")
public final class UpdateClientAction
extends _UpdateClientAction {
    private final transient String action;
    @Nullable
    private final List<String> allowedProviders;
    @Nullable
    private final Boolean approvalsDeleted;
    @Nullable
    private final List<String> authorities;
    @Nullable
    private final List<GrantType> authorizedGrantTypes;
    @Nullable
    private final List<String> autoApproves;
    private final String clientId;
    @Nullable
    private final String createdWith;
    @Nullable
    private final String name;
    @Nullable
    private final List<String> redirectUriPatterns;
    @Nullable
    private final List<String> resourceIds;
    @Nullable
    private final List<String> scopes;
    @Nullable
    private final String tokenSalt;

    private UpdateClientAction(Builder builder) {
        this.allowedProviders = builder.allowedProviders == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.allowedProviders);
        this.approvalsDeleted = builder.approvalsDeleted;
        this.authorities = builder.authorities == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.authorities);
        this.authorizedGrantTypes = builder.authorizedGrantTypes == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.authorizedGrantTypes);
        this.autoApproves = builder.autoApproves == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.autoApproves);
        this.clientId = builder.clientId;
        this.createdWith = builder.createdWith;
        this.name = builder.name;
        this.redirectUriPatterns = builder.redirectUriPatterns == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.redirectUriPatterns);
        this.resourceIds = builder.resourceIds == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.resourceIds);
        this.scopes = builder.scopes == null ? null : UpdateClientAction.createUnmodifiableList(true, builder.scopes);
        this.tokenSalt = builder.tokenSalt;
        this.action = Objects.requireNonNull(super.getAction(), "action");
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    @Nullable
    public List<String> getAllowedProviders() {
        return this.allowedProviders;
    }

    @Override
    @Nullable
    public Boolean getApprovalsDeleted() {
        return this.approvalsDeleted;
    }

    @Override
    @Nullable
    public List<String> getAuthorities() {
        return this.authorities;
    }

    @Override
    @Nullable
    public List<GrantType> getAuthorizedGrantTypes() {
        return this.authorizedGrantTypes;
    }

    @Override
    @Nullable
    public List<String> getAutoApproves() {
        return this.autoApproves;
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nullable
    public String getCreatedWith() {
        return this.createdWith;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public List<String> getRedirectUriPatterns() {
        return this.redirectUriPatterns;
    }

    @Override
    @Nullable
    public List<String> getResourceIds() {
        return this.resourceIds;
    }

    @Override
    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    @Nullable
    public String getTokenSalt() {
        return this.tokenSalt;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UpdateClientAction && this.equalTo((UpdateClientAction)another);
    }

    private boolean equalTo(UpdateClientAction another) {
        return this.action.equals(another.action) && Objects.equals(this.allowedProviders, another.allowedProviders) && Objects.equals(this.approvalsDeleted, another.approvalsDeleted) && Objects.equals(this.authorities, another.authorities) && Objects.equals(this.authorizedGrantTypes, another.authorizedGrantTypes) && Objects.equals(this.autoApproves, another.autoApproves) && this.clientId.equals(another.clientId) && Objects.equals(this.createdWith, another.createdWith) && Objects.equals(this.name, another.name) && Objects.equals(this.redirectUriPatterns, another.redirectUriPatterns) && Objects.equals(this.resourceIds, another.resourceIds) && Objects.equals(this.scopes, another.scopes) && Objects.equals(this.tokenSalt, another.tokenSalt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.action.hashCode();
        h += (h << 5) + Objects.hashCode(this.allowedProviders);
        h += (h << 5) + Objects.hashCode(this.approvalsDeleted);
        h += (h << 5) + Objects.hashCode(this.authorities);
        h += (h << 5) + Objects.hashCode(this.authorizedGrantTypes);
        h += (h << 5) + Objects.hashCode(this.autoApproves);
        h += (h << 5) + this.clientId.hashCode();
        h += (h << 5) + Objects.hashCode(this.createdWith);
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + Objects.hashCode(this.redirectUriPatterns);
        h += (h << 5) + Objects.hashCode(this.resourceIds);
        h += (h << 5) + Objects.hashCode(this.scopes);
        h += (h << 5) + Objects.hashCode(this.tokenSalt);
        return h;
    }

    public String toString() {
        return "UpdateClientAction{action=" + this.action + ", allowedProviders=" + this.allowedProviders + ", approvalsDeleted=" + this.approvalsDeleted + ", authorities=" + this.authorities + ", authorizedGrantTypes=" + this.authorizedGrantTypes + ", autoApproves=" + this.autoApproves + ", clientId=" + this.clientId + ", createdWith=" + this.createdWith + ", name=" + this.name + ", redirectUriPatterns=" + this.redirectUriPatterns + ", resourceIds=" + this.resourceIds + ", scopes=" + this.scopes + ", tokenSalt=" + this.tokenSalt + "}";
    }

    private static UpdateClientAction validate(UpdateClientAction instance) {
        instance.checkAuthorizedGrantType();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="_UpdateClientAction", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_CLIENT_ID = 1L;
        private long initBits = 1L;
        private List<String> allowedProviders = null;
        private Boolean approvalsDeleted;
        private List<String> authorities = null;
        private List<GrantType> authorizedGrantTypes = null;
        private List<String> autoApproves = null;
        private String clientId;
        private String createdWith;
        private String name;
        private List<String> redirectUriPatterns = null;
        private List<String> resourceIds = null;
        private List<String> scopes = null;
        private String tokenSalt;

        private Builder() {
        }

        public final Builder from(AbstractUpdateClient instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(UpdateClientAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(_UpdateClientAction instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof AbstractUpdateClient) {
                List<String> resourceIdsValue;
                List<String> authoritiesValue;
                List<String> allowedProvidersValue;
                List<String> autoApprovesValue;
                List<String> scopesValue;
                Boolean approvalsDeletedValue;
                String nameValue;
                List<String> redirectUriPatternsValue;
                String tokenSaltValue;
                AbstractUpdateClient instance = (AbstractUpdateClient)object;
                List<GrantType> authorizedGrantTypesValue = instance.getAuthorizedGrantTypes();
                if (authorizedGrantTypesValue != null) {
                    this.addAllAuthorizedGrantTypes(authorizedGrantTypesValue);
                }
                if ((tokenSaltValue = instance.getTokenSalt()) != null) {
                    this.tokenSalt(tokenSaltValue);
                }
                this.clientId(instance.getClientId());
                String createdWithValue = instance.getCreatedWith();
                if (createdWithValue != null) {
                    this.createdWith(createdWithValue);
                }
                if ((redirectUriPatternsValue = instance.getRedirectUriPatterns()) != null) {
                    this.addAllRedirectUriPatterns(redirectUriPatternsValue);
                }
                if ((nameValue = instance.getName()) != null) {
                    this.name(nameValue);
                }
                if ((approvalsDeletedValue = instance.getApprovalsDeleted()) != null) {
                    this.approvalsDeleted(approvalsDeletedValue);
                }
                if ((scopesValue = instance.getScopes()) != null) {
                    this.addAllScopes(scopesValue);
                }
                if ((autoApprovesValue = instance.getAutoApproves()) != null) {
                    this.addAllAutoApproves(autoApprovesValue);
                }
                if ((allowedProvidersValue = instance.getAllowedProviders()) != null) {
                    this.addAllAllowedProviders(allowedProvidersValue);
                }
                if ((authoritiesValue = instance.getAuthorities()) != null) {
                    this.addAllAuthorities(authoritiesValue);
                }
                if ((resourceIdsValue = instance.getResourceIds()) != null) {
                    this.addAllResourceIds(resourceIdsValue);
                }
            }
        }

        public final Builder allowedProvider(String element) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            return this;
        }

        public final Builder allowedProviders(String ... elements) {
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder allowedProviders(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.allowedProviders = null;
                return this;
            }
            this.allowedProviders = new ArrayList<String>();
            return this.addAllAllowedProviders(elements);
        }

        public final Builder addAllAllowedProviders(Iterable<String> elements) {
            Objects.requireNonNull(elements, "allowedProviders element");
            if (this.allowedProviders == null) {
                this.allowedProviders = new ArrayList<String>();
            }
            for (String element : elements) {
                this.allowedProviders.add(Objects.requireNonNull(element, "allowedProviders element"));
            }
            return this;
        }

        public final Builder approvalsDeleted(@Nullable Boolean approvalsDeleted) {
            this.approvalsDeleted = approvalsDeleted;
            return this;
        }

        public final Builder authority(String element) {
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            return this;
        }

        public final Builder authorities(String ... elements) {
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorities(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.authorities = null;
                return this;
            }
            this.authorities = new ArrayList<String>();
            return this.addAllAuthorities(elements);
        }

        public final Builder addAllAuthorities(Iterable<String> elements) {
            Objects.requireNonNull(elements, "authorities element");
            if (this.authorities == null) {
                this.authorities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.authorities.add(Objects.requireNonNull(element, "authorities element"));
            }
            return this;
        }

        public final Builder authorizedGrantType(GrantType element) {
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            return this;
        }

        public final Builder authorizedGrantTypes(GrantType ... elements) {
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            for (GrantType element : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(element, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder authorizedGrantTypes(@Nullable Iterable<? extends GrantType> elements) {
            if (elements == null) {
                this.authorizedGrantTypes = null;
                return this;
            }
            this.authorizedGrantTypes = new ArrayList<GrantType>();
            return this.addAllAuthorizedGrantTypes(elements);
        }

        public final Builder addAllAuthorizedGrantTypes(Iterable<? extends GrantType> elements) {
            Objects.requireNonNull(elements, "authorizedGrantTypes element");
            if (this.authorizedGrantTypes == null) {
                this.authorizedGrantTypes = new ArrayList<GrantType>();
            }
            for (GrantType grantType : elements) {
                this.authorizedGrantTypes.add(Objects.requireNonNull(grantType, "authorizedGrantTypes element"));
            }
            return this;
        }

        public final Builder autoApprove(String element) {
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            return this;
        }

        public final Builder autoApproves(String ... elements) {
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder autoApproves(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.autoApproves = null;
                return this;
            }
            this.autoApproves = new ArrayList<String>();
            return this.addAllAutoApproves(elements);
        }

        public final Builder addAllAutoApproves(Iterable<String> elements) {
            Objects.requireNonNull(elements, "autoApproves element");
            if (this.autoApproves == null) {
                this.autoApproves = new ArrayList<String>();
            }
            for (String element : elements) {
                this.autoApproves.add(Objects.requireNonNull(element, "autoApproves element"));
            }
            return this;
        }

        public final Builder clientId(String clientId) {
            this.clientId = Objects.requireNonNull(clientId, "clientId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder createdWith(@Nullable String createdWith) {
            this.createdWith = createdWith;
            return this;
        }

        public final Builder name(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder redirectUriPattern(String element) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            return this;
        }

        public final Builder redirectUriPatterns(String ... elements) {
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder redirectUriPatterns(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.redirectUriPatterns = null;
                return this;
            }
            this.redirectUriPatterns = new ArrayList<String>();
            return this.addAllRedirectUriPatterns(elements);
        }

        public final Builder addAllRedirectUriPatterns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "redirectUriPatterns element");
            if (this.redirectUriPatterns == null) {
                this.redirectUriPatterns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.redirectUriPatterns.add(Objects.requireNonNull(element, "redirectUriPatterns element"));
            }
            return this;
        }

        public final Builder resourceId(String element) {
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            return this;
        }

        public final Builder resourceIds(String ... elements) {
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder resourceIds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.resourceIds = null;
                return this;
            }
            this.resourceIds = new ArrayList<String>();
            return this.addAllResourceIds(elements);
        }

        public final Builder addAllResourceIds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "resourceIds element");
            if (this.resourceIds == null) {
                this.resourceIds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.resourceIds.add(Objects.requireNonNull(element, "resourceIds element"));
            }
            return this;
        }

        public final Builder scope(String element) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            return this;
        }

        public final Builder scopes(String ... elements) {
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder scopes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.scopes = null;
                return this;
            }
            this.scopes = new ArrayList<String>();
            return this.addAllScopes(elements);
        }

        public final Builder addAllScopes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "scopes element");
            if (this.scopes == null) {
                this.scopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.scopes.add(Objects.requireNonNull(element, "scopes element"));
            }
            return this;
        }

        public final Builder tokenSalt(@Nullable String tokenSalt) {
            this.tokenSalt = tokenSalt;
            return this;
        }

        public UpdateClientAction build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return UpdateClientAction.validate(new UpdateClientAction(this));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("clientId");
            }
            return "Cannot build UpdateClientAction, some of required attributes are not set " + attributes;
        }
    }
}

