package org.cloudfoundry.client.v2.applications;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Request payload for the Upload Application Droplet operation.
 */
@Generated(from = "_UploadApplicationDropletRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UploadApplicationDropletRequest
    extends org.cloudfoundry.client.v2.applications._UploadApplicationDropletRequest {
  private final String applicationId;
  private final Path droplet;

  private UploadApplicationDropletRequest(UploadApplicationDropletRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.droplet = builder.droplet;
  }

  /**
   * The application id
   */
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * A tgz droplet file
   */
  @Override
  public Path getDroplet() {
    return droplet;
  }

  /**
   * This instance is equal to all instances of {@code UploadApplicationDropletRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UploadApplicationDropletRequest
        && equalTo((UploadApplicationDropletRequest) another);
  }

  private boolean equalTo(UploadApplicationDropletRequest another) {
    return applicationId.equals(another.applicationId)
        && droplet.equals(another.droplet);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code droplet}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + droplet.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UploadApplicationDropletRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UploadApplicationDropletRequest{"
        + "applicationId=" + applicationId
        + ", droplet=" + droplet
        + "}";
  }

  /**
   * Creates a builder for {@link UploadApplicationDropletRequest UploadApplicationDropletRequest}.
   * <pre>
   * UploadApplicationDropletRequest.builder()
   *    .applicationId(String) // required {@link UploadApplicationDropletRequest#getApplicationId() applicationId}
   *    .droplet(java.nio.file.Path) // required {@link UploadApplicationDropletRequest#getDroplet() droplet}
   *    .build();
   * </pre>
   * @return A new UploadApplicationDropletRequest builder
   */
  public static UploadApplicationDropletRequest.Builder builder() {
    return new UploadApplicationDropletRequest.Builder();
  }

  /**
   * Builds instances of type {@link UploadApplicationDropletRequest UploadApplicationDropletRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UploadApplicationDropletRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_DROPLET = 0x2L;
    private long initBits = 0x3L;

    private String applicationId;
    private Path droplet;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UploadApplicationDropletRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UploadApplicationDropletRequest instance) {
      return from((_UploadApplicationDropletRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UploadApplicationDropletRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UploadApplicationDropletRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      droplet(instance.getDroplet());
      return this;
    }

    /**
     * Initializes the value for the {@link UploadApplicationDropletRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UploadApplicationDropletRequest#getDroplet() droplet} attribute.
     * @param droplet The value for droplet 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder droplet(Path droplet) {
      this.droplet = Objects.requireNonNull(droplet, "droplet");
      initBits &= ~INIT_BIT_DROPLET;
      return this;
    }

    /**
     * Builds a new {@link UploadApplicationDropletRequest UploadApplicationDropletRequest}.
     * @return An immutable instance of UploadApplicationDropletRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UploadApplicationDropletRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UploadApplicationDropletRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_DROPLET) != 0) attributes.add("droplet");
      return "Cannot build UploadApplicationDropletRequest, some of required attributes are not set " + attributes;
    }
  }
}
