package org.cloudfoundry.client.v2.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.cloudfoundry.Nullable;
import org.immutables.value.Generated;

/**
 * The entity response payload for the Event resource
 */
@Generated(from = "_EventEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class EventEntity extends org.cloudfoundry.client.v2.events._EventEntity {
  private final @Nullable String actee;
  private final @Nullable String acteeName;
  private final @Nullable String acteeType;
  private final @Nullable String actor;
  private final @Nullable String actorName;
  private final @Nullable String actorType;
  private final @Nullable String actorUserName;
  private final @Nullable Map<String, Optional<Object>> metadatas;
  private final @Nullable String organizationId;
  private final @Nullable String spaceId;
  private final @Nullable String timestamp;
  private final @Nullable String type;

  private EventEntity(EventEntity.Builder builder) {
    this.actee = builder.actee;
    this.acteeName = builder.acteeName;
    this.acteeType = builder.acteeType;
    this.actor = builder.actor;
    this.actorName = builder.actorName;
    this.actorType = builder.actorType;
    this.actorUserName = builder.actorUserName;
    this.metadatas = builder.metadatas == null ? null : createUnmodifiableMap(false, false, builder.metadatas);
    this.organizationId = builder.organizationId;
    this.spaceId = builder.spaceId;
    this.timestamp = builder.timestamp;
    this.type = builder.type;
  }

  /**
   * The actee
   */
  @JsonProperty("actee")
  @Override
  public @Nullable String getActee() {
    return actee;
  }

  /**
   * The actee name
   */
  @JsonProperty("actee_name")
  @Override
  public @Nullable String getActeeName() {
    return acteeName;
  }

  /**
   * The actee type
   */
  @JsonProperty("actee_type")
  @Override
  public @Nullable String getActeeType() {
    return acteeType;
  }

  /**
   * The actor
   */
  @JsonProperty("actor")
  @Override
  public @Nullable String getActor() {
    return actor;
  }

  /**
   * The actor name
   */
  @JsonProperty("actor_name")
  @Override
  public @Nullable String getActorName() {
    return actorName;
  }

  /**
   * The actor type
   */
  @JsonProperty("actor_type")
  @Override
  public @Nullable String getActorType() {
    return actorType;
  }

  /**
   * The actor name
   */
  @JsonProperty("actor_username")
  @Override
  public @Nullable String getActorUserName() {
    return actorUserName;
  }

  /**
   * The metadatas
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Map<String, Optional<Object>> getMetadatas() {
    return metadatas;
  }

  /**
   * The organization id
   */
  @JsonProperty("organization_guid")
  @Override
  public @Nullable String getOrganizationId() {
    return organizationId;
  }

  /**
   * The space id
   */
  @JsonProperty("space_guid")
  @Override
  public @Nullable String getSpaceId() {
    return spaceId;
  }

  /**
   * The timestamp
   */
  @JsonProperty("timestamp")
  @Override
  public @Nullable String getTimestamp() {
    return timestamp;
  }

  /**
   * The type
   */
  @JsonProperty("type")
  @Override
  public @Nullable String getType() {
    return type;
  }

  /**
   * This instance is equal to all instances of {@code EventEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof EventEntity
        && equalTo((EventEntity) another);
  }

  private boolean equalTo(EventEntity another) {
    return Objects.equals(actee, another.actee)
        && Objects.equals(acteeName, another.acteeName)
        && Objects.equals(acteeType, another.acteeType)
        && Objects.equals(actor, another.actor)
        && Objects.equals(actorName, another.actorName)
        && Objects.equals(actorType, another.actorType)
        && Objects.equals(actorUserName, another.actorUserName)
        && Objects.equals(metadatas, another.metadatas)
        && Objects.equals(organizationId, another.organizationId)
        && Objects.equals(spaceId, another.spaceId)
        && Objects.equals(timestamp, another.timestamp)
        && Objects.equals(type, another.type);
  }

  /**
   * Computes a hash code from attributes: {@code actee}, {@code acteeName}, {@code acteeType}, {@code actor}, {@code actorName}, {@code actorType}, {@code actorUserName}, {@code metadatas}, {@code organizationId}, {@code spaceId}, {@code timestamp}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(actee);
    h += (h << 5) + Objects.hashCode(acteeName);
    h += (h << 5) + Objects.hashCode(acteeType);
    h += (h << 5) + Objects.hashCode(actor);
    h += (h << 5) + Objects.hashCode(actorName);
    h += (h << 5) + Objects.hashCode(actorType);
    h += (h << 5) + Objects.hashCode(actorUserName);
    h += (h << 5) + Objects.hashCode(metadatas);
    h += (h << 5) + Objects.hashCode(organizationId);
    h += (h << 5) + Objects.hashCode(spaceId);
    h += (h << 5) + Objects.hashCode(timestamp);
    h += (h << 5) + Objects.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code EventEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EventEntity{"
        + "actee=" + actee
        + ", acteeName=" + acteeName
        + ", acteeType=" + acteeType
        + ", actor=" + actor
        + ", actorName=" + actorName
        + ", actorType=" + actorType
        + ", actorUserName=" + actorUserName
        + ", metadatas=" + metadatas
        + ", organizationId=" + organizationId
        + ", spaceId=" + spaceId
        + ", timestamp=" + timestamp
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_EventEntity", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v2.events._EventEntity {
    String actee;
    String acteeName;
    String acteeType;
    String actor;
    String actorName;
    String actorType;
    String actorUserName;
    Map<String, Optional<Object>> metadatas = null;
    String organizationId;
    String spaceId;
    String timestamp;
    String type;
    @JsonProperty("actee")
    public void setActee(@Nullable String actee) {
      this.actee = actee;
    }
    @JsonProperty("actee_name")
    public void setActeeName(@Nullable String acteeName) {
      this.acteeName = acteeName;
    }
    @JsonProperty("actee_type")
    public void setActeeType(@Nullable String acteeType) {
      this.acteeType = acteeType;
    }
    @JsonProperty("actor")
    public void setActor(@Nullable String actor) {
      this.actor = actor;
    }
    @JsonProperty("actor_name")
    public void setActorName(@Nullable String actorName) {
      this.actorName = actorName;
    }
    @JsonProperty("actor_type")
    public void setActorType(@Nullable String actorType) {
      this.actorType = actorType;
    }
    @JsonProperty("actor_username")
    public void setActorUserName(@Nullable String actorUserName) {
      this.actorUserName = actorUserName;
    }
    @JsonProperty("metadata")
    public void setMetadatas(@Nullable Map<String, Optional<Object>> metadatas) {
      this.metadatas = metadatas;
    }
    @JsonProperty("organization_guid")
    public void setOrganizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
    }
    @JsonProperty("space_guid")
    public void setSpaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
    }
    @JsonProperty("timestamp")
    public void setTimestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
    }
    @JsonProperty("type")
    public void setType(@Nullable String type) {
      this.type = type;
    }
    @Override
    public String getActee() { throw new UnsupportedOperationException(); }
    @Override
    public String getActeeName() { throw new UnsupportedOperationException(); }
    @Override
    public String getActeeType() { throw new UnsupportedOperationException(); }
    @Override
    public String getActor() { throw new UnsupportedOperationException(); }
    @Override
    public String getActorName() { throw new UnsupportedOperationException(); }
    @Override
    public String getActorType() { throw new UnsupportedOperationException(); }
    @Override
    public String getActorUserName() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Optional<Object>> getMetadatas() { throw new UnsupportedOperationException(); }
    @Override
    public String getOrganizationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getSpaceId() { throw new UnsupportedOperationException(); }
    @Override
    public String getTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static EventEntity fromJson(Json json) {
    EventEntity.Builder builder = EventEntity.builder();
    if (json.actee != null) {
      builder.actee(json.actee);
    }
    if (json.acteeName != null) {
      builder.acteeName(json.acteeName);
    }
    if (json.acteeType != null) {
      builder.acteeType(json.acteeType);
    }
    if (json.actor != null) {
      builder.actor(json.actor);
    }
    if (json.actorName != null) {
      builder.actorName(json.actorName);
    }
    if (json.actorType != null) {
      builder.actorType(json.actorType);
    }
    if (json.actorUserName != null) {
      builder.actorUserName(json.actorUserName);
    }
    if (json.metadatas != null) {
      builder.putAllMetadatas(json.metadatas);
    }
    if (json.organizationId != null) {
      builder.organizationId(json.organizationId);
    }
    if (json.spaceId != null) {
      builder.spaceId(json.spaceId);
    }
    if (json.timestamp != null) {
      builder.timestamp(json.timestamp);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link EventEntity EventEntity}.
   * <pre>
   * EventEntity.builder()
   *    .actee(String | null) // nullable {@link EventEntity#getActee() actee}
   *    .acteeName(String | null) // nullable {@link EventEntity#getActeeName() acteeName}
   *    .acteeType(String | null) // nullable {@link EventEntity#getActeeType() acteeType}
   *    .actor(String | null) // nullable {@link EventEntity#getActor() actor}
   *    .actorName(String | null) // nullable {@link EventEntity#getActorName() actorName}
   *    .actorType(String | null) // nullable {@link EventEntity#getActorType() actorType}
   *    .actorUserName(String | null) // nullable {@link EventEntity#getActorUserName() actorUserName}
   *    .metadatas(Map&amp;lt;String, Optional&amp;lt;Object&amp;gt;&amp;gt; | null) // nullable {@link EventEntity#getMetadatas() metadatas}
   *    .organizationId(String | null) // nullable {@link EventEntity#getOrganizationId() organizationId}
   *    .spaceId(String | null) // nullable {@link EventEntity#getSpaceId() spaceId}
   *    .timestamp(String | null) // nullable {@link EventEntity#getTimestamp() timestamp}
   *    .type(String | null) // nullable {@link EventEntity#getType() type}
   *    .build();
   * </pre>
   * @return A new EventEntity builder
   */
  public static EventEntity.Builder builder() {
    return new EventEntity.Builder();
  }

  /**
   * Builds instances of type {@link EventEntity EventEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_EventEntity", generator = "Immutables")
  public static final class Builder {
    private String actee;
    private String acteeName;
    private String acteeType;
    private String actor;
    private String actorName;
    private String actorType;
    private String actorUserName;
    private Map<String, Optional<Object>> metadatas = null;
    private String organizationId;
    private String spaceId;
    private String timestamp;
    private String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EventEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EventEntity instance) {
      return from((_EventEntity) instance);
    }

    /**
     * Copy abstract value type {@code _EventEntity} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_EventEntity instance) {
      Objects.requireNonNull(instance, "instance");
      String acteeValue = instance.getActee();
      if (acteeValue != null) {
        actee(acteeValue);
      }
      String acteeNameValue = instance.getActeeName();
      if (acteeNameValue != null) {
        acteeName(acteeNameValue);
      }
      String acteeTypeValue = instance.getActeeType();
      if (acteeTypeValue != null) {
        acteeType(acteeTypeValue);
      }
      String actorValue = instance.getActor();
      if (actorValue != null) {
        actor(actorValue);
      }
      String actorNameValue = instance.getActorName();
      if (actorNameValue != null) {
        actorName(actorNameValue);
      }
      String actorTypeValue = instance.getActorType();
      if (actorTypeValue != null) {
        actorType(actorTypeValue);
      }
      String actorUserNameValue = instance.getActorUserName();
      if (actorUserNameValue != null) {
        actorUserName(actorUserNameValue);
      }
      Map<String, Optional<Object>> metadatasValue = instance.getMetadatas();
      if (metadatasValue != null) {
        putAllMetadatas(metadatasValue);
      }
      String organizationIdValue = instance.getOrganizationId();
      if (organizationIdValue != null) {
        organizationId(organizationIdValue);
      }
      String spaceIdValue = instance.getSpaceId();
      if (spaceIdValue != null) {
        spaceId(spaceIdValue);
      }
      String timestampValue = instance.getTimestamp();
      if (timestampValue != null) {
        timestamp(timestampValue);
      }
      String typeValue = instance.getType();
      if (typeValue != null) {
        type(typeValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActee() actee} attribute.
     * @param actee The value for actee (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actee")
    public final Builder actee(@Nullable String actee) {
      this.actee = actee;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActeeName() acteeName} attribute.
     * @param acteeName The value for acteeName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actee_name")
    public final Builder acteeName(@Nullable String acteeName) {
      this.acteeName = acteeName;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActeeType() acteeType} attribute.
     * @param acteeType The value for acteeType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actee_type")
    public final Builder acteeType(@Nullable String acteeType) {
      this.acteeType = acteeType;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActor() actor} attribute.
     * @param actor The value for actor (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actor")
    public final Builder actor(@Nullable String actor) {
      this.actor = actor;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActorName() actorName} attribute.
     * @param actorName The value for actorName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actor_name")
    public final Builder actorName(@Nullable String actorName) {
      this.actorName = actorName;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActorType() actorType} attribute.
     * @param actorType The value for actorType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actor_type")
    public final Builder actorType(@Nullable String actorType) {
      this.actorType = actorType;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getActorUserName() actorUserName} attribute.
     * @param actorUserName The value for actorUserName (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("actor_username")
    public final Builder actorUserName(@Nullable String actorUserName) {
      this.actorUserName = actorUserName;
      return this;
    }

    /**
     * Put one entry to the {@link EventEntity#getMetadatas() metadatas} map.
     * @param key The key in the metadatas map
     * @param value The associated value in the metadatas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(String key, Optional<Object> value) {
      if (this.metadatas == null) {
        this.metadatas = new LinkedHashMap<String, Optional<Object>>();
      }
      this.metadatas.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link EventEntity#getMetadatas() metadatas} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder metadata(Map.Entry<String, ? extends Optional<Object>> entry) {
      if (this.metadatas == null) {
        this.metadatas = new LinkedHashMap<String, Optional<Object>>();
      }
      String k = entry.getKey();
      Optional<Object> v = entry.getValue();
      this.metadatas.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link EventEntity#getMetadatas() metadatas} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the metadatas map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadatas(@Nullable Map<String, ? extends Optional<Object>> entries) {
      if (entries == null) {
        this.metadatas = null;
        return this;
      }
      this.metadatas = new LinkedHashMap<String, Optional<Object>>();
      return putAllMetadatas(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link EventEntity#getMetadatas() metadatas} map. Nulls are not permitted
     * @param entries The entries that will be added to the metadatas map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMetadatas(Map<String, ? extends Optional<Object>> entries) {
      if (this.metadatas == null) {
        this.metadatas = new LinkedHashMap<String, Optional<Object>>();
      }
      for (Map.Entry<String, ? extends Optional<Object>> e : entries.entrySet()) {
        String k = e.getKey();
        Optional<Object> v = e.getValue();
        this.metadatas.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getOrganizationId() organizationId} attribute.
     * @param organizationId The value for organizationId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("organization_guid")
    public final Builder organizationId(@Nullable String organizationId) {
      this.organizationId = organizationId;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getSpaceId() spaceId} attribute.
     * @param spaceId The value for spaceId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space_guid")
    public final Builder spaceId(@Nullable String spaceId) {
      this.spaceId = spaceId;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getTimestamp() timestamp} attribute.
     * @param timestamp The value for timestamp (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("timestamp")
    public final Builder timestamp(@Nullable String timestamp) {
      this.timestamp = timestamp;
      return this;
    }

    /**
     * Initializes the value for the {@link EventEntity#getType() type} attribute.
     * @param type The value for type (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(@Nullable String type) {
      this.type = type;
      return this;
    }

    /**
     * Builds a new {@link EventEntity EventEntity}.
     * @return An immutable instance of EventEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public EventEntity build() {
      return new EventEntity(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
