package org.cloudfoundry.client.v2.spacequotadefinitions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v2.Metadata;
import org.immutables.value.Generated;

/**
 * The response payload for the Retrieve a Particular Space Quota Definition operation
 */
@Generated(from = "_GetSpaceQuotaDefinitionResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetSpaceQuotaDefinitionResponse
    extends org.cloudfoundry.client.v2.spacequotadefinitions._GetSpaceQuotaDefinitionResponse {
  private final @Nullable SpaceQuotaDefinitionEntity entity;
  private final @Nullable Metadata metadata;

  private GetSpaceQuotaDefinitionResponse(GetSpaceQuotaDefinitionResponse.Builder builder) {
    this.entity = builder.entity;
    this.metadata = builder.metadata;
  }

  /**
   * The resource's entity
   */
  @JsonProperty("entity")
  @Override
  public @Nullable SpaceQuotaDefinitionEntity getEntity() {
    return entity;
  }

  /**
   * The resource's metadata
   */
  @JsonProperty("metadata")
  @Override
  public @Nullable Metadata getMetadata() {
    return metadata;
  }

  /**
   * This instance is equal to all instances of {@code GetSpaceQuotaDefinitionResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetSpaceQuotaDefinitionResponse
        && equalTo((GetSpaceQuotaDefinitionResponse) another);
  }

  private boolean equalTo(GetSpaceQuotaDefinitionResponse another) {
    return Objects.equals(entity, another.entity)
        && Objects.equals(metadata, another.metadata);
  }

  /**
   * Computes a hash code from attributes: {@code entity}, {@code metadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(entity);
    h += (h << 5) + Objects.hashCode(metadata);
    return h;
  }

  /**
   * Prints the immutable value {@code GetSpaceQuotaDefinitionResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetSpaceQuotaDefinitionResponse{"
        + "entity=" + entity
        + ", metadata=" + metadata
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetSpaceQuotaDefinitionResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v2.spacequotadefinitions._GetSpaceQuotaDefinitionResponse {
    SpaceQuotaDefinitionEntity entity;
    Metadata metadata;
    @JsonProperty("entity")
    public void setEntity(@Nullable SpaceQuotaDefinitionEntity entity) {
      this.entity = entity;
    }
    @JsonProperty("metadata")
    public void setMetadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
    }
    @Override
    public SpaceQuotaDefinitionEntity getEntity() { throw new UnsupportedOperationException(); }
    @Override
    public Metadata getMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetSpaceQuotaDefinitionResponse fromJson(Json json) {
    GetSpaceQuotaDefinitionResponse.Builder builder = GetSpaceQuotaDefinitionResponse.builder();
    if (json.entity != null) {
      builder.entity(json.entity);
    }
    if (json.metadata != null) {
      builder.metadata(json.metadata);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetSpaceQuotaDefinitionResponse GetSpaceQuotaDefinitionResponse}.
   * <pre>
   * GetSpaceQuotaDefinitionResponse.builder()
   *    .entity(org.cloudfoundry.client.v2.spacequotadefinitions.SpaceQuotaDefinitionEntity | null) // nullable {@link GetSpaceQuotaDefinitionResponse#getEntity() entity}
   *    .metadata(org.cloudfoundry.client.v2.Metadata | null) // nullable {@link GetSpaceQuotaDefinitionResponse#getMetadata() metadata}
   *    .build();
   * </pre>
   * @return A new GetSpaceQuotaDefinitionResponse builder
   */
  public static GetSpaceQuotaDefinitionResponse.Builder builder() {
    return new GetSpaceQuotaDefinitionResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetSpaceQuotaDefinitionResponse GetSpaceQuotaDefinitionResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetSpaceQuotaDefinitionResponse", generator = "Immutables")
  public static final class Builder {
    private SpaceQuotaDefinitionEntity entity;
    private Metadata metadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetSpaceQuotaDefinitionResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetSpaceQuotaDefinitionResponse instance) {
      return from((_GetSpaceQuotaDefinitionResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetSpaceQuotaDefinitionResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetSpaceQuotaDefinitionResponse instance) {
      Objects.requireNonNull(instance, "instance");
      SpaceQuotaDefinitionEntity entityValue = instance.getEntity();
      if (entityValue != null) {
        entity(entityValue);
      }
      Metadata metadataValue = instance.getMetadata();
      if (metadataValue != null) {
        metadata(metadataValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetSpaceQuotaDefinitionResponse#getEntity() entity} attribute.
     * @param entity The value for entity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("entity")
    public final Builder entity(@Nullable SpaceQuotaDefinitionEntity entity) {
      this.entity = entity;
      return this;
    }

    /**
     * Initializes the value for the {@link GetSpaceQuotaDefinitionResponse#getMetadata() metadata} attribute.
     * @param metadata The value for metadata (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("metadata")
    public final Builder metadata(@Nullable Metadata metadata) {
      this.metadata = metadata;
      return this;
    }

    /**
     * Builds a new {@link GetSpaceQuotaDefinitionResponse GetSpaceQuotaDefinitionResponse}.
     * @return An immutable instance of GetSpaceQuotaDefinitionResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetSpaceQuotaDefinitionResponse build() {
      return new GetSpaceQuotaDefinitionResponse(this);
    }
  }
}
