package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.processes.ProcessStatisticsResource;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Detailed Stats for an Application's Process operation
 */
@Generated(from = "_GetApplicationProcessStatisticsResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetApplicationProcessStatisticsResponse
    extends org.cloudfoundry.client.v3.applications._GetApplicationProcessStatisticsResponse {
  private final @Nullable List<ProcessStatisticsResource> resources;

  private GetApplicationProcessStatisticsResponse(GetApplicationProcessStatisticsResponse.Builder builder) {
    this.resources = builder.resources == null ? null : createUnmodifiableList(true, builder.resources);
  }

  /**
   * The resources
   */
  @JsonProperty("resources")
  @Override
  public @Nullable List<ProcessStatisticsResource> getResources() {
    return resources;
  }

  /**
   * This instance is equal to all instances of {@code GetApplicationProcessStatisticsResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetApplicationProcessStatisticsResponse
        && equalTo((GetApplicationProcessStatisticsResponse) another);
  }

  private boolean equalTo(GetApplicationProcessStatisticsResponse another) {
    return Objects.equals(resources, another.resources);
  }

  /**
   * Computes a hash code from attributes: {@code resources}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(resources);
    return h;
  }

  /**
   * Prints the immutable value {@code GetApplicationProcessStatisticsResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetApplicationProcessStatisticsResponse{"
        + "resources=" + resources
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetApplicationProcessStatisticsResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.applications._GetApplicationProcessStatisticsResponse {
    List<ProcessStatisticsResource> resources = null;
    @JsonProperty("resources")
    public void setResources(@Nullable List<ProcessStatisticsResource> resources) {
      this.resources = resources;
    }
    @Override
    public List<ProcessStatisticsResource> getResources() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetApplicationProcessStatisticsResponse fromJson(Json json) {
    GetApplicationProcessStatisticsResponse.Builder builder = GetApplicationProcessStatisticsResponse.builder();
    if (json.resources != null) {
      builder.addAllResources(json.resources);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetApplicationProcessStatisticsResponse GetApplicationProcessStatisticsResponse}.
   * <pre>
   * GetApplicationProcessStatisticsResponse.builder()
   *    .resources(List&amp;lt;org.cloudfoundry.client.v3.processes.ProcessStatisticsResource&amp;gt; | null) // nullable {@link GetApplicationProcessStatisticsResponse#getResources() resources}
   *    .build();
   * </pre>
   * @return A new GetApplicationProcessStatisticsResponse builder
   */
  public static GetApplicationProcessStatisticsResponse.Builder builder() {
    return new GetApplicationProcessStatisticsResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetApplicationProcessStatisticsResponse GetApplicationProcessStatisticsResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetApplicationProcessStatisticsResponse", generator = "Immutables")
  public static final class Builder {
    private List<ProcessStatisticsResource> resources = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetApplicationProcessStatisticsResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetApplicationProcessStatisticsResponse instance) {
      return from((_GetApplicationProcessStatisticsResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetApplicationProcessStatisticsResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetApplicationProcessStatisticsResponse instance) {
      Objects.requireNonNull(instance, "instance");
      List<ProcessStatisticsResource> resourcesValue = instance.getResources();
      if (resourcesValue != null) {
        addAllResources(resourcesValue);
      }
      return this;
    }

    /**
     * Adds one element to {@link GetApplicationProcessStatisticsResponse#getResources() resources} list.
     * @param element A resources element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resource(ProcessStatisticsResource element) {
      if (this.resources == null) {
        this.resources = new ArrayList<ProcessStatisticsResource>();
      }
      this.resources.add(Objects.requireNonNull(element, "resources element"));
      return this;
    }

    /**
     * Adds elements to {@link GetApplicationProcessStatisticsResponse#getResources() resources} list.
     * @param elements An array of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder resources(ProcessStatisticsResource... elements) {
      if (this.resources == null) {
        this.resources = new ArrayList<ProcessStatisticsResource>();
      }
      for (ProcessStatisticsResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GetApplicationProcessStatisticsResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("resources")
    public final Builder resources(@Nullable Iterable<? extends ProcessStatisticsResource> elements) {
      if (elements == null) {
        this.resources = null;
        return this;
      }
      this.resources = new ArrayList<ProcessStatisticsResource>();
      return addAllResources(elements);
    }

    /**
     * Adds elements to {@link GetApplicationProcessStatisticsResponse#getResources() resources} list.
     * @param elements An iterable of resources elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllResources(Iterable<? extends ProcessStatisticsResource> elements) {
      Objects.requireNonNull(elements, "resources element");
      if (this.resources == null) {
        this.resources = new ArrayList<ProcessStatisticsResource>();
      }
      for (ProcessStatisticsResource element : elements) {
        this.resources.add(Objects.requireNonNull(element, "resources element"));
      }
      return this;
    }

    /**
     * Builds a new {@link GetApplicationProcessStatisticsResponse GetApplicationProcessStatisticsResponse}.
     * @return An immutable instance of GetApplicationProcessStatisticsResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetApplicationProcessStatisticsResponse build() {
      return new GetApplicationProcessStatisticsResponse(this);
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
