package org.cloudfoundry.client.v3.applications;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * The request payload for the Update Application Feature operation.
 */
@Generated(from = "_UpdateApplicationFeatureRequest", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class UpdateApplicationFeatureRequest
    extends org.cloudfoundry.client.v3.applications._UpdateApplicationFeatureRequest {
  private final String applicationId;
  private final String featureName;
  private final Boolean enabled;

  private UpdateApplicationFeatureRequest(UpdateApplicationFeatureRequest.Builder builder) {
    this.applicationId = builder.applicationId;
    this.featureName = builder.featureName;
    this.enabled = builder.enabled;
  }

  /**
   * The id of the application
   */
  @JsonProperty("applicationId")
  @JsonIgnore
  @Override
  public String getApplicationId() {
    return applicationId;
  }

  /**
   * The feature name
   */
  @JsonProperty("featureName")
  @JsonIgnore
  @Override
  public String getFeatureName() {
    return featureName;
  }

  /**
   * Denotes whether or not the app feature should be enabled
   */
  @JsonProperty("enabled")
  @Override
  public Boolean getEnabled() {
    return enabled;
  }

  /**
   * This instance is equal to all instances of {@code UpdateApplicationFeatureRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UpdateApplicationFeatureRequest
        && equalTo((UpdateApplicationFeatureRequest) another);
  }

  private boolean equalTo(UpdateApplicationFeatureRequest another) {
    return applicationId.equals(another.applicationId)
        && featureName.equals(another.featureName)
        && enabled.equals(another.enabled);
  }

  /**
   * Computes a hash code from attributes: {@code applicationId}, {@code featureName}, {@code enabled}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + applicationId.hashCode();
    h += (h << 5) + featureName.hashCode();
    h += (h << 5) + enabled.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UpdateApplicationFeatureRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UpdateApplicationFeatureRequest{"
        + "applicationId=" + applicationId
        + ", featureName=" + featureName
        + ", enabled=" + enabled
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_UpdateApplicationFeatureRequest", generator = "Immutables")
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.applications._UpdateApplicationFeatureRequest {
    String applicationId;
    String featureName;
    Boolean enabled;
    @JsonProperty("applicationId")
    @JsonIgnore
    public void setApplicationId(String applicationId) {
      this.applicationId = applicationId;
    }
    @JsonProperty("featureName")
    @JsonIgnore
    public void setFeatureName(String featureName) {
      this.featureName = featureName;
    }
    @JsonProperty("enabled")
    public void setEnabled(Boolean enabled) {
      this.enabled = enabled;
    }
    @Override
    public String getApplicationId() { throw new UnsupportedOperationException(); }
    @Override
    public String getFeatureName() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getEnabled() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static UpdateApplicationFeatureRequest fromJson(Json json) {
    UpdateApplicationFeatureRequest.Builder builder = UpdateApplicationFeatureRequest.builder();
    if (json.applicationId != null) {
      builder.applicationId(json.applicationId);
    }
    if (json.featureName != null) {
      builder.featureName(json.featureName);
    }
    if (json.enabled != null) {
      builder.enabled(json.enabled);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link UpdateApplicationFeatureRequest UpdateApplicationFeatureRequest}.
   * <pre>
   * UpdateApplicationFeatureRequest.builder()
   *    .applicationId(String) // required {@link UpdateApplicationFeatureRequest#getApplicationId() applicationId}
   *    .featureName(String) // required {@link UpdateApplicationFeatureRequest#getFeatureName() featureName}
   *    .enabled(Boolean) // required {@link UpdateApplicationFeatureRequest#getEnabled() enabled}
   *    .build();
   * </pre>
   * @return A new UpdateApplicationFeatureRequest builder
   */
  public static UpdateApplicationFeatureRequest.Builder builder() {
    return new UpdateApplicationFeatureRequest.Builder();
  }

  /**
   * Builds instances of type {@link UpdateApplicationFeatureRequest UpdateApplicationFeatureRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_UpdateApplicationFeatureRequest", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_APPLICATION_ID = 0x1L;
    private static final long INIT_BIT_FEATURE_NAME = 0x2L;
    private static final long INIT_BIT_ENABLED = 0x4L;
    private long initBits = 0x7L;

    private String applicationId;
    private String featureName;
    private Boolean enabled;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UpdateApplicationFeatureRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UpdateApplicationFeatureRequest instance) {
      return from((_UpdateApplicationFeatureRequest) instance);
    }

    /**
     * Copy abstract value type {@code _UpdateApplicationFeatureRequest} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_UpdateApplicationFeatureRequest instance) {
      Objects.requireNonNull(instance, "instance");
      applicationId(instance.getApplicationId());
      featureName(instance.getFeatureName());
      enabled(instance.getEnabled());
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationFeatureRequest#getApplicationId() applicationId} attribute.
     * @param applicationId The value for applicationId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder applicationId(String applicationId) {
      this.applicationId = Objects.requireNonNull(applicationId, "applicationId");
      initBits &= ~INIT_BIT_APPLICATION_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationFeatureRequest#getFeatureName() featureName} attribute.
     * @param featureName The value for featureName 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder featureName(String featureName) {
      this.featureName = Objects.requireNonNull(featureName, "featureName");
      initBits &= ~INIT_BIT_FEATURE_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link UpdateApplicationFeatureRequest#getEnabled() enabled} attribute.
     * @param enabled The value for enabled 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder enabled(Boolean enabled) {
      this.enabled = Objects.requireNonNull(enabled, "enabled");
      initBits &= ~INIT_BIT_ENABLED;
      return this;
    }

    /**
     * Builds a new {@link UpdateApplicationFeatureRequest UpdateApplicationFeatureRequest}.
     * @return An immutable instance of UpdateApplicationFeatureRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UpdateApplicationFeatureRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new UpdateApplicationFeatureRequest(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_APPLICATION_ID) != 0) attributes.add("applicationId");
      if ((initBits & INIT_BIT_FEATURE_NAME) != 0) attributes.add("featureName");
      if ((initBits & INIT_BIT_ENABLED) != 0) attributes.add("enabled");
      return "Cannot build UpdateApplicationFeatureRequest, some of required attributes are not set " + attributes;
    }
  }
}
