package org.cloudfoundry.client.v3.organizations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.Link;
import org.cloudfoundry.client.v3.UsageSummary;
import org.immutables.value.Generated;

/**
 * The response payload for the Get Organization Usage Summary operation
 */
@Generated(from = "_GetOrganizationUsageSummaryResponse", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class GetOrganizationUsageSummaryResponse
    extends org.cloudfoundry.client.v3.organizations._GetOrganizationUsageSummaryResponse {
  private final @Nullable Map<String, Link> links;
  private final @Nullable UsageSummary usageSummary;

  private GetOrganizationUsageSummaryResponse(GetOrganizationUsageSummaryResponse.Builder builder) {
    this.links = builder.links == null ? null : createUnmodifiableMap(false, false, builder.links);
    this.usageSummary = builder.usageSummary;
  }

  /**
   * The links
   */
  @JsonProperty("links")
  @Override
  public @Nullable Map<String, Link> getLinks() {
    return links;
  }

  /**
   * The entitled organizations
   */
  @JsonProperty("usage_summary")
  @Override
  public @Nullable UsageSummary getUsageSummary() {
    return usageSummary;
  }

  /**
   * This instance is equal to all instances of {@code GetOrganizationUsageSummaryResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof GetOrganizationUsageSummaryResponse
        && equalTo((GetOrganizationUsageSummaryResponse) another);
  }

  private boolean equalTo(GetOrganizationUsageSummaryResponse another) {
    return Objects.equals(links, another.links)
        && Objects.equals(usageSummary, another.usageSummary);
  }

  /**
   * Computes a hash code from attributes: {@code links}, {@code usageSummary}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(links);
    h += (h << 5) + Objects.hashCode(usageSummary);
    return h;
  }

  /**
   * Prints the immutable value {@code GetOrganizationUsageSummaryResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GetOrganizationUsageSummaryResponse{"
        + "links=" + links
        + ", usageSummary=" + usageSummary
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_GetOrganizationUsageSummaryResponse", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends org.cloudfoundry.client.v3.organizations._GetOrganizationUsageSummaryResponse {
    Map<String, Link> links = null;
    UsageSummary usageSummary;
    @JsonProperty("links")
    public void setLinks(@Nullable Map<String, Link> links) {
      this.links = links;
    }
    @JsonProperty("usage_summary")
    public void setUsageSummary(@Nullable UsageSummary usageSummary) {
      this.usageSummary = usageSummary;
    }
    @Override
    public Map<String, Link> getLinks() { throw new UnsupportedOperationException(); }
    @Override
    public UsageSummary getUsageSummary() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static GetOrganizationUsageSummaryResponse fromJson(Json json) {
    GetOrganizationUsageSummaryResponse.Builder builder = GetOrganizationUsageSummaryResponse.builder();
    if (json.links != null) {
      builder.putAllLinks(json.links);
    }
    if (json.usageSummary != null) {
      builder.usageSummary(json.usageSummary);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link GetOrganizationUsageSummaryResponse GetOrganizationUsageSummaryResponse}.
   * <pre>
   * GetOrganizationUsageSummaryResponse.builder()
   *    .links(Map&amp;lt;String, org.cloudfoundry.client.v3.Link&amp;gt; | null) // nullable {@link GetOrganizationUsageSummaryResponse#getLinks() links}
   *    .usageSummary(org.cloudfoundry.client.v3.UsageSummary | null) // nullable {@link GetOrganizationUsageSummaryResponse#getUsageSummary() usageSummary}
   *    .build();
   * </pre>
   * @return A new GetOrganizationUsageSummaryResponse builder
   */
  public static GetOrganizationUsageSummaryResponse.Builder builder() {
    return new GetOrganizationUsageSummaryResponse.Builder();
  }

  /**
   * Builds instances of type {@link GetOrganizationUsageSummaryResponse GetOrganizationUsageSummaryResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_GetOrganizationUsageSummaryResponse", generator = "Immutables")
  public static final class Builder {
    private Map<String, Link> links = null;
    private UsageSummary usageSummary;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GetOrganizationUsageSummaryResponse} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(GetOrganizationUsageSummaryResponse instance) {
      return from((_GetOrganizationUsageSummaryResponse) instance);
    }

    /**
     * Copy abstract value type {@code _GetOrganizationUsageSummaryResponse} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_GetOrganizationUsageSummaryResponse instance) {
      Objects.requireNonNull(instance, "instance");
      Map<String, Link> linksValue = instance.getLinks();
      if (linksValue != null) {
        putAllLinks(linksValue);
      }
      UsageSummary usageSummaryValue = instance.getUsageSummary();
      if (usageSummaryValue != null) {
        usageSummary(usageSummaryValue);
      }
      return this;
    }

    /**
     * Put one entry to the {@link GetOrganizationUsageSummaryResponse#getLinks() links} map.
     * @param key The key in the links map
     * @param value The associated value in the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(String key, Link value) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      this.links.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link GetOrganizationUsageSummaryResponse#getLinks() links} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder link(Map.Entry<String, ? extends Link> entry) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      String k = entry.getKey();
      Link v = entry.getValue();
      this.links.put(k, v);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link GetOrganizationUsageSummaryResponse#getLinks() links} map. Nulls are not permitted as keys or values, but parameter itself can be null
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("links")
    public final Builder links(@Nullable Map<String, ? extends Link> entries) {
      if (entries == null) {
        this.links = null;
        return this;
      }
      this.links = new LinkedHashMap<String, Link>();
      return putAllLinks(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link GetOrganizationUsageSummaryResponse#getLinks() links} map. Nulls are not permitted
     * @param entries The entries that will be added to the links map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllLinks(Map<String, ? extends Link> entries) {
      if (this.links == null) {
        this.links = new LinkedHashMap<String, Link>();
      }
      for (Map.Entry<String, ? extends Link> e : entries.entrySet()) {
        String k = e.getKey();
        Link v = e.getValue();
        this.links.put(k, v);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link GetOrganizationUsageSummaryResponse#getUsageSummary() usageSummary} attribute.
     * @param usageSummary The value for usageSummary (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("usage_summary")
    public final Builder usageSummary(@Nullable UsageSummary usageSummary) {
      this.usageSummary = usageSummary;
      return this;
    }

    /**
     * Builds a new {@link GetOrganizationUsageSummaryResponse GetOrganizationUsageSummaryResponse}.
     * @return An immutable instance of GetOrganizationUsageSummaryResponse
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public GetOrganizationUsageSummaryResponse build() {
      return new GetOrganizationUsageSummaryResponse(this);
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
