package org.cloudfoundry.client.v3.serviceInstances;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.cloudfoundry.Nullable;
import org.cloudfoundry.client.v3.ToOneRelationship;
import org.immutables.value.Generated;

/**
 * The service instance relationship
 */
@Generated(from = "_ServiceInstanceRelationships", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
public final class ServiceInstanceRelationships
    extends org.cloudfoundry.client.v3.serviceInstances._ServiceInstanceRelationships {
  private final @Nullable ToOneRelationship servicePlan;
  private final ToOneRelationship space;

  private ServiceInstanceRelationships(ServiceInstanceRelationships.Builder builder) {
    this.servicePlan = builder.servicePlan;
    this.space = builder.space;
  }

  /**
   * The space relationship
   */
  @JsonProperty("service_plan")
  @Override
  public @Nullable ToOneRelationship getServicePlan() {
    return servicePlan;
  }

  /**
   * The space relationship
   */
  @JsonProperty("space")
  @Override
  public ToOneRelationship getSpace() {
    return space;
  }

  /**
   * This instance is equal to all instances of {@code ServiceInstanceRelationships} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ServiceInstanceRelationships
        && equalTo((ServiceInstanceRelationships) another);
  }

  private boolean equalTo(ServiceInstanceRelationships another) {
    return Objects.equals(servicePlan, another.servicePlan)
        && space.equals(another.space);
  }

  /**
   * Computes a hash code from attributes: {@code servicePlan}, {@code space}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(servicePlan);
    h += (h << 5) + space.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ServiceInstanceRelationships} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ServiceInstanceRelationships{"
        + "servicePlan=" + servicePlan
        + ", space=" + space
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "_ServiceInstanceRelationships", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends org.cloudfoundry.client.v3.serviceInstances._ServiceInstanceRelationships {
    ToOneRelationship servicePlan;
    ToOneRelationship space;
    @JsonProperty("service_plan")
    public void setServicePlan(@Nullable ToOneRelationship servicePlan) {
      this.servicePlan = servicePlan;
    }
    @JsonProperty("space")
    public void setSpace(ToOneRelationship space) {
      this.space = space;
    }
    @Override
    public ToOneRelationship getServicePlan() { throw new UnsupportedOperationException(); }
    @Override
    public ToOneRelationship getSpace() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ServiceInstanceRelationships fromJson(Json json) {
    ServiceInstanceRelationships.Builder builder = ServiceInstanceRelationships.builder();
    if (json.servicePlan != null) {
      builder.servicePlan(json.servicePlan);
    }
    if (json.space != null) {
      builder.space(json.space);
    }
    return builder.build();
  }

  /**
   * Creates a builder for {@link ServiceInstanceRelationships ServiceInstanceRelationships}.
   * <pre>
   * ServiceInstanceRelationships.builder()
   *    .servicePlan(org.cloudfoundry.client.v3.ToOneRelationship | null) // nullable {@link ServiceInstanceRelationships#getServicePlan() servicePlan}
   *    .space(org.cloudfoundry.client.v3.ToOneRelationship) // required {@link ServiceInstanceRelationships#getSpace() space}
   *    .build();
   * </pre>
   * @return A new ServiceInstanceRelationships builder
   */
  public static ServiceInstanceRelationships.Builder builder() {
    return new ServiceInstanceRelationships.Builder();
  }

  /**
   * Builds instances of type {@link ServiceInstanceRelationships ServiceInstanceRelationships}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "_ServiceInstanceRelationships", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_SPACE = 0x1L;
    private long initBits = 0x1L;

    private ToOneRelationship servicePlan;
    private ToOneRelationship space;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ServiceInstanceRelationships} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ServiceInstanceRelationships instance) {
      return from((_ServiceInstanceRelationships) instance);
    }

    /**
     * Copy abstract value type {@code _ServiceInstanceRelationships} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    final Builder from(_ServiceInstanceRelationships instance) {
      Objects.requireNonNull(instance, "instance");
      ToOneRelationship servicePlanValue = instance.getServicePlan();
      if (servicePlanValue != null) {
        servicePlan(servicePlanValue);
      }
      space(instance.getSpace());
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceRelationships#getServicePlan() servicePlan} attribute.
     * @param servicePlan The value for servicePlan (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("service_plan")
    public final Builder servicePlan(@Nullable ToOneRelationship servicePlan) {
      this.servicePlan = servicePlan;
      return this;
    }

    /**
     * Initializes the value for the {@link ServiceInstanceRelationships#getSpace() space} attribute.
     * @param space The value for space 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("space")
    public final Builder space(ToOneRelationship space) {
      this.space = Objects.requireNonNull(space, "space");
      initBits &= ~INIT_BIT_SPACE;
      return this;
    }

    /**
     * Builds a new {@link ServiceInstanceRelationships ServiceInstanceRelationships}.
     * @return An immutable instance of ServiceInstanceRelationships
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ServiceInstanceRelationships build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ServiceInstanceRelationships(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_SPACE) != 0) attributes.add("space");
      return "Cannot build ServiceInstanceRelationships, some of required attributes are not set " + attributes;
    }
  }
}
